/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NumberUtils;
import com.alibaba.fastjson2.util.StringUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import sun.misc.Unsafe;

class JSONWriterUTF16
extends JSONWriter {
    static final long BYTE_VEC_64_SINGLE_QUOTE = 0x27002700270027L;
    static final long BYTE_VEC_64_DOUBLE_QUOTE = 0x22002200220022L;
    static final long REF_0;
    static final long REF_1;
    static final int QUOTE2_COLON;
    static final int QUOTE_COLON;
    static final int[] HEX256;
    protected char[] chars;
    final JSONFactory.CacheItem cacheItem;
    protected final long byteVectorQuote;

    JSONWriterUTF16(JSONWriter.Context ctx) {
        super(ctx, null, false, StandardCharsets.UTF_16);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
        if (chars == null) {
            chars = new char[8192];
        }
        this.chars = chars;
        this.byteVectorQuote = this.useSingleQuote ? -2821266740684990248L : -2459565876494606883L;
    }

    @Override
    public final void writeNull() {
        int off = this.off;
        int minCapacity = off + 4;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        IOUtils.putNULL(chars, off);
        this.off = off + 4;
    }

    @Override
    public final void flushTo(Writer to) {
        try {
            int off = this.off;
            if (off > 0) {
                to.write(this.chars, 0, off);
                this.off = 0;
            }
        }
        catch (IOException e) {
            throw new JSONException("flushTo error", e);
        }
    }

    @Override
    public final void close() {
        char[] chars = this.chars;
        if (chars.length > 0x800000) {
            return;
        }
        JSONFactory.CHARS_UPDATER.lazySet(this.cacheItem, chars);
    }

    @Override
    protected final void write0(char c) {
        int off = this.off;
        char[] chars = this.chars;
        if (off == chars.length) {
            chars = this.grow(off + 1);
        }
        chars[off] = c;
        this.off = off + 1;
    }

    @Override
    public final void writeColon() {
        int off = this.off;
        char[] chars = this.chars;
        if (off == chars.length) {
            chars = this.grow(off + 1);
        }
        chars[off] = 58;
        this.off = off + 1;
    }

    @Override
    public final void startObject() {
        if (++this.level > this.context.maxLevel) {
            this.overflowLevel();
        }
        this.startObject = true;
        int off = this.off;
        int minCapacity = off + 3 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 123;
        if (this.pretty != 0) {
            off = this.indent(chars, off);
        }
        this.off = off;
    }

    @Override
    public final void endObject() {
        char[] chars;
        --this.level;
        int off = this.off;
        int minCapacity = off + 1 + (this.pretty == 0 ? 0 : this.pretty * this.level + 1);
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        if (this.pretty != 0) {
            off = this.indent(chars, off);
        }
        chars[off] = 125;
        this.off = off + 1;
        this.startObject = false;
    }

    @Override
    public final void writeComma() {
        this.startObject = false;
        int off = this.off;
        int minCapacity = off + 2 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 44;
        if (this.pretty != 0) {
            off = this.indent(chars, off);
        }
        this.off = off;
    }

    @Override
    public final void startArray() {
        char[] chars;
        int off;
        int minCapacity;
        if (++this.level > this.context.maxLevel) {
            this.overflowLevel();
        }
        if ((minCapacity = (off = this.off) + 3 + this.pretty * this.level) > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        if (this.pretty != 0) {
            off = this.indent(chars, off);
        }
        this.off = off;
    }

    @Override
    public final void endArray() {
        char[] chars;
        --this.level;
        int off = this.off;
        int minCapacity = off + 1 + (this.pretty == 0 ? 0 : this.pretty * this.level + 1);
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        if (this.pretty != 0) {
            off = this.indent(chars, off);
        }
        chars[off] = 93;
        this.off = off + 1;
        this.startObject = false;
    }

    @Override
    public final void writeString(List<String> list) {
        if (this.pretty != 0) {
            super.writeString(list);
            return;
        }
        if (this.off == this.chars.length) {
            this.grow(this.off + 1);
        }
        this.chars[this.off++] = 91;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (this.off == this.chars.length) {
                    this.grow(this.off + 1);
                }
                this.chars[this.off++] = 44;
            }
            this.writeString(list.get(i));
        }
        if (this.off == this.chars.length) {
            this.grow(this.off + 1);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public void writeStringLatin1(byte[] value) {
        long vec64;
        int coff;
        if ((this.context.features & 0x800000000L) != 0L) {
            this.writeStringLatin1BrowserSecure(value);
            return;
        }
        boolean escape = false;
        int off = this.off;
        int minCapacity = off + value.length + 2;
        char[] chars = this.chars;
        if (minCapacity >= chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = this.quote;
        long vecQuote = this.byteVectorQuote;
        int upperBound = value.length - coff & 0xFFFFFFF8;
        for (coff = 0; coff < upperBound && StringUtils.noneEscaped(vec64 = IOUtils.getLongLE(value, coff), vecQuote); coff += 8) {
            IOUtils.putLongLE(chars, off, JSONWriterUTF16.expand(vec64));
            IOUtils.putLongLE(chars, off + 4, JSONWriterUTF16.expand(vec64 >>> 32));
            off += 8;
        }
        if (!escape) {
            while (coff < value.length) {
                byte c = value[coff];
                if (c == 92 || c == this.quote || c < 32) {
                    escape = true;
                    break;
                }
                chars[off++] = (char)c;
                ++coff;
            }
        }
        if (!escape) {
            chars[off] = this.quote;
            this.off = off + 1;
            return;
        }
        if ((minCapacity += value.length * 5) >= chars.length) {
            chars = this.grow(minCapacity);
        }
        this.off = StringUtils.writeLatin1EscapedRest(chars, off, value, coff, this.quote, this.context.features);
    }

    static long expand(long i) {
        return i & 0xFFL | (i & 0xFF00L) << 8 | (i & 0xFF0000L) << 16 | (i & 0xFF000000L) << 24;
    }

    protected final void writeStringLatin1BrowserSecure(byte[] value) {
        boolean escape = false;
        int off = this.off;
        int minCapacity = off + value.length + 2;
        if (minCapacity >= this.chars.length) {
            this.grow(minCapacity);
        }
        int start = off;
        char[] chars = this.chars;
        chars[off++] = this.quote;
        for (byte c : value) {
            if (c == 92 || c == this.quote || c < 32 || c == 60 || c == 62 || c == 40 || c == 41) {
                escape = true;
                break;
            }
            chars[off++] = (char)c;
        }
        if (!escape) {
            chars[off] = this.quote;
            this.off = off + 1;
            return;
        }
        this.off = start;
        this.writeStringEscape(value);
    }

    @Override
    public void writeStringUTF16(byte[] value) {
        if (value == null) {
            this.writeStringNull();
            return;
        }
        if ((this.context.features & (JSONWriter.Feature.BrowserSecure.mask | JSONWriter.Feature.EscapeNoneAscii.mask)) != 0L) {
            this.writeStringUTF16BrowserSecure(value);
            return;
        }
        boolean escape = false;
        int off = this.off;
        int minCapacity = off + value.length + 2;
        if (minCapacity >= this.chars.length) {
            this.grow(minCapacity);
        }
        long vecQuote = this.byteVectorQuote;
        char[] chars = this.chars;
        chars[off++] = this.quote;
        int i = 0;
        int char_len = value.length >> 1;
        while (i < char_len) {
            char c;
            long v1;
            long v0;
            if (i + 8 < char_len && (((v0 = IOUtils.getLongLE(value, i << 1)) | (v1 = IOUtils.getLongLE(value, i + 4 << 1))) & 0xFF00FF00FF00FF00L) == 0L && StringUtils.noneEscaped(v0 << 8 | v1, vecQuote)) {
                IOUtils.putLongLE(chars, off, v0);
                IOUtils.putLongLE(chars, off + 4, v1);
                i += 8;
                off += 8;
                continue;
            }
            if ((c = IOUtils.getChar(value, i++)) == '\\' || c == this.quote || c < ' ') {
                escape = true;
                break;
            }
            chars[off++] = c;
        }
        if (!escape) {
            chars[off] = this.quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscapeUTF16(value);
    }

    final void writeStringBrowserSecure(char[] value) {
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean escape = false;
        int off = this.off;
        int minCapacity = off + value.length + 2;
        if (minCapacity >= this.chars.length) {
            this.grow(minCapacity);
        }
        char[] chars = this.chars;
        chars[off++] = this.quote;
        int char_len = value.length;
        for (int i = 0; i < char_len; ++i) {
            char c = IOUtils.getChar(value, i);
            if (c == '\\' || c == this.quote || c < ' ' || c == '<' || c == '>' || c == '(' || c == ')' || escapeNoneAscii && c > '\u007f') {
                escape = true;
                break;
            }
            chars[off++] = c;
        }
        if (!escape) {
            chars[off] = this.quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscape(value);
    }

    final void writeStringUTF16BrowserSecure(byte[] value) {
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean escape = false;
        int off = this.off;
        int minCapacity = off + value.length + 2;
        if (minCapacity >= this.chars.length) {
            this.grow(minCapacity);
        }
        char[] chars = this.chars;
        chars[off++] = this.quote;
        int char_len = value.length >> 1;
        for (int i = 0; i < char_len; ++i) {
            char c = IOUtils.getChar(value, i);
            if (c == '\\' || c == this.quote || c < ' ' || c == '<' || c == '>' || c == '(' || c == ')' || escapeNoneAscii && c > '\u007f') {
                escape = true;
                break;
            }
            chars[off++] = c;
        }
        if (!escape) {
            chars[off] = this.quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscapeUTF16(value);
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            this.writeStringNull();
            return;
        }
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escape = false;
        char quote = this.quote;
        int strlen = str.length();
        int minCapacity = this.off + strlen + 2;
        if (minCapacity >= this.chars.length) {
            this.grow(minCapacity);
        }
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c != '\\' && c != quote && c >= ' ' && (!browserSecure || c != '<' && c != '>' && c != '(' && c != ')') && (!escapeNoneAscii || c <= '\u007f')) continue;
            escape = true;
            break;
        }
        if (!escape) {
            int off = this.off;
            char[] chars = this.chars;
            chars[off++] = quote;
            str.getChars(0, strlen, chars, off);
            chars[off += strlen] = quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscape(str);
    }

    protected final void writeStringEscape(String str) {
        int strlen = str.length();
        char quote = this.quote;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        int off = this.off;
        this.ensureCapacityInternal(off + strlen * 6 + 2);
        char[] chars = this.chars;
        chars[off++] = quote;
        block6: for (int i = 0; i < strlen; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == quote) {
                        chars[off++] = 92;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    StringUtils.writeEscapedChar(chars, off, (int)ch);
                    off += 2;
                    continue block6;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    StringUtils.writeU4Hex2(chars, off, (int)ch);
                    off += 6;
                    continue block6;
                }
                case '(': 
                case ')': 
                case '<': 
                case '>': {
                    if (browserSecure) {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                }
            }
        }
        chars[off] = quote;
        this.off = off + 1;
    }

    protected final void writeStringEscapeUTF16(byte[] str) {
        int strlen = str.length;
        char quote = this.quote;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        int off = this.off;
        this.ensureCapacityInternal(off + strlen * 6 + 2);
        char[] chars = this.chars;
        chars[off++] = quote;
        block6: for (int i = 0; i < strlen; i += 2) {
            char ch = JDKUtils.UNSAFE.getChar(str, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)i);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == quote) {
                        chars[off++] = 92;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    StringUtils.writeEscapedChar(chars, off, (int)ch);
                    off += 2;
                    continue block6;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    StringUtils.writeU4Hex2(chars, off, (int)ch);
                    off += 6;
                    continue block6;
                }
                case '(': 
                case ')': 
                case '<': 
                case '>': {
                    if (browserSecure) {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                }
            }
        }
        chars[off] = quote;
        this.off = off + 1;
    }

    protected final void writeStringEscape(char[] str) {
        int strlen = str.length;
        char quote = this.quote;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        int off = this.off;
        this.ensureCapacityInternal(off + strlen * 6 + 2);
        char[] chars = this.chars;
        chars[off++] = quote;
        block6: for (int i = 0; i < str.length; ++i) {
            char ch = str[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == quote) {
                        chars[off++] = 92;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    StringUtils.writeEscapedChar(chars, off, (int)ch);
                    off += 2;
                    continue block6;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    StringUtils.writeU4Hex2(chars, off, (int)ch);
                    off += 6;
                    continue block6;
                }
                case '(': 
                case ')': 
                case '<': 
                case '>': {
                    if (browserSecure) {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                }
            }
        }
        chars[off] = quote;
        this.off = off + 1;
    }

    protected final void writeStringEscape(byte[] str) {
        int off = this.off;
        int minCapacity = off + str.length * 6 + 2;
        char[] chars = this.chars;
        if (minCapacity >= chars.length) {
            chars = this.grow(minCapacity);
        }
        char quote = this.quote;
        chars[off++] = quote;
        this.off = StringUtils.writeLatin1EscapedRest(chars, off, str, 0, quote, this.context.features);
    }

    @Override
    public final void writeString(char[] str, int offset, int len, boolean quoted) {
        int minCapacity;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        char quote = this.quote;
        int off = this.off;
        int n = minCapacity = quoted ? off + 2 : off;
        minCapacity = escapeNoneAscii ? (minCapacity += len * 6) : (minCapacity += len * 2);
        char[] chars = this.chars;
        if (minCapacity - chars.length > 0) {
            chars = this.grow(minCapacity);
        }
        if (quoted) {
            chars[off++] = quote;
        }
        block5: for (int i = offset; i < len; ++i) {
            char ch = str[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == quote) {
                        chars[off++] = 92;
                    }
                    chars[off++] = ch;
                    continue block5;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    StringUtils.writeEscapedChar(chars, off, (int)ch);
                    off += 2;
                    continue block5;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    StringUtils.writeU4Hex2(chars, off, (int)ch);
                    off += 6;
                    continue block5;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block5;
                    }
                    chars[off++] = ch;
                }
            }
        }
        if (quoted) {
            chars[off++] = quote;
        }
        this.off = off;
    }

    @Override
    public final void writeString(String[] strings) {
        if (this.pretty != 0 || strings == null) {
            super.writeString(strings);
            return;
        }
        if (this.off == this.chars.length) {
            this.grow(this.off + 1);
        }
        this.chars[this.off++] = 91;
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                if (this.off == this.chars.length) {
                    this.grow(this.off + 1);
                }
                this.chars[this.off++] = 44;
            }
            this.writeString(strings[i]);
        }
        if (this.off == this.chars.length) {
            this.grow(this.off + 1);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeReference(String path) {
        this.lastReference = path;
        int off = this.off;
        char[] chars = this.chars;
        if (off + 9 > chars.length) {
            chars = this.grow(off + 9);
        }
        long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET + ((long)off << 1);
        JDKUtils.UNSAFE.putLong(chars, address, REF_0);
        JDKUtils.UNSAFE.putLong(chars, address + 8L, REF_1);
        this.off = off + 8;
        this.writeString(path);
        off = this.off;
        chars = this.chars;
        if (off == chars.length) {
            chars = this.grow(off + 1);
        }
        chars[off] = 125;
        this.off = off + 1;
    }

    @Override
    public final void writeBase64(byte[] bytes) {
        int i;
        if (bytes == null) {
            this.writeArrayNull();
            return;
        }
        int charsLen = (bytes.length - 1) / 3 + 1 << 2;
        int off = this.off;
        this.ensureCapacityInternal(off + charsLen + 2);
        char[] chars = this.chars;
        chars[off++] = this.quote;
        int eLen = bytes.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            chars[off] = JSONFactory.CA[i >>> 18 & 0x3F];
            chars[off + 1] = JSONFactory.CA[i >>> 12 & 0x3F];
            chars[off + 2] = JSONFactory.CA[i >>> 6 & 0x3F];
            chars[off + 3] = JSONFactory.CA[i & 0x3F];
            off += 4;
        }
        int left = bytes.length - eLen;
        if (left > 0) {
            i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytes.length - 1] & 0xFF) << 2 : 0);
            chars[off] = JSONFactory.CA[i >> 12];
            chars[off + 1] = JSONFactory.CA[i >>> 6 & 0x3F];
            chars[off + 2] = left == 2 ? JSONFactory.CA[i & 0x3F] : 61;
            chars[off + 3] = 61;
            off += 4;
        }
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeHex(byte[] bytes) {
        if (bytes == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int charsLen = bytes.length * 2 + 3;
        int minCapacity = off + charsLen + 2;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = 120;
        chars[off + 1] = 39;
        off += 2;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int a = b & 0xFF;
            int b0 = a >> 4;
            int b1 = a & 0xF;
            chars[off] = (char)(b0 + (b0 < 10 ? 48 : 55));
            chars[off + 1] = (char)(b1 + (b1 < 10 ? 48 : 55));
            off += 2;
        }
        chars[off] = 39;
        this.off = off + 1;
    }

    @Override
    public final void writeBigInt(BigInteger value, long features) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (TypeUtils.isInt64(value) && features == 0L) {
            this.writeInt64(value.longValue());
            return;
        }
        String str = value.toString(10);
        boolean writeAsString = JSONWriterUTF16.isWriteAsString(value, this.context.features | features);
        int off = this.off;
        int strlen = str.length();
        int minCapacity = off + strlen + (writeAsString ? 2 : 0);
        char[] chars = this.chars;
        if (minCapacity > this.chars.length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString) {
            chars[off++] = 34;
        }
        str.getChars(0, strlen, chars, off);
        off += strlen;
        if (writeAsString) {
            chars[off++] = 34;
        }
        this.off = off;
    }

    @Override
    public final void writeDecimal(BigDecimal value, long features, DecimalFormat format) {
        long unscaleValue;
        int scale;
        boolean asPlain;
        char[] chars;
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (format != null) {
            String str = format.format(value);
            this.writeRaw(str);
            return;
        }
        int precision = value.precision();
        boolean writeAsString = JSONWriterUTF16.isWriteAsString(value, features |= this.context.features);
        int off = this.off;
        int minCapacity = off + precision + value.scale() + 7;
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString) {
            chars[off++] = 34;
        }
        boolean bl = asPlain = (features & JSONWriter.Feature.WriteBigDecimalAsPlain.mask) != 0L;
        if (precision < 19 && (scale = value.scale()) >= 0 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L && (unscaleValue = JDKUtils.UNSAFE.getLong(value, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET)) != Long.MIN_VALUE && !asPlain) {
            off = IOUtils.writeDecimal(chars, off, unscaleValue, scale);
        } else {
            String str = asPlain ? value.toPlainString() : value.toString();
            str.getChars(0, str.length(), chars, off);
            off += str.length();
        }
        if (writeAsString) {
            chars[off++] = 34;
        }
        this.off = off;
    }

    static void putLong(char[] buf, int off, int b0, int b1) {
        long v = (long)HEX256[b0 & 0xFF] | (long)HEX256[b1 & 0xFF] << 32;
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1), JDKUtils.BIG_ENDIAN ? Long.reverseBytes(v << 8) : v);
    }

    @Override
    public final void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        int minCapacity = this.off + 38;
        char[] buf = this.chars;
        if (minCapacity > this.chars.length) {
            buf = this.grow(minCapacity);
        }
        int off = this.off;
        buf[off] = 34;
        JSONWriterUTF16.putLong(buf, off + 1, (int)(msb >> 56), (int)(msb >> 48));
        JSONWriterUTF16.putLong(buf, off + 5, (int)(msb >> 40), (int)(msb >> 32));
        buf[off + 9] = 45;
        JSONWriterUTF16.putLong(buf, off + 10, (int)msb >> 24, (int)msb >> 16);
        buf[off + 14] = 45;
        JSONWriterUTF16.putLong(buf, off + 15, (int)msb >> 8, (int)msb);
        buf[off + 19] = 45;
        JSONWriterUTF16.putLong(buf, off + 20, (int)(lsb >> 56), (int)(lsb >> 48));
        buf[off + 24] = 45;
        JSONWriterUTF16.putLong(buf, off + 25, (int)(lsb >> 40), (int)(lsb >> 32));
        JSONWriterUTF16.putLong(buf, off + 29, (int)lsb >> 24, (int)lsb >> 16);
        JSONWriterUTF16.putLong(buf, off + 33, (int)lsb >> 8, (int)lsb);
        buf[off + 37] = 34;
        this.off += 38;
    }

    @Override
    public final void writeRaw(String str) {
        char[] chars;
        int off = this.off;
        int strlen = str.length();
        if (off + strlen > (chars = this.chars).length) {
            chars = this.grow(off + strlen);
        }
        str.getChars(0, strlen, chars, off);
        this.off = off + strlen;
    }

    @Override
    public final void writeRaw(char[] str, int coff, int strlen) {
        int off = this.off;
        char[] chars = this.chars;
        if (off + strlen > chars.length) {
            chars = this.grow(off + strlen);
        }
        System.arraycopy(str, coff, chars, off, strlen);
        this.off = off + strlen;
    }

    @Override
    public final void writeChar(char ch) {
        int off = this.off;
        char[] chars = this.chars;
        if (off + 8 > chars.length) {
            chars = this.grow(off + 8);
        }
        chars[off++] = this.quote;
        switch (ch) {
            case '\"': 
            case '\'': {
                if (ch == this.quote) {
                    chars[off++] = 92;
                }
                chars[off++] = ch;
                break;
            }
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case '\\': {
                StringUtils.writeEscapedChar(chars, off, (int)ch);
                off += 2;
                break;
            }
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': {
                chars[off] = 92;
                chars[off + 1] = 117;
                chars[off + 2] = 48;
                chars[off + 3] = 48;
                chars[off + 4] = 48;
                chars[off + 5] = (char)(48 + ch);
                off += 6;
                break;
            }
            case '\u000b': 
            case '\u000e': 
            case '\u000f': {
                chars[off] = 92;
                chars[off + 1] = 117;
                chars[off + 2] = 48;
                chars[off + 3] = 48;
                chars[off + 4] = 48;
                chars[off + 5] = (char)(97 + (ch - 10));
                off += 6;
                break;
            }
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': {
                chars[off] = 92;
                chars[off + 1] = 117;
                chars[off + 2] = 48;
                chars[off + 3] = 48;
                chars[off + 4] = 49;
                chars[off + 5] = (char)(48 + (ch - 16));
                off += 6;
                break;
            }
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                chars[off] = 92;
                chars[off + 1] = 117;
                chars[off + 2] = 48;
                chars[off + 3] = 48;
                chars[off + 4] = 49;
                chars[off + 5] = (char)(97 + (ch - 26));
                off += 6;
                break;
            }
            default: {
                chars[off++] = ch;
            }
        }
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeRaw(char ch) {
        if (this.off == this.chars.length) {
            this.grow0(this.off + 1);
        }
        this.chars[this.off++] = ch;
    }

    @Override
    public final void writeRaw(char c0, char c1) {
        int off = this.off;
        char[] chars = this.chars;
        if (off + 2 > chars.length) {
            chars = this.grow(off + 2);
        }
        chars[off] = c0;
        chars[off + 1] = c1;
        this.off = off + 2;
    }

    @Override
    public final void writeNameRaw(char[] name) {
        int off = this.off;
        int minCapacity = off + name.length + 2 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        System.arraycopy(name, 0, chars, off, name.length);
        this.off = off + name.length;
    }

    @Override
    public final void writeName2Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name);
        this.off = off + 5;
    }

    @Override
    public final void writeName3Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name);
        this.off = off + 6;
    }

    @Override
    public final void writeName4Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name);
        this.off = off + 7;
    }

    @Override
    public final void writeName5Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name);
        this.off = off + 8;
    }

    @Override
    public final void writeName6Raw(long name) {
        int off = this.off;
        int minCapacity = off + 11 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name);
        chars[off + 8] = 58;
        this.off = off + 9;
    }

    @Override
    public final void writeName7Raw(long name) {
        int off = this.off;
        int minCapacity = off + 12 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name);
        IOUtils.putIntUnaligned(chars, off + 8, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 10;
    }

    @Override
    public final void writeName8Raw(long name) {
        int off = this.off;
        int minCapacity = off + 13 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        chars[off++] = this.quote;
        JSONWriterUTF16.putLong(chars, off, name);
        IOUtils.putIntUnaligned(chars, off + 8, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 10;
    }

    @Override
    public final void writeName9Raw(long name0, int name1) {
        int off = this.off;
        int minCapacity = off + 14 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        this.off = off + 12;
    }

    @Override
    public final void writeName10Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        this.off = off + 13;
    }

    @Override
    public final void writeName11Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        this.off = off + 14;
    }

    @Override
    public final void writeName12Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        this.off = off + 15;
    }

    @Override
    public final void writeName13Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        this.off = off + 16;
    }

    @Override
    public final void writeName14Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 19 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        chars[off + 16] = 58;
        this.off = off + 17;
    }

    @Override
    public final void writeName15Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 20 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        IOUtils.putIntUnaligned(chars, off + 16, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 18;
    }

    @Override
    public final void writeName16Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 21 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(chars, off);
            }
        }
        chars[off++] = this.quote;
        JSONWriterUTF16.putLong(chars, off, name0, name1);
        IOUtils.putIntUnaligned(chars, off + 16, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 18;
    }

    private static void putLong(char[] chars, int off, long name) {
        long base = JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off << 1);
        JDKUtils.UNSAFE.putLong(chars, base, name & 0xFFL | (name & 0xFF00L) << 8 | (name & 0xFF0000L) << 16 | (name & 0xFF000000L) << 24);
        JDKUtils.UNSAFE.putLong(chars, base + 8L, (name & 0xFF00000000L) >> 32 | (name & 0xFF0000000000L) >> 24 | (name & 0xFF000000000000L) >> 16 | (name & 0xFF00000000000000L) >> 8);
    }

    private static void putLong(char[] chars, int off, long name, int name1) {
        long base = JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off << 1);
        JDKUtils.UNSAFE.putLong(chars, base, name & 0xFFL | (name & 0xFF00L) << 8 | (name & 0xFF0000L) << 16 | (name & 0xFF000000L) << 24);
        JDKUtils.UNSAFE.putLong(chars, base + 8L, (name & 0xFF00000000L) >> 32 | (name & 0xFF0000000000L) >> 24 | (name & 0xFF000000000000L) >> 16 | (name & 0xFF00000000000000L) >> 8);
        JDKUtils.UNSAFE.putLong(chars, base + 16L, (long)name1 & 0xFFL | ((long)name1 & 0xFF00L) << 8 | ((long)name1 & 0xFF0000L) << 16 | ((long)name1 & 0xFF000000L) << 24);
    }

    private static void putLong(char[] chars, int off, long name, long name1) {
        long base = JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off << 1);
        JDKUtils.UNSAFE.putLong(chars, base, name & 0xFFL | (name & 0xFF00L) << 8 | (name & 0xFF0000L) << 16 | (name & 0xFF000000L) << 24);
        JDKUtils.UNSAFE.putLong(chars, base + 8L, (name & 0xFF00000000L) >> 32 | (name & 0xFF0000000000L) >> 24 | (name & 0xFF000000000000L) >> 16 | (name & 0xFF00000000000000L) >> 8);
        JDKUtils.UNSAFE.putLong(chars, base + 16L, name1 & 0xFFL | (name1 & 0xFF00L) << 8 | (name1 & 0xFF0000L) << 16 | (name1 & 0xFF000000L) << 24);
        JDKUtils.UNSAFE.putLong(chars, base + 24L, (name1 & 0xFF00000000L) >> 32 | (name1 & 0xFF0000000000L) >> 24 | (name1 & 0xFF000000000000L) >> 16 | (name1 & 0xFF00000000000000L) >> 8);
    }

    private int indent(char[] chars, int off) {
        chars[off] = 10;
        int toIndex = off + 1 + this.pretty * this.level;
        Arrays.fill(chars, off + 1, toIndex, this.pretty == 1 ? (char)'\t' : ' ');
        return toIndex;
    }

    @Override
    public final void writeNameRaw(char[] name, int coff, int len) {
        int off = this.off;
        int minCapacity = off + len + 2 + this.pretty * this.level;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            chars[off++] = 44;
        }
        System.arraycopy(name, coff, chars, off, len);
        this.off = off + len;
    }

    @Override
    public final Object ensureCapacity(int minCapacity) {
        char[] chars = this.chars;
        if (minCapacity >= chars.length) {
            this.chars = chars = Arrays.copyOf(chars, this.newCapacity(minCapacity, chars.length));
        }
        return chars;
    }

    final void ensureCapacityInternal(int minCapacity) {
        if (minCapacity > this.chars.length) {
            this.grow0(minCapacity);
        }
    }

    private char[] grow(int minCapacity) {
        this.grow0(minCapacity);
        return this.chars;
    }

    protected final void grow0(int minCapacity) {
        this.chars = Arrays.copyOf(this.chars, this.newCapacity(minCapacity, this.chars.length));
    }

    @Override
    public final void writeInt32(int[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + value.length * 13 + 2;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                chars[off++] = 44;
            }
            if (writeAsString) {
                chars[off++] = this.quote;
            }
            off = IOUtils.writeInt32(chars, off, (long)value[i]);
            if (!writeAsString) continue;
            chars[off++] = this.quote;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeInt8(byte i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 7;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString) {
            chars[off++] = this.quote;
        }
        off = IOUtils.writeInt8(chars, off, i);
        if (writeAsString) {
            chars[off++] = this.quote;
        }
        this.off = off;
    }

    @Override
    public final void writeInt8(byte[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + value.length * 5 + 2;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                chars[off++] = 44;
            }
            if (writeAsString) {
                chars[off++] = this.quote;
            }
            off = IOUtils.writeInt8(chars, off, value[i]);
            if (!writeAsString) continue;
            chars[off++] = this.quote;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeInt16(short i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 7;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString) {
            chars[off++] = this.quote;
        }
        off = IOUtils.writeInt16(chars, off, i);
        if (writeAsString) {
            chars[off++] = this.quote;
        }
        this.off = off;
    }

    @Override
    public final void writeInt32(int i) {
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + 13;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString) {
            chars[off++] = this.quote;
        }
        off = IOUtils.writeInt32(chars, off, (long)i);
        if (writeAsString) {
            chars[off++] = this.quote;
        }
        this.off = off;
    }

    @Override
    public final void writeInt32(Integer i) {
        if (i == null) {
            this.writeNumberNull();
        } else {
            this.writeInt32((int)i);
        }
    }

    @Override
    public final void writeInt64(long[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 2 + values.length * 23;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            long v;
            boolean writeAsString;
            if (i != 0) {
                chars[off++] = 44;
            }
            if (writeAsString = JSONWriterUTF16.isWriteAsString(v = values[i], this.context.features)) {
                chars[off++] = this.quote;
            }
            off = IOUtils.writeInt64(chars, off, v);
            if (!writeAsString) continue;
            chars[off++] = this.quote;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeListInt32(List<Integer> values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int size = values.size();
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 2 + size * 23;
        if (minCapacity >= this.chars.length) {
            this.grow0(minCapacity);
        }
        char[] chars = this.chars;
        chars[off++] = 91;
        for (int i = 0; i < size; ++i) {
            Number item;
            if (i != 0) {
                chars[off++] = 44;
            }
            if ((item = (Number)values.get(i)) == null) {
                chars[off] = 110;
                chars[off + 1] = 117;
                chars[off + 2] = 108;
                chars[off + 3] = 108;
                off += 4;
                continue;
            }
            int v = item.intValue();
            if (writeAsString) {
                chars[off++] = this.quote;
            }
            off = IOUtils.writeInt32(chars, off, (long)v);
            if (!writeAsString) continue;
            chars[off++] = this.quote;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeListInt64(List<Long> values) {
        char[] chars;
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int size = values.size();
        int minCapacity = off + 2 + size * 23;
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        for (int i = 0; i < size; ++i) {
            Long item;
            if (i != 0) {
                chars[off++] = 44;
            }
            if ((item = values.get(i)) == null) {
                chars[off] = 110;
                chars[off + 1] = 117;
                chars[off + 2] = 108;
                chars[off + 3] = 108;
                off += 4;
                continue;
            }
            long v = item;
            boolean writeAsString = JSONWriterUTF16.isWriteAsString(v, this.context.features);
            if (writeAsString) {
                chars[off++] = this.quote;
            }
            off = IOUtils.writeInt64(chars, off, v);
            if (!writeAsString) continue;
            chars[off++] = this.quote;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeInt64(long i) {
        boolean writeAsString;
        long features = this.context.features;
        int off = this.off;
        int minCapacity = off + 23;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString = JSONWriterUTF16.isWriteAsString(i, features)) {
            chars[off++] = this.quote;
        }
        off = IOUtils.writeInt64(chars, off, i);
        if (writeAsString) {
            chars[off++] = this.quote;
        } else if ((features & 0x200L) != 0L && (features & 0x10000000000L) == 0L && i >= Integer.MIN_VALUE && i <= Integer.MAX_VALUE) {
            chars[off++] = 76;
        }
        this.off = off;
    }

    @Override
    public final void writeInt64(Long i) {
        if (i == null) {
            this.writeInt64Null();
        } else {
            this.writeInt64((long)i);
        }
    }

    @Override
    public final void writeFloat(float value) {
        char[] chars;
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 15;
        if (writeAsString) {
            minCapacity += 2;
        }
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString) {
            chars[off++] = 34;
        }
        off = NumberUtils.writeFloat(chars, off, value, true);
        if (writeAsString) {
            chars[off++] = 34;
        }
        this.off = off;
    }

    @Override
    public final void writeFloat(float[] values) {
        char[] chars;
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = off + values.length * (writeAsString ? 16 : 18) + 1;
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                chars[off++] = 44;
            }
            if (writeAsString) {
                chars[off++] = 34;
            }
            off = NumberUtils.writeFloat(chars, off, values[i], true);
            if (!writeAsString) continue;
            chars[off++] = 34;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeDouble(double value) {
        char[] chars;
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 24;
        if (writeAsString) {
            minCapacity += 2;
        }
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        if (writeAsString) {
            chars[off++] = 34;
        }
        off = NumberUtils.writeDouble(chars, off, value, true);
        if (writeAsString) {
            chars[off++] = 34;
        }
        this.off = off;
    }

    @Override
    public final void writeDoubleArray(double value0, double value1) {
        char[] chars;
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 48 + 3;
        if (writeAsString) {
            minCapacity += 2;
        }
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        if (writeAsString) {
            chars[off++] = 34;
        }
        off = NumberUtils.writeDouble(chars, off, value0, true);
        if (writeAsString) {
            chars[off++] = 34;
        }
        chars[off++] = 44;
        if (writeAsString) {
            chars[off++] = 34;
        }
        off = NumberUtils.writeDouble(chars, off, value1, true);
        if (writeAsString) {
            chars[off++] = 34;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeDouble(double[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + values.length * 27 + 1;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                chars[off++] = 44;
            }
            if (writeAsString) {
                chars[off++] = 34;
            }
            off = NumberUtils.writeDouble(chars, off, values[i], true);
            if (!writeAsString) continue;
            chars[off++] = 34;
        }
        chars[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 16;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = this.quote;
        if (year < 0 || year > 9999) {
            throw JSONWriterUTF16.illegalYear(year);
        }
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        IOUtils.writeDigitPair(chars, off + 1, y01);
        IOUtils.writeDigitPair(chars, off + 3, y23);
        IOUtils.writeDigitPair(chars, off + 5, month);
        IOUtils.writeDigitPair(chars, off + 7, dayOfMonth);
        IOUtils.writeDigitPair(chars, off + 9, hour);
        IOUtils.writeDigitPair(chars, off + 11, minute);
        IOUtils.writeDigitPair(chars, off + 13, second);
        chars[off + 15] = this.quote;
        this.off = off + 16;
    }

    @Override
    public final void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        char[] chars = this.chars;
        if (this.off + 21 > chars.length) {
            chars = this.grow(this.off + 21);
        }
        int off = this.off;
        chars[off] = this.quote;
        if (year < 0 || year > 9999) {
            throw JSONWriterUTF16.illegalYear(year);
        }
        off = IOUtils.writeLocalDate(chars, off + 1, year, month, dayOfMonth);
        chars[off] = 32;
        IOUtils.writeLocalTime(chars, off + 1, hour, minute, second);
        chars[off + 9] = this.quote;
        this.off = off + 10;
    }

    @Override
    public final void writeLocalDate(LocalDate date) {
        if (date == null) {
            this.writeNull();
            return;
        }
        if (this.context.dateFormat != null && this.writeLocalDateWithFormat(date)) {
            return;
        }
        int off = this.off;
        int minCapacity = off + 18;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = this.quote;
        off = IOUtils.writeLocalDate(chars, off, date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeLocalDateTime(LocalDateTime dateTime) {
        int off = this.off;
        int minCapacity = off + 38;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = this.quote;
        LocalDate localDate = dateTime.toLocalDate();
        off = IOUtils.writeLocalDate(chars, off, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        chars[off++] = 32;
        off = IOUtils.writeLocalTime(chars, off, dateTime.toLocalTime());
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        char[] chars;
        int off = this.off;
        int zonelen = timeZone ? (offsetSeconds == 0 ? 1 : 6) : 0;
        int minCapacity = off + 25 + zonelen;
        if (minCapacity > (chars = this.chars).length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = this.quote;
        off = IOUtils.writeLocalDate(chars, off + 1, year, month, dayOfMonth);
        chars[off] = timeZone ? 84 : 32;
        IOUtils.writeLocalTime(chars, off + 1, hour, minute, second);
        off += 9;
        if (millis > 0) {
            int div = millis / 10;
            int div2 = div / 10;
            int rem1 = millis - div * 10;
            if (rem1 != 0) {
                IOUtils.putLongLE(chars, off, IOUtils.DIGITS_K_64[millis & 0x3FF] & 0xFFFFFFFFFFFF0000L | IOUtils.DOT_X0);
                off += 4;
            } else {
                chars[off++] = 46;
                int rem2 = div - div2 * 10;
                if (rem2 != 0) {
                    IOUtils.writeDigitPair(chars, off, div);
                    off += 2;
                } else {
                    chars[off++] = (char)(div2 + 48);
                }
            }
        }
        if (timeZone) {
            int offset = offsetSeconds / 3600;
            if (offsetSeconds == 0) {
                chars[off++] = 90;
            } else {
                int offsetAbs = Math.abs(offset);
                chars[off] = offset >= 0 ? 43 : 45;
                IOUtils.writeDigitPair(chars, off + 1, offsetAbs);
                chars[off + 3] = 58;
                int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.writeDigitPair(chars, off + 4, offsetMinutes);
                off += 6;
            }
        }
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        int off = this.off;
        int minCapacity = off + 10;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = this.quote;
        if (year < 0 || year > 9999) {
            throw JSONWriterUTF16.illegalYear(year);
        }
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        IOUtils.writeDigitPair(chars, off + 1, y01);
        IOUtils.writeDigitPair(chars, off + 3, y23);
        IOUtils.writeDigitPair(chars, off + 5, month);
        IOUtils.writeDigitPair(chars, off + 7, dayOfMonth);
        chars[off + 9] = this.quote;
        this.off = off + 10;
    }

    @Override
    public final void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        int off = this.off;
        int minCapacity = off + 13;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = this.quote;
        off = IOUtils.writeLocalDate(chars, off, year, month, dayOfMonth);
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeTimeHHMMSS8(int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 10;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = this.quote;
        IOUtils.writeDigitPair(chars, off + 1, hour);
        chars[off + 3] = 58;
        IOUtils.writeDigitPair(chars, off + 4, minute);
        chars[off + 6] = 58;
        IOUtils.writeDigitPair(chars, off + 7, second);
        chars[off + 9] = this.quote;
        this.off = off + 10;
    }

    @Override
    public final void writeLocalTime(LocalTime time) {
        int off = this.off;
        int minCapacity = off + 20;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off++] = this.quote;
        off = IOUtils.writeLocalTime(chars, off, time);
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeZonedDateTime(ZonedDateTime dateTime) {
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        ZoneId zone = dateTime.getZone();
        String zoneId = zone.getId();
        int zoneIdLength = zoneId.length();
        char firstZoneChar = '\u0000';
        if (ZoneOffset.UTC == zone || zoneIdLength <= 3 && ("UTC".equals(zoneId) || "Z".equals(zoneId))) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneIdLength != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneIdLength : 2 + zoneIdLength;
        }
        int off = this.off;
        int minCapacity = off + zoneSize + 38;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = this.quote;
        LocalDate localDate = dateTime.toLocalDate();
        off = IOUtils.writeLocalDate(chars, off + 1, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        chars[off] = 84;
        off = IOUtils.writeLocalTime(chars, off + 1, dateTime.toLocalTime());
        if (zoneSize == 1) {
            chars[off++] = 90;
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getChars(0, zoneIdLength, chars, off);
            off += zoneIdLength;
        } else {
            chars[off++] = 91;
            zoneId.getChars(0, zoneIdLength, chars, off);
            off += zoneIdLength;
            chars[off++] = 93;
        }
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeOffsetDateTime(OffsetDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 45;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = this.quote;
        LocalDateTime ldt = dateTime.toLocalDateTime();
        LocalDate date = ldt.toLocalDate();
        off = IOUtils.writeLocalDate(chars, off + 1, date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        chars[off] = 84;
        off = IOUtils.writeLocalTime(chars, off + 1, ldt.toLocalTime());
        ZoneOffset offset = dateTime.getOffset();
        if (offset.getTotalSeconds() == 0) {
            chars[off++] = 90;
        } else {
            String zoneId = offset.getId();
            zoneId.getChars(0, zoneId.length(), chars, off);
            off += zoneId.length();
        }
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeOffsetTime(OffsetTime time) {
        if (time == null) {
            this.writeNull();
            return;
        }
        ZoneOffset offset = time.getOffset();
        int off = this.off;
        int minCapacity = off + 28;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        chars[off] = this.quote;
        off = IOUtils.writeLocalTime(chars, off + 1, time.toLocalTime());
        if (offset.getTotalSeconds() == 0) {
            chars[off++] = 90;
        } else {
            String zoneId = offset.getId();
            zoneId.getChars(0, zoneId.length(), chars, off);
            off += zoneId.length();
        }
        chars[off] = this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeNameRaw(byte[] bytes) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final int flushTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new JSONException("out is nulll");
        }
        boolean ascii = true;
        for (int i = 0; i < this.off; ++i) {
            if (this.chars[i] < '\u0080') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            byte[] bytes = new byte[this.off];
            for (int i = 0; i < this.off; ++i) {
                bytes[i] = (byte)this.chars[i];
            }
            out.write(bytes);
            this.off = 0;
            return bytes.length;
        }
        byte[] utf8 = new byte[this.off * 3];
        int utf8Length = IOUtils.encodeUTF8(this.chars, 0, this.off, utf8, 0);
        out.write(utf8, 0, utf8Length);
        this.off = 0;
        return utf8Length;
    }

    @Override
    public final int flushTo(OutputStream out, Charset charset) throws IOException {
        if (this.off == 0) {
            return 0;
        }
        if (out == null) {
            throw new JSONException("out is null");
        }
        byte[] bytes = this.getBytes(charset);
        out.write(bytes);
        this.off = 0;
        return bytes.length;
    }

    public final String toString() {
        return new String(this.chars, 0, this.off);
    }

    @Override
    public final byte[] getBytes() {
        boolean ascii = true;
        for (int i = 0; i < this.off; ++i) {
            if (this.chars[i] < '\u0080') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            byte[] bytes = new byte[this.off];
            for (int i = 0; i < this.off; ++i) {
                bytes[i] = (byte)this.chars[i];
            }
            return bytes;
        }
        byte[] utf8 = new byte[this.off * 3];
        int utf8Length = IOUtils.encodeUTF8(this.chars, 0, this.off, utf8, 0);
        return Arrays.copyOf(utf8, utf8Length);
    }

    @Override
    public final int size() {
        return this.off;
    }

    @Override
    public final byte[] getBytes(Charset charset) {
        boolean ascii = true;
        for (int i = 0; i < this.off; ++i) {
            if (this.chars[i] < '\u0080') continue;
            ascii = false;
            break;
        }
        if (ascii && (charset == StandardCharsets.UTF_8 || charset == StandardCharsets.ISO_8859_1 || charset == StandardCharsets.US_ASCII)) {
            byte[] bytes = new byte[this.off];
            for (int i = 0; i < this.off; ++i) {
                bytes[i] = (byte)this.chars[i];
            }
            return bytes;
        }
        return new String(this.chars, 0, this.off).getBytes(charset != null ? charset : StandardCharsets.UTF_8);
    }

    @Override
    public final void writeRaw(byte[] bytes) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void write(Map<?, ?> map) {
        if (this.pretty != 0) {
            super.write(map);
            return;
        }
        if (map == null) {
            this.writeNull();
            return;
        }
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        this.writeRaw('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null && (this.context.features & JSONWriter.Feature.WriteMapNullValue.mask) == 0L) continue;
            if (!first) {
                this.writeRaw(',');
            }
            first = false;
            Object key = entry.getKey();
            if (key instanceof String) {
                this.writeString((String)key);
            } else {
                this.writeAny(key);
            }
            this.writeRaw(':');
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        this.writeRaw('}');
    }

    @Override
    public final void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        if (this.off == this.chars.length) {
            this.grow0(this.off + 1);
        }
        this.chars[this.off++] = 91;
        boolean first = true;
        for (int i = 0; i < array.size(); ++i) {
            Object o = array.get(i);
            if (!first) {
                if (this.off == this.chars.length) {
                    this.grow(this.off + 1);
                }
                this.chars[this.off++] = 44;
            }
            first = false;
            if (o == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = o.getClass();
            if (valueClass == String.class) {
                this.writeString((String)o);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)o);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)o);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)o);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)o, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)o);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)o);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, o, null, null, 0L);
        }
        if (this.off == this.chars.length) {
            this.grow(this.off + 1);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeString(boolean value) {
        this.chars[this.off++] = this.quote;
        this.writeBool(value);
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeString(byte value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt8(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(short value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt16(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(int value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt32(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(long value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt64(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    private void writeQuote() {
        if (this.off == this.chars.length) {
            this.grow(this.off + 1);
        }
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeString(char[] value) {
        if (value == null) {
            this.writeStringNull();
            return;
        }
        if ((this.context.features & (JSONWriter.Feature.BrowserSecure.mask | JSONWriter.Feature.EscapeNoneAscii.mask)) != 0L) {
            this.writeStringBrowserSecure(value);
            return;
        }
        boolean escape = false;
        int off = this.off;
        int minCapacity = off + value.length + 2;
        if (minCapacity >= this.chars.length) {
            this.grow(minCapacity);
        }
        long vecQuote = this.byteVectorQuote;
        char[] chars = this.chars;
        chars[off++] = this.quote;
        int i = 0;
        int char_len = value.length;
        while (i < char_len) {
            char c;
            long v1;
            long v0;
            if (i + 8 < char_len && (((v0 = IOUtils.getLongLE(value, i)) | (v1 = IOUtils.getLongLE(value, i + 4))) & 0xFF00FF00FF00FF00L) == 0L && StringUtils.noneEscaped(v0 << 8 | v1, vecQuote)) {
                IOUtils.putLongLE(chars, off, v0);
                IOUtils.putLongLE(chars, off + 4, v1);
                i += 8;
                off += 8;
                continue;
            }
            if ((c = IOUtils.getChar(value, i++)) == '\\' || c == this.quote || c < ' ') {
                escape = true;
                break;
            }
            chars[off++] = c;
        }
        if (!escape) {
            chars[off] = this.quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscape(value);
    }

    @Override
    public final void writeString(char[] str, int coff, int len) {
        if (str == null) {
            this.writeStringNull();
            return;
        }
        boolean special = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        for (int i = coff; i < len; ++i) {
            char ch = str[i];
            if (ch != '\\' && ch != this.quote && ch >= ' ') continue;
            special = true;
            break;
        }
        if (!special) {
            int off = this.off;
            int minCapacity = off + len + 2;
            char[] chars = this.chars;
            if (minCapacity > chars.length) {
                chars = this.grow(minCapacity);
            }
            chars[off++] = this.quote;
            System.arraycopy(str, coff, chars, off, len);
            chars[off += len] = this.quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscape(new String(str, coff, len));
    }

    @Override
    public void writeBool(boolean value) {
        int minCapacity = this.off + 5;
        char[] chars = this.chars;
        if (minCapacity > chars.length) {
            chars = this.grow(minCapacity);
        }
        int off = this.off;
        if ((this.context.features & JSONWriter.Feature.WriteBooleanAsNumber.mask) != 0L) {
            chars[off++] = value ? 49 : 48;
        } else if (!value) {
            chars[off] = 102;
            chars[off + 1] = 97;
            chars[off + 2] = 108;
            chars[off + 3] = 115;
            chars[off + 4] = 101;
            off += 5;
        } else {
            chars[off] = 116;
            chars[off + 1] = 114;
            chars[off + 2] = 117;
            chars[off + 3] = 101;
            off += 4;
        }
        this.off = off;
    }

    static {
        int i;
        int[] digits = new int[256];
        for (i = 0; i < 16; ++i) {
            short hi = (short)(i < 10 ? i + 48 : i - 10 + 97);
            for (int j = 0; j < 16; ++j) {
                short lo = (short)(j < 10 ? j + 48 : j - 10 + 97);
                digits[(i << 4) + j] = hi | lo << 16;
            }
        }
        if (JDKUtils.BIG_ENDIAN) {
            for (i = 0; i < digits.length; ++i) {
                digits[i] = Integer.reverseBytes(digits[i] << 8);
            }
        }
        HEX256 = digits;
        char[] chars = new char[]{'{', '\"', '$', 'r', 'e', 'f', '\"', ':'};
        REF_0 = JDKUtils.UNSAFE.getLong(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET);
        REF_1 = JDKUtils.UNSAFE.getLong(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + 8L);
        QUOTE2_COLON = JDKUtils.UNSAFE.getInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + 12L);
        chars[6] = 39;
        QUOTE_COLON = JDKUtils.UNSAFE.getInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + 12L);
    }
}

