/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.util.Arrays;

public class MutableBigInteger {
    static final long LONG_MASK = 0xFFFFFFFFL;
    static final int KNUTH_POW2_THRESH_LEN = 6;
    static final int KNUTH_POW2_THRESH_ZEROS = 3;
    int[] value;
    int intLen;
    int offset;

    public MutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    MutableBigInteger(int val) {
        this.init(val);
    }

    private void init(int val) {
        this.value = new int[]{val};
        this.intLen = val != 0 ? 1 : 0;
    }

    public MutableBigInteger(int[] val) {
        this.value = val;
        this.intLen = val.length;
    }

    MutableBigInteger(MutableBigInteger val) {
        this.intLen = val.intLen;
        this.value = Arrays.copyOfRange(val.value, val.offset, val.offset + this.intLen);
    }

    MutableBigInteger divideKnuth(MutableBigInteger b, MutableBigInteger quotient) {
        return this.divideKnuth(b, quotient, true);
    }

    MutableBigInteger divideKnuth(MutableBigInteger b, MutableBigInteger quotient, boolean needRemainder) {
        int trailingZeroBits;
        if (b.intLen == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            quotient.offset = 0;
            quotient.intLen = 0;
            return needRemainder ? new MutableBigInteger() : null;
        }
        int cmp = this.compare(b);
        if (cmp < 0) {
            quotient.offset = 0;
            quotient.intLen = 0;
            return needRemainder ? new MutableBigInteger(this) : null;
        }
        if (cmp == 0) {
            quotient.intLen = 1;
            quotient.value[0] = 1;
            quotient.offset = 0;
            return needRemainder ? new MutableBigInteger() : null;
        }
        quotient.clear();
        if (b.intLen == 1) {
            int r = this.divideOneWord(b.value[b.offset], quotient);
            if (needRemainder) {
                if (r == 0) {
                    return new MutableBigInteger();
                }
                return new MutableBigInteger(r);
            }
            return null;
        }
        if (this.intLen >= 6 && (trailingZeroBits = Math.min(this.getLowestSetBit(), b.getLowestSetBit())) >= 96) {
            MutableBigInteger a = new MutableBigInteger(this);
            b = new MutableBigInteger(b);
            a.rightShift(trailingZeroBits);
            b.rightShift(trailingZeroBits);
            MutableBigInteger r = a.divideKnuth(b, quotient);
            r.leftShift(trailingZeroBits);
            return r;
        }
        return this.divideMagnitude(b, quotient, needRemainder);
    }

    final int compare(MutableBigInteger b) {
        int blen = b.intLen;
        if (this.intLen < blen) {
            return -1;
        }
        if (this.intLen > blen) {
            return 1;
        }
        int[] bval = b.value;
        int i = this.offset;
        int j = b.offset;
        while (i < this.intLen + this.offset) {
            int b1 = this.value[i] + Integer.MIN_VALUE;
            int b2 = bval[j] + Integer.MIN_VALUE;
            if (b1 < b2) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    void clear() {
        this.intLen = 0;
        this.offset = 0;
        int n = this.value.length;
        for (int index = 0; index < n; ++index) {
            this.value[index] = 0;
        }
    }

    int divideOneWord(int divisor, MutableBigInteger quotient) {
        long divisorLong = (long)divisor & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            int dividendValue = this.value[this.offset];
            int q = Integer.divideUnsigned(dividendValue, divisor);
            int r = Integer.remainderUnsigned(dividendValue, divisor);
            quotient.value[0] = q;
            quotient.intLen = q == 0 ? 0 : 1;
            quotient.offset = 0;
            return r;
        }
        if (quotient.value.length < this.intLen) {
            quotient.value = new int[this.intLen];
        }
        quotient.offset = 0;
        quotient.intLen = this.intLen;
        long rem = 0L;
        for (int xlen = this.intLen; xlen > 0; --xlen) {
            long dividendEstimate = rem << 32 | (long)this.value[this.offset + this.intLen - xlen] & 0xFFFFFFFFL;
            int q = (int)Long.divideUnsigned(dividendEstimate, divisorLong);
            rem = Long.remainderUnsigned(dividendEstimate, divisorLong);
            quotient.value[this.intLen - xlen] = q;
        }
        quotient.normalize();
        return (int)rem;
    }

    private final int getLowestSetBit() {
        int j;
        if (this.intLen == 0) {
            return -1;
        }
        for (j = this.intLen - 1; j > 0 && this.value[j + this.offset] == 0; --j) {
        }
        int b = this.value[j + this.offset];
        if (b == 0) {
            return -1;
        }
        return (this.intLen - 1 - j << 5) + Integer.numberOfTrailingZeros(b);
    }

    final void normalize() {
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int index = this.offset;
        if (this.value[index] != 0) {
            return;
        }
        int indexBound = index + this.intLen;
        while (++index < indexBound && this.value[index] == 0) {
        }
        int numZeros = index - this.offset;
        this.intLen -= numZeros;
        this.offset = this.intLen == 0 ? 0 : this.offset + numZeros;
    }

    void rightShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        this.intLen -= nInts;
        if (nBits == 0) {
            return;
        }
        int bitsInHighWord = MutableBigInteger.bitLengthForInt(this.value[this.offset]);
        if (nBits >= bitsInHighWord) {
            this.primitiveLeftShift(32 - nBits);
            --this.intLen;
        } else {
            this.primitiveRightShift(nBits);
        }
    }

    private void primitiveRightShift(int n) {
        this.primitiveRightShift(n, this.value, this.offset);
    }

    private void primitiveRightShift(int n, int[] result, int resFrom) {
        int[] val = this.value;
        int n2 = 32 - n;
        int b = val[this.offset];
        result[resFrom] = b >>> n;
        for (int i = 1; i < this.intLen; ++i) {
            int c = b;
            b = val[this.offset + i];
            result[resFrom + i] = c << n2 | b >>> n;
        }
    }

    static int bitLengthForInt(int n) {
        return 32 - Integer.numberOfLeadingZeros(n);
    }

    private void primitiveLeftShift(int n) {
        this.primitiveLeftShift(n, this.value, this.offset);
    }

    private void primitiveLeftShift(int n, int[] result, int resFrom) {
        int[] val = this.value;
        int n2 = 32 - n;
        int m = this.intLen - 1;
        int b = val[this.offset];
        for (int i = 0; i < m; ++i) {
            int c = val[this.offset + i + 1];
            result[resFrom + i] = b << n | c >>> n2;
            b = c;
        }
        result[resFrom + m] = b << n;
    }

    void leftShift(int n) {
        int newOffset;
        int[] result;
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int leadingZeros = Integer.numberOfLeadingZeros(this.value[this.offset]);
        if (n <= leadingZeros) {
            this.primitiveLeftShift(nBits);
            return;
        }
        int newLen = this.intLen + nInts;
        if (nBits > leadingZeros) {
            ++newLen;
        }
        if (this.value.length < newLen) {
            result = new int[newLen];
            newOffset = 0;
        } else {
            result = this.value;
            newOffset = this.value.length - this.offset >= newLen ? this.offset : 0;
        }
        int trailingZerosPos = newOffset + this.intLen;
        if (nBits != 0) {
            if (nBits <= leadingZeros) {
                this.primitiveLeftShift(nBits, result, newOffset);
            } else {
                int lastInt = this.value[this.offset + this.intLen - 1];
                this.primitiveRightShift(32 - nBits, result, newOffset);
                result[trailingZerosPos++] = lastInt << nBits;
            }
        } else if (result != this.value || newOffset != this.offset) {
            System.arraycopy(this.value, this.offset, result, newOffset, this.intLen);
        }
        if (result == this.value) {
            Arrays.fill(result, trailingZerosPos, newOffset + newLen, 0);
        }
        this.value = result;
        this.intLen = newLen;
        this.offset = newOffset;
    }

    private MutableBigInteger divideMagnitude(MutableBigInteger div, MutableBigInteger quotient, boolean needRemainder) {
        MutableBigInteger rem;
        int[] divisor;
        int shift = Integer.numberOfLeadingZeros(div.value[div.offset]);
        int dlen = div.intLen;
        if (shift > 0) {
            int[] remarr;
            divisor = new int[dlen];
            div.primitiveLeftShift(shift, divisor, 0);
            if (Integer.numberOfLeadingZeros(this.value[this.offset]) >= shift) {
                remarr = new int[this.intLen + 1];
                rem = new MutableBigInteger(remarr);
                rem.intLen = this.intLen;
                rem.offset = 1;
                this.primitiveLeftShift(shift, remarr, 1);
            } else {
                remarr = new int[this.intLen + 2];
                rem = new MutableBigInteger(remarr);
                rem.intLen = this.intLen + 1;
                rem.offset = 1;
                int rFrom = this.offset;
                int c = 0;
                int n2 = 32 - shift;
                int i = 1;
                while (i < this.intLen + 1) {
                    int b = c;
                    c = this.value[rFrom];
                    remarr[i] = b << shift | c >>> n2;
                    ++i;
                    ++rFrom;
                }
                remarr[this.intLen + 1] = c << shift;
            }
        } else {
            divisor = Arrays.copyOfRange(div.value, div.offset, div.offset + div.intLen);
            rem = new MutableBigInteger(new int[this.intLen + 1]);
            System.arraycopy(this.value, this.offset, rem.value, 1, this.intLen);
            rem.intLen = this.intLen;
            rem.offset = 1;
        }
        int nlen = rem.intLen;
        int limit = nlen - dlen + 1;
        if (quotient.value.length < limit) {
            quotient.value = new int[limit];
            quotient.offset = 0;
        }
        quotient.intLen = limit;
        int[] q = quotient.value;
        rem.offset = 0;
        rem.value[0] = 0;
        ++rem.intLen;
        int dh = divisor[0];
        long dhLong = (long)dh & 0xFFFFFFFFL;
        int dl = divisor[1];
        for (int j = 0; j < limit - 1; ++j) {
            long nl;
            long rs;
            long estProduct;
            int qhat = 0;
            int qrem = 0;
            boolean skipCorrection = false;
            int nh = rem.value[j + rem.offset];
            int nh2 = nh + Integer.MIN_VALUE;
            int nm = rem.value[j + 1 + rem.offset];
            if (nh == dh) {
                qhat = -1;
                qrem = nh + nm;
                skipCorrection = qrem + Integer.MIN_VALUE < nh2;
            } else {
                long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
                qhat = (int)Long.divideUnsigned(nChunk, dhLong);
                qrem = (int)Long.remainderUnsigned(nChunk, dhLong);
            }
            if (qhat == 0) continue;
            if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[j + 2 + rem.offset] & 0xFFFFFFFFL))) {
                --qhat;
                if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                    --qhat;
                }
            }
            rem.value[j + rem.offset] = 0;
            int borrow = this.mulsub(rem.value, divisor, qhat, dlen, j + rem.offset);
            if (borrow + Integer.MIN_VALUE > nh2) {
                this.divadd(divisor, rem.value, j + 1 + rem.offset);
            }
            q[j] = --qhat;
        }
        int qhat = 0;
        int qrem = 0;
        boolean skipCorrection = false;
        int nh = rem.value[limit - 1 + rem.offset];
        int nh2 = nh + Integer.MIN_VALUE;
        int nm = rem.value[limit + rem.offset];
        if (nh == dh) {
            qhat = -1;
            qrem = nh + nm;
            skipCorrection = qrem + Integer.MIN_VALUE < nh2;
        } else {
            long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
            qhat = (int)Long.divideUnsigned(nChunk, dhLong);
            qrem = (int)Long.remainderUnsigned(nChunk, dhLong);
        }
        if (qhat != 0) {
            long nl;
            long rs;
            long estProduct;
            if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[limit + 1 + rem.offset] & 0xFFFFFFFFL))) {
                --qhat;
                if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                    --qhat;
                }
            }
            rem.value[limit - 1 + rem.offset] = 0;
            int borrow = needRemainder ? this.mulsub(rem.value, divisor, qhat, dlen, limit - 1 + rem.offset) : this.mulsubBorrow(rem.value, divisor, qhat, dlen, limit - 1 + rem.offset);
            if (borrow + Integer.MIN_VALUE > nh2 && needRemainder) {
                this.divadd(divisor, rem.value, limit - 1 + 1 + rem.offset);
            }
            q[limit - 1] = --qhat;
        }
        if (needRemainder) {
            if (shift > 0) {
                rem.rightShift(shift);
            }
            rem.normalize();
        }
        quotient.normalize();
        return needRemainder ? rem : null;
    }

    private boolean unsignedLongCompare(long one, long two) {
        return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
    }

    private int mulsub(int[] q, int[] a, int x, int len, int offset) {
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        for (int j = len - 1; j >= 0; --j) {
            long product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
            long difference = (long)q[offset] - product;
            q[offset--] = (int)difference;
            carry = (product >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)carry;
    }

    private int mulsubBorrow(int[] q, int[] a, int x, int len, int offset) {
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        for (int j = len - 1; j >= 0; --j) {
            long difference;
            long product;
            carry = (product >>> 32) + (long)(((difference = (long)q[offset--] - (product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry)) & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)carry;
    }

    private int divadd(int[] a, int[] result, int offset) {
        long carry = 0L;
        for (int j = a.length - 1; j >= 0; --j) {
            long sum = ((long)a[j] & 0xFFFFFFFFL) + ((long)result[j + offset] & 0xFFFFFFFFL) + carry;
            result[j + offset] = (int)sum;
            carry = sum >>> 32;
        }
        return (int)carry;
    }

    private long toLong() {
        assert (this.intLen <= 2) : "this MutableBigInteger exceeds the range of long";
        if (this.intLen == 0) {
            return 0L;
        }
        long d = (long)this.value[this.offset] & 0xFFFFFFFFL;
        return this.intLen == 2 ? d << 32 | (long)this.value[this.offset + 1] & 0xFFFFFFFFL : d;
    }

    public long longValue(int sign) {
        if (this.intLen == 0 || sign == 0) {
            return 0L;
        }
        int[] mag = this.getMagnitudeArray();
        long result = 0L;
        for (int i = 1; i >= 0; --i) {
            result = (result << 32) + ((long)MutableBigInteger.getInt(mag, sign, i) & 0xFFFFFFFFL);
        }
        return result;
    }

    private int[] getMagnitudeArray() {
        if (this.offset > 0 || this.value.length != this.intLen) {
            int[] tmp = Arrays.copyOfRange(this.value, this.offset, this.offset + this.intLen);
            Arrays.fill(this.value, 0);
            this.offset = 0;
            this.intLen = tmp.length;
            this.value = tmp;
        }
        return this.value;
    }

    private static int getInt(int[] mag, int signum, int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= mag.length) {
            return signum < 0 ? -1 : 0;
        }
        int magInt = mag[mag.length - n - 1];
        return signum >= 0 ? magInt : (n <= MutableBigInteger.firstNonzeroIntNum(mag) ? -magInt : ~magInt);
    }

    private static int firstNonzeroIntNum(int[] mag) {
        int i;
        int mlen = mag.length;
        for (i = mag.length - 1; i >= 0 && mag[i] == 0; --i) {
        }
        return mlen - i + 1;
    }
}

