/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.model.SSEKeyType;

public class SSESpecification
implements Jsonizable {
    private boolean enable = false;
    private OptionalValue<SSEKeyType> keyType = new OptionalValue("KeyType");
    private OptionalValue<String> keyId = new OptionalValue("KeyId");
    private OptionalValue<String> roleArn = new OptionalValue("RoleArn");

    public SSESpecification(boolean enable) {
        if (enable) {
            throw new ClientException("Key type is required when enable is true.");
        }
        this.setEnable(enable);
    }

    public SSESpecification(boolean enable, SSEKeyType keyType) {
        if (!enable) {
            throw new ClientException("Key type cannot be set when enable is false.");
        }
        if (keyType != SSEKeyType.SSE_KMS_SERVICE) {
            throw new ClientException("Key id and role arn are required when key type is not SSE_KMS_SERVICE.");
        }
        this.setEnable(enable);
        this.setKeyType(keyType);
    }

    public SSESpecification(boolean enable, SSEKeyType keyType, String keyId, String roleArn) {
        if (!enable) {
            throw new ClientException("Key type cannot be set when enable is false.");
        }
        if (keyType != SSEKeyType.SSE_BYOK) {
            throw new ClientException("Key id and role arn cannot be set when key type is not SSE_BYOK.");
        }
        this.setEnable(enable);
        this.setKeyType(keyType);
        this.setKeyId(keyId);
        this.setRoleArn(roleArn);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public SSEKeyType getKeyType() {
        return this.keyType.getValue();
    }

    public void setKeyType(SSEKeyType keyType) {
        this.keyType.setValue(keyType);
    }

    public String getKeyId() {
        return this.keyId.getValue();
    }

    public void setKeyId(String keyId) {
        this.keyId.setValue(keyId);
    }

    public String getRoleArn() {
        return this.roleArn.getValue();
    }

    public void setRoleArn(String roleArn) {
        this.roleArn.setValue(roleArn);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append('{');
        sb.append(newline);
        sb.append("\"Enable\": ");
        sb.append(this.enable);
        if (this.keyType.isValueSet()) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"KeyType\": ");
            sb.append(this.keyType.getValue().toString());
            sb.append(newline);
        }
        if (this.keyId.isValueSet()) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"KeyId\": ");
            sb.append(this.keyId.getValue());
            sb.append(newline);
        }
        if (this.roleArn.isValueSet()) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"RoleArn\": ");
            sb.append(this.roleArn.getValue());
            sb.append(newline);
        }
        sb.append("}");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Enable: ");
        sb.append(this.enable);
        if (this.keyType.isValueSet()) {
            sb.append(", KeyType: ");
            sb.append(this.keyType.getValue().toString());
        }
        if (this.keyId.isValueSet()) {
            sb.append(", KeyId: ");
            sb.append(this.keyId.getValue());
        }
        if (this.roleArn.isValueSet()) {
            sb.append(", RoleArn: ");
            sb.append(this.roleArn.getValue());
        }
        return sb.toString();
    }
}

