/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.query;

import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.timeline.utils.Preconditions;

public class ScanParameter {
    private long from = 0L;
    private long to = Long.MAX_VALUE;
    private boolean isForward = true;
    private int maxCount = 100;
    private Filter filter;

    public ScanParameter scanForward(long from, long to) {
        this.from = from;
        this.to = to;
        this.isForward = true;
        this.checkCondition();
        return this;
    }

    public ScanParameter scanForward(long from) {
        return this.scanForward(from, Long.MAX_VALUE);
    }

    public ScanParameter scanForwardTo(long to) {
        return this.scanForward(0L, to);
    }

    public ScanParameter scanBackward(long from, long to) {
        this.from = from;
        this.to = to;
        this.isForward = false;
        this.checkCondition();
        return this;
    }

    public ScanParameter scanBackward(long from) {
        return this.scanBackward(from, 0L);
    }

    public ScanParameter scanBackwardTo(long to) {
        return this.scanBackward(Long.MAX_VALUE, to);
    }

    private void checkCondition() {
        boolean isValid = true;
        if (this.isForward) {
            isValid = this.from >= 0L && this.from < this.to;
        } else {
            boolean bl = isValid = this.to >= 0L && this.to < this.from;
        }
        if (!isValid) {
            Preconditions.checkArgument(isValid, "Invalid scan parameter with forward set to '" + this.isForward + "' from " + this.from + " to " + this.to + ".");
        }
    }

    public ScanParameter maxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public ScanParameter withFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public Filter getFilter() {
        return this.filter;
    }
}

