/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.callback;

import com.alicloud.openservices.tablestore.AsyncTimeseriesClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesRow;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesWriterException;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesRowResult;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesBucketConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.enums.TSWriteMode;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesGroup;
import com.alicloud.openservices.tablestore.timeserieswriter.handle.TimeseriesWriterHandleStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesFlushCallback<Req, Res>
implements TableStoreCallback<Req, Res> {
    private Logger logger = LoggerFactory.getLogger(TimeseriesFlushCallback.class);
    private final AsyncTimeseriesClientInterface ots;
    private final AtomicInteger count;
    private final Semaphore semaphore;
    private final TimeseriesBucketConfig timeseriesBucketConfig;
    private final TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback;
    private final Executor executor;
    private final TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics;
    private final Semaphore bucketSemaphore;
    private final List<TimeseriesGroup> groupList;
    public static AtomicLong counter = new AtomicLong(0L);

    public TimeseriesFlushCallback(AsyncTimeseriesClientInterface ots, AtomicInteger count, Semaphore semaphore, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback, Executor executor, TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics, TimeseriesBucketConfig timeseriesBucketConfig, Semaphore bucketSemaphore, List<TimeseriesGroup> groupList) {
        this.ots = ots;
        this.count = count;
        this.semaphore = semaphore;
        this.timeseriesBucketConfig = timeseriesBucketConfig;
        this.executor = executor;
        this.callback = callback;
        this.timeseriesWriterHandleStatistics = timeseriesWriterHandleStatistics;
        this.bucketSemaphore = bucketSemaphore;
        this.groupList = groupList;
    }

    private void triggerSucceedCallback(final TimeseriesTableRow timeseriesTableRow, TimeseriesGroup timeseriesGroup) {
        this.timeseriesWriterHandleStatistics.incrementAndGetTotalSucceedRowsCount();
        timeseriesGroup.succeedOneRow(timeseriesTableRow);
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TimeseriesFlushCallback.this.callback.onCompleted(timeseriesTableRow, new TimeseriesRowResult(true, null));
            }
        });
    }

    private void triggerFailedCallback(final TimeseriesTableRow timeseriesTableRow, final Exception exp, TimeseriesGroup group) {
        this.timeseriesWriterHandleStatistics.incrementAndGetTotalFailedRowsCount();
        group.failedOneRow(timeseriesTableRow, exp);
        this.logger.error("timeseriesRow Failed: ", (Throwable)exp);
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TimeseriesFlushCallback.this.callback.onFailed(timeseriesTableRow, exp);
            }
        });
    }

    private void triggerFailedCallback(final List<TimeseriesTableRow> timeseriesTableRows, final Exception exp, List<TimeseriesGroup> timeseriesGroupList) {
        this.timeseriesWriterHandleStatistics.addAndGetTotalFailedRowsCount(timeseriesTableRows.size());
        for (int i = 0; i < timeseriesTableRows.size(); ++i) {
            TimeseriesTableRow timeseriesTableRow = timeseriesTableRows.get(i);
            TimeseriesGroup group = timeseriesGroupList.get(i);
            group.failedOneRow(timeseriesTableRow, exp);
            this.logger.error("timeseriesRow Failed: ", (Throwable)exp);
        }
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (TimeseriesTableRow timeseriesTableRow : timeseriesTableRows) {
                    TimeseriesFlushCallback.this.callback.onFailed(timeseriesTableRow, exp);
                }
            }
        });
    }

    private void requestComplete() {
        int remain = this.count.decrementAndGet();
        if (remain == 0) {
            this.logger.debug("BucketSemaphore Release: " + counter.incrementAndGet());
            this.semaphore.release();
            this.bucketSemaphore.release();
            this.logger.debug("Release semaphore.");
        }
    }

    @Override
    public void onCompleted(PutTimeseriesDataRequest originRequest, PutTimeseriesDataResponse result) {
        List<PutTimeseriesDataResponse.FailedRowResult> failed = result.getFailedRows();
        ArrayList<Integer> failed_index = new ArrayList<Integer>();
        String requestTableName = originRequest.getTimeseriesTableName();
        for (PutTimeseriesDataResponse.FailedRowResult status : failed) {
            failed_index.add(status.getIndex());
            Error error = status.getError();
            TimeseriesGroup group = this.groupList.get(status.getIndex());
            this.triggerFailedCallback(new TimeseriesTableRow(originRequest.getRows().get(status.getIndex()), requestTableName), (Exception)new TableStoreException(error.getMessage(), null, error.getCode(), result.getRequestId(), 0), group);
        }
        List<TimeseriesRow> allRows = originRequest.getRows();
        for (int i = 0; i < allRows.size(); ++i) {
            if (failed_index.contains(i)) continue;
            this.triggerSucceedCallback(new TimeseriesTableRow(allRows.get(i), requestTableName), this.groupList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted(Req request, Res response) {
        try {
            if (request instanceof PutTimeseriesDataRequest) {
                this.onCompleted((PutTimeseriesDataRequest)request, (PutTimeseriesDataResponse)response);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed while handling onCompleted function: {}", (Object)e.getMessage());
        }
        finally {
            this.requestComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Req request, Exception ex) {
        try {
            if (ex instanceof TableStoreException && ((TableStoreException)ex).getErrorCode().equals("OTSParameterInvalid") && ((PutTimeseriesDataRequest)request).getRows().size() > 1) {
                this.retryTimeseriesRow((PutTimeseriesDataRequest)request);
            } else if (ex instanceof TimeseriesWriterException && ((PutTimeseriesDataRequest)request).getRows().size() > 1) {
                this.retryTimeseriesRow((PutTimeseriesDataRequest)request);
            } else {
                this.failedOnException(request, ex);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed while handling onFailed function: {}", (Object)e.getMessage());
        }
        finally {
            this.requestComplete();
        }
    }

    public void failedOnException(Req request, Exception ex) {
        ArrayList<TimeseriesTableRow> failedRows = new ArrayList<TimeseriesTableRow>();
        if (request instanceof PutTimeseriesDataRequest) {
            PutTimeseriesDataRequest bwr = (PutTimeseriesDataRequest)request;
            String tableName = bwr.getTimeseriesTableName();
            for (TimeseriesRow timeseriesRow : bwr.getRows()) {
                failedRows.add(new TimeseriesTableRow(timeseriesRow, tableName));
            }
        }
        this.triggerFailedCallback(failedRows, ex, this.groupList);
    }

    private void retryTimeseriesRow(PutTimeseriesDataRequest request) {
        if (TSWriteMode.SEQUENTIAL.equals((Object)this.timeseriesBucketConfig.getWriteMode())) {
            this.retrySequentialWriteSingleTimeseries(request.getRows(), this.groupList, request.getTimeseriesTableName(), 0);
        } else {
            for (int i = 0; i < request.getRows().size(); ++i) {
                TimeseriesGroup timeseriesGroup = this.groupList.get(i);
                this.timeseriesWriterHandleStatistics.incrementAndGetTotalSingleRowRequestCount();
                this.timeseriesWriterHandleStatistics.incrementAndGetTotalRequestCount();
                this.retryParallelWriteSingleTimeseries(request.getRows().get(i), timeseriesGroup, request.getTimeseriesTableName());
            }
        }
    }

    private void retryParallelWriteSingleTimeseries(TimeseriesRow timeseriesRow, TimeseriesGroup timeseriesGroup, String tableName) {
        ArrayList<TimeseriesGroup> subGroupList = new ArrayList<TimeseriesGroup>(1);
        subGroupList.add(timeseriesGroup);
        this.count.incrementAndGet();
        PutTimeseriesDataRequest request = new PutTimeseriesDataRequest(tableName);
        ArrayList<TimeseriesRow> list = new ArrayList<TimeseriesRow>();
        list.add(timeseriesRow);
        request.addRows(list);
        TimeseriesFlushCallback<PutTimeseriesDataRequest, PutTimeseriesDataResponse> tableStoreCallback = new TimeseriesFlushCallback<PutTimeseriesDataRequest, PutTimeseriesDataResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.timeseriesWriterHandleStatistics, this.timeseriesBucketConfig, this.bucketSemaphore, subGroupList);
        this.tryPutTimeseriesData(request, tableStoreCallback);
    }

    private void retrySequentialWriteSingleTimeseries(final List<TimeseriesRow> timeseriesRows, final List<TimeseriesGroup> timeseriesGroups, final String tableName, final int index) {
        if (index >= timeseriesRows.size()) {
            return;
        }
        ArrayList<TimeseriesGroup> subGroupList = new ArrayList<TimeseriesGroup>(1);
        subGroupList.add(timeseriesGroups.get(index));
        this.count.incrementAndGet();
        this.timeseriesWriterHandleStatistics.incrementAndGetTotalSingleRowRequestCount();
        this.timeseriesWriterHandleStatistics.incrementAndGetTotalRequestCount();
        PutTimeseriesDataRequest request = new PutTimeseriesDataRequest(tableName);
        ArrayList<TimeseriesRow> list = new ArrayList<TimeseriesRow>();
        list.add(timeseriesRows.get(index));
        request.addRows(list);
        final TimeseriesFlushCallback<Req, Res> timeseriesFlushCallback = new TimeseriesFlushCallback<Req, Res>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.timeseriesWriterHandleStatistics, this.timeseriesBucketConfig, this.bucketSemaphore, subGroupList);
        TableStoreCallback<PutTimeseriesDataRequest, PutTimeseriesDataResponse> tableStoreCallback = new TableStoreCallback<PutTimeseriesDataRequest, PutTimeseriesDataResponse>(){

            @Override
            public void onCompleted(PutTimeseriesDataRequest req, PutTimeseriesDataResponse res) {
                TimeseriesFlushCallback.this.retrySequentialWriteSingleTimeseries(timeseriesRows, timeseriesGroups, tableName, index + 1);
                timeseriesFlushCallback.onCompleted(req, res);
            }

            @Override
            public void onFailed(PutTimeseriesDataRequest req, Exception ex) {
                TimeseriesFlushCallback.this.retrySequentialWriteSingleTimeseries(timeseriesRows, timeseriesGroups, tableName, index + 1);
                timeseriesFlushCallback.onFailed(req, ex);
            }
        };
        this.tryPutTimeseriesData(request, tableStoreCallback);
    }

    private void tryPutTimeseriesData(PutTimeseriesDataRequest request, TableStoreCallback<PutTimeseriesDataRequest, PutTimeseriesDataResponse> callback) {
        try {
            this.ots.putTimeseriesData(request, callback);
        }
        catch (Exception e) {
            this.logger.error("Failed while send request:", (Throwable)e);
            callback.onFailed(request, new TimeseriesWriterException(e.getMessage(), e, "SendRequestError"));
        }
    }
}

