/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.timestream.internal.MetaCacheManager;
import com.alicloud.openservices.tablestore.timestream.internal.Utils;
import com.alicloud.openservices.tablestore.timestream.model.Point;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import com.alicloud.openservices.tablestore.timestream.model.query.DataGetter;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class TimestreamDataTable {
    private AsyncClient asyncClient;
    private String dataTableName;
    private String metaTable;
    private String index;
    private TableStoreWriter dataWriter;
    private MetaCacheManager metaCacheManager;

    protected TimestreamDataTable(AsyncClient asyncClient, String dataTableName, String metaTable, String index, TableStoreWriter dataWriter, MetaCacheManager metaCacheManager) {
        this.asyncClient = asyncClient;
        this.dataTableName = dataTableName;
        this.metaTable = metaTable;
        this.index = index;
        this.dataWriter = dataWriter;
        this.metaCacheManager = metaCacheManager;
    }

    protected void close() {
        this.dataWriter.close();
    }

    private void writeIdentifier(TimestreamIdentifier identifier) {
        if (this.metaCacheManager != null) {
            this.metaCacheManager.addTimestreamMeta(identifier, TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()));
        }
    }

    public void write(TimestreamIdentifier identifier, Point point) {
        RowPutChange rowChange = Utils.serializeTimestream(this.dataTableName, identifier, point);
        PutRowRequest request = new PutRowRequest();
        request.setRowChange(rowChange);
        Future<PutRowResponse> future = this.asyncClient.putRow(request, null);
        Utils.waitForFuture(future);
        this.writeIdentifier(identifier);
    }

    public void asyncWrite(TimestreamIdentifier identifier, Point point) {
        this.dataWriter.addRowChange(Utils.serializeTimestream(this.dataTableName, identifier, point));
        this.writeIdentifier(identifier);
    }

    public DataGetter get(TimestreamIdentifier identifier) {
        return new DataGetter(this.asyncClient, this.dataTableName, identifier);
    }

    public void flush() {
        this.dataWriter.flush();
    }
}

