/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.pom;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.pom.SortPomCfg;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class SortPomStep {
    public static final String NAME = "sortPom";
    static final String PACKAGE = "com.github.ekryd.sortpom";
    static final String MAVEN_COORDINATE = "com.github.ekryd.sortpom:sortpom-sorter:";

    private SortPomStep() {
    }

    public static FormatterStep create(SortPomCfg cfg, Provisioner provisioner) {
        return FormatterStep.createLazy(NAME, () -> new State(cfg, provisioner), State::createFormat);
    }

    static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        SortPomCfg cfg;
        JarState jarState;

        public State(SortPomCfg cfg, Provisioner provisioner) throws IOException {
            this.cfg = cfg;
            this.jarState = JarState.from(SortPomStep.MAVEN_COORDINATE + cfg.version, provisioner);
        }

        FormatterFunc createFormat() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.pom.SortPomFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(SortPomCfg.class);
            return (FormatterFunc)constructor.newInstance(this.cfg);
        }
    }
}

