/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.shell;

import com.diffplug.spotless.ForeignExe;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ShfmtStep {
    private final String version;
    @Nullable
    private final String pathToExe;

    public static String name() {
        return "shfmt";
    }

    public static String defaultVersion() {
        return "3.7.0";
    }

    private ShfmtStep(String version, @Nullable String pathToExe) {
        this.version = version;
        this.pathToExe = pathToExe;
    }

    public static ShfmtStep withVersion(String version) {
        return new ShfmtStep(version, null);
    }

    public ShfmtStep withPathToExe(String pathToExe) {
        return new ShfmtStep(this.version, pathToExe);
    }

    public FormatterStep create() {
        return FormatterStep.createLazy(ShfmtStep.name(), this::createState, State::toFunc);
    }

    private State createState() throws IOException, InterruptedException {
        String howToInstall = "You can download shfmt from https://github.com/mvdan/sh and then point Spotless to it with {@code pathToExe('/path/to/shfmt')} or you can use your platform's package manager:\n  win:   choco install shfmt\n  mac:   brew install shfmt\n  linux: apt install shfmt\n    github issue to handle this better: https://github.com/diffplug/spotless/issues/673";
        ForeignExe exe = ForeignExe.nameAndVersion("shfmt", this.version).pathToExe(this.pathToExe).versionRegex(Pattern.compile("(\\S*)")).fixCantFind(howToInstall).fixWrongVersion("You can tell Spotless to use the version you already have with {@code shfmt('{versionFound}')}or you can download the currently specified version, {version}.\n" + howToInstall);
        return new State(this, exe);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class State
    implements Serializable {
        private static final long serialVersionUID = -1825662356883926318L;
        final String version;
        final transient ForeignExe exe;
        @Nullable
        private transient List<String> args;

        State(ShfmtStep step, ForeignExe pathToExe) {
            this.version = step.version;
            this.exe = Objects.requireNonNull(pathToExe);
        }

        String format(ProcessRunner runner, String input, File file) throws IOException, InterruptedException {
            if (this.args == null) {
                this.args = List.of(this.exe.confirmVersionAndGetAbsolutePath(), "-i", "2", "-ci");
            }
            return runner.exec(input.getBytes(StandardCharsets.UTF_8), this.args).assertExitZero(StandardCharsets.UTF_8);
        }

        FormatterFunc.Closeable toFunc() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of(runner, this::format);
        }
    }
}

