/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorBeanPostProcessor;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceNameResolver;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.DataSourceProxyConfiguration;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolConfiguration;
import com.github.gavlyukovskiy.boot.jdbc.decorator.p6spy.P6SpyConfiguration;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DataSourceDecoratorProperties.class})
@ConditionalOnProperty(name={"decorator.datasource.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={DataSource.class})
@Import(value={P6SpyConfiguration.class, DataSourceProxyConfiguration.class, FlexyPoolConfiguration.Ordered.class})
public class DataSourceDecoratorAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={DataSourceDecorator.class})
    public static DataSourceDecoratorBeanPostProcessor dataSourceDecoratorBeanPostProcessor() {
        return new DataSourceDecoratorBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSourceDecorator.class})
    public DataSourceNameResolver dataSourceNameResolver(ApplicationContext applicationContext) {
        return new DataSourceNameResolver(applicationContext);
    }
}

