/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorationStage;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DecoratedDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

public class DataSourceNameResolver {
    private static final boolean HIKARI_AVAILABLE = ClassUtils.isPresent((String)"com.zaxxer.hikari.HikariDataSource", (ClassLoader)DataSourceNameResolver.class.getClassLoader());
    private final ApplicationContext applicationContext;
    private final Map<CommonDataSource, String> cachedNames = new HashMap<CommonDataSource, String>();

    public DataSourceNameResolver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveDataSourceName(CommonDataSource dataSource) {
        String dataSourceName = this.cachedNames.get(dataSource);
        if (dataSourceName == null) {
            Map<CommonDataSource, String> map = this.cachedNames;
            synchronized (map) {
                HikariDataSource hikariDataSource;
                if (HIKARI_AVAILABLE && dataSource instanceof HikariDataSource && (hikariDataSource = (HikariDataSource)dataSource).getPoolName() != null && !hikariDataSource.getPoolName().startsWith("HikariPool-")) {
                    return hikariDataSource.getPoolName();
                }
                Map dataSources = this.applicationContext.getBeansOfType(DataSource.class);
                dataSourceName = dataSources.entrySet().stream().filter(entry -> {
                    DataSource candidate = (DataSource)entry.getValue();
                    if (candidate instanceof DecoratedDataSource) {
                        return this.matchesDataSource((DecoratedDataSource)((Object)((Object)candidate)), dataSource);
                    }
                    return candidate == dataSource;
                }).findFirst().map(Map.Entry::getKey).orElse("dataSource");
                this.cachedNames.put(dataSource, dataSourceName);
            }
        }
        return dataSourceName;
    }

    private boolean matchesDataSource(DecoratedDataSource decoratedCandidate, CommonDataSource dataSource) {
        return decoratedCandidate.getRealDataSource() == dataSource || decoratedCandidate.getDecoratingChain().stream().map(DataSourceDecorationStage::getDataSource).anyMatch(candidate -> candidate == dataSource);
    }
}

