/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorationStage;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class DecoratedDataSource
extends DelegatingDataSource {
    private final String beanName;
    private final DataSource realDataSource;
    private final DataSource decoratedDataSource;
    private final List<DataSourceDecorationStage> decoratingChain;

    DecoratedDataSource(String beanName, DataSource realDataSource, DataSource decoratedDataSource, List<DataSourceDecorationStage> decoratingChain) {
        super(decoratedDataSource);
        this.beanName = beanName;
        this.realDataSource = realDataSource;
        this.decoratedDataSource = decoratedDataSource;
        this.decoratingChain = decoratingChain;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public DataSource getRealDataSource() {
        return this.realDataSource;
    }

    public DataSource getDecoratedDataSource() {
        return this.decoratedDataSource;
    }

    public List<DataSourceDecorationStage> getDecoratingChain() {
        return this.decoratingChain;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.getRealDataSource())) {
            return (T)this.getRealDataSource();
        }
        for (DataSourceDecorationStage dataSourceDecorationStage : this.decoratingChain) {
            if (!iface.isInstance(dataSourceDecorationStage.getDataSource())) continue;
            return (T)dataSourceDecorationStage.getDataSource();
        }
        return (T)super.unwrap(iface);
    }

    public String toString() {
        return this.decoratingChain.stream().map(entry -> entry.getBeanName() + " [" + entry.getDataSource().getClass().getName() + "]").collect(Collectors.joining(" -> ")) + " -> " + this.beanName + " [" + this.realDataSource.getClass().getName() + "]";
    }
}

