/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceNameResolver;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.ConnectionIdManagerProvider;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.HibernateFormatterConfiguration;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.ProxyDataSourceBuilderConfigurer;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.ProxyDataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.SqlFormatterConfiguration;
import net.ttddyy.dsproxy.listener.QueryCountStrategy;
import net.ttddyy.dsproxy.listener.SingleQueryCountHolder;
import net.ttddyy.dsproxy.proxy.GlobalConnectionIdManager;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnMissingBean(type={"org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.DataSourceProxyConfiguration"})
@ConditionalOnClass(value={ProxyDataSource.class})
@Import(value={HibernateFormatterConfiguration.class, SqlFormatterConfiguration.class})
public class DataSourceProxyConfiguration {
    @Autowired
    private DataSourceDecoratorProperties dataSourceDecoratorProperties;

    @Bean
    @ConditionalOnMissingBean
    public ConnectionIdManagerProvider connectionIdManagerProvider() {
        return GlobalConnectionIdManager::new;
    }

    @Bean
    public ProxyDataSourceBuilderConfigurer proxyDataSourceBuilderConfigurer() {
        return new ProxyDataSourceBuilderConfigurer();
    }

    @Bean
    public ProxyDataSourceDecorator proxyDataSourceDecorator(ProxyDataSourceBuilderConfigurer proxyDataSourceBuilderConfigurer, DataSourceNameResolver dataSourceNameResolver) {
        return new ProxyDataSourceDecorator(this.dataSourceDecoratorProperties, proxyDataSourceBuilderConfigurer, dataSourceNameResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"decorator.datasource.datasource-proxy.count-query"}, havingValue="true")
    public QueryCountStrategy queryCountStrategy() {
        return new SingleQueryCountHolder();
    }
}

