/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolConfigurationBuilderCustomizer;
import com.vladmihalcea.flexypool.FlexyPoolDataSource;
import com.vladmihalcea.flexypool.adaptor.PoolAdapterFactory;
import com.vladmihalcea.flexypool.config.FlexyPoolConfiguration;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquisitionStrategyFactory;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

public class FlexyPoolDataSourceDecorator
implements DataSourceDecorator,
Ordered {
    private final ConnectionAcquisitionStrategyFactory<?, DataSource>[] ConnectionAcquisitionStrategyFactories;
    private final PoolAdapterFactory<DataSource> poolAdapterFactory;
    private final Class<DataSource> dataSourceClass;
    @Autowired(required=false)
    private List<FlexyPoolConfigurationBuilderCustomizer> customizers;

    <T extends DataSource> FlexyPoolDataSourceDecorator(List<ConnectionAcquisitionStrategyFactory<?, T>> ConnectionAcquisitionStrategyFactories, PoolAdapterFactory<T> poolAdapterFactory, Class<T> dataSourceClass) {
        this.ConnectionAcquisitionStrategyFactories = ConnectionAcquisitionStrategyFactories.toArray(new ConnectionAcquisitionStrategyFactory[0]);
        this.poolAdapterFactory = poolAdapterFactory;
        this.dataSourceClass = dataSourceClass;
    }

    FlexyPoolDataSourceDecorator() {
        this.ConnectionAcquisitionStrategyFactories = null;
        this.poolAdapterFactory = null;
        this.dataSourceClass = null;
    }

    @Override
    public DataSource decorate(String beanName, DataSource dataSource) {
        if (this.dataSourceClass == null) {
            FlexyPoolDataSource flexyPoolDataSource = new FlexyPoolDataSource(dataSource);
            flexyPoolDataSource.start();
            return flexyPoolDataSource;
        }
        if (this.dataSourceClass.isInstance(dataSource)) {
            FlexyPoolConfiguration.Builder configurationBuilder = new FlexyPoolConfiguration.Builder(beanName, this.dataSourceClass.cast(dataSource), this.poolAdapterFactory);
            if (this.customizers != null) {
                this.customizers.forEach(customizer -> customizer.customize(beanName, configurationBuilder, this.dataSourceClass));
            }
            FlexyPoolDataSource flexyPoolDataSource = new FlexyPoolDataSource(configurationBuilder.build(), this.ConnectionAcquisitionStrategyFactories);
            flexyPoolDataSource.start();
            return flexyPoolDataSource;
        }
        return dataSource;
    }

    public int getOrder() {
        return 10;
    }
}

