/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.JsonSerializable;
import com.google.genai.Tunings;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CreateTuningJobConfig;
import com.google.genai.types.GetTuningJobConfig;
import com.google.genai.types.JobState;
import com.google.genai.types.ListTuningJobsConfig;
import com.google.genai.types.TuningDataset;
import com.google.genai.types.TuningJob;
import com.google.genai.types.TuningOperation;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncTunings {
    Tunings tunings;

    public AsyncTunings(ApiClient apiClient) {
        this.tunings = new Tunings(apiClient);
    }

    public CompletableFuture<TuningJob> get(String name, GetTuningJobConfig config) {
        return CompletableFuture.supplyAsync(() -> this.tunings.privateGet(name, config));
    }

    public CompletableFuture<AsyncPager<TuningJob>> list(ListTuningJobsConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListTuningJobsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListTuningJobsConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.tunings.privateList((ListTuningJobsConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.TUNING_JOBS, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }

    public CompletableFuture<TuningJob> tune(String baseModel, TuningDataset trainingDataset, CreateTuningJobConfig config) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.tunings.apiClient.vertexAI()) {
                return this.tunings.privateTune(baseModel, trainingDataset, config);
            }
            TuningOperation operation = this.tunings.privateTuneMldev(baseModel, trainingDataset, config);
            String tunedModelName = "";
            if (operation.metadata().isPresent() && operation.metadata().get().containsKey("tunedModel")) {
                tunedModelName = (String)operation.metadata().get().get("tunedModel");
            } else {
                if (!operation.name().isPresent()) {
                    throw new IllegalArgumentException("Operation name is required.");
                }
                tunedModelName = operation.name().get().split("/operations/")[0];
            }
            return TuningJob.builder().name(tunedModelName).state(JobState.Known.JOB_STATE_QUEUED).build();
        });
    }
}

