/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.InlinedRequest;
import java.util.List;
import java.util.Optional;

final class AutoValue_InlinedRequest
extends InlinedRequest {
    private final Optional<String> model;
    private final Optional<List<Content>> contents;
    private final Optional<GenerateContentConfig> config;

    private AutoValue_InlinedRequest(Optional<String> model, Optional<List<Content>> contents, Optional<GenerateContentConfig> config) {
        this.model = model;
        this.contents = contents;
        this.config = config;
    }

    @Override
    @JsonProperty(value="model")
    public Optional<String> model() {
        return this.model;
    }

    @Override
    @JsonProperty(value="contents")
    public Optional<List<Content>> contents() {
        return this.contents;
    }

    @Override
    @JsonProperty(value="config")
    public Optional<GenerateContentConfig> config() {
        return this.config;
    }

    public String toString() {
        return "InlinedRequest{model=" + this.model + ", contents=" + this.contents + ", config=" + this.config + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InlinedRequest) {
            InlinedRequest that = (InlinedRequest)o;
            return this.model.equals(that.model()) && this.contents.equals(that.contents()) && this.config.equals(that.config());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.model.hashCode();
        h$ *= 1000003;
        h$ ^= this.contents.hashCode();
        h$ *= 1000003;
        return h$ ^= this.config.hashCode();
    }

    @Override
    public InlinedRequest.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends InlinedRequest.Builder {
        private Optional<String> model = Optional.empty();
        private Optional<List<Content>> contents = Optional.empty();
        private Optional<GenerateContentConfig> config = Optional.empty();

        Builder() {
        }

        Builder(InlinedRequest source) {
            this.model = source.model();
            this.contents = source.contents();
            this.config = source.config();
        }

        @Override
        public InlinedRequest.Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        public InlinedRequest.Builder contents(List<Content> contents) {
            this.contents = Optional.of(contents);
            return this;
        }

        @Override
        public InlinedRequest.Builder config(GenerateContentConfig config) {
            this.config = Optional.of(config);
            return this;
        }

        @Override
        public InlinedRequest build() {
            return new AutoValue_InlinedRequest(this.model, this.contents, this.config);
        }
    }
}

