/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el;

import com.hubspot.jinjava.objects.DummyObject;
import com.hubspot.jinjava.util.ObjectTruthValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import jinjava.de.odysseus.el.misc.TypeConverterImpl;
import jinjava.javax.el.ELException;

public class TruthyTypeConverter
extends TypeConverterImpl {
    private static final long serialVersionUID = 1L;
    public static final int MAX_COLLECTION_STRING_LENGTH = 1000000;

    @Override
    protected Boolean coerceToBoolean(Object value) {
        return ObjectTruthValue.evaluate(value);
    }

    @Override
    protected Character coerceToCharacter(Object value) {
        if (value instanceof DummyObject) {
            return Character.valueOf('0');
        }
        return super.coerceToCharacter(value);
    }

    @Override
    protected BigDecimal coerceToBigDecimal(Object value) {
        if (value instanceof DummyObject) {
            return BigDecimal.ZERO;
        }
        return super.coerceToBigDecimal(value);
    }

    @Override
    protected BigInteger coerceToBigInteger(Object value) {
        if (value instanceof DummyObject) {
            return BigInteger.ZERO;
        }
        return super.coerceToBigInteger(value);
    }

    @Override
    protected Double coerceToDouble(Object value) {
        if (value instanceof DummyObject) {
            return 0.0;
        }
        return super.coerceToDouble(value);
    }

    @Override
    protected Float coerceToFloat(Object value) {
        if (value instanceof DummyObject) {
            return Float.valueOf(0.0f);
        }
        return super.coerceToFloat(value);
    }

    @Override
    protected Long coerceToLong(Object value) {
        if (value instanceof DummyObject) {
            return 0L;
        }
        return super.coerceToLong(value);
    }

    @Override
    protected Integer coerceToInteger(Object value) {
        if (value instanceof DummyObject) {
            return 0;
        }
        return super.coerceToInteger(value);
    }

    @Override
    protected Short coerceToShort(Object value) {
        if (value instanceof DummyObject) {
            return (short)0;
        }
        return super.coerceToShort(value);
    }

    @Override
    protected Byte coerceToByte(Object value) {
        if (value instanceof DummyObject) {
            return (byte)0;
        }
        return super.coerceToByte(value);
    }

    @Override
    protected String coerceToString(Object value) {
        if (value instanceof DummyObject) {
            return "";
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Collection) {
            return this.coerceCollection((Collection)value);
        }
        return value.toString();
    }

    private String coerceCollection(Collection value) {
        Iterator it = value.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (sb.length() > 1000000) {
                return sb.append(", ...]").toString();
            }
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',');
            sb.append(' ');
        }
    }

    @Override
    protected <T extends Enum<T>> T coerceToEnum(Object value, Class<T> type) {
        EnumSet<T> enumSet;
        if (value instanceof DummyObject && !(enumSet = EnumSet.allOf(type)).isEmpty()) {
            return (T)((Enum)enumSet.iterator().next());
        }
        try {
            return super.coerceToEnum(value, type);
        }
        catch (ELException e) {
            if (value instanceof String) {
                for (Enum enumVal : (Enum[])type.getEnumConstants()) {
                    String enumStr = enumVal.toString();
                    if (enumStr == null || !enumStr.equalsIgnoreCase((String)value)) continue;
                    return (T)enumVal;
                }
            }
            throw e;
        }
    }

    @Override
    protected Object coerceStringToType(String value, Class<?> type) {
        return super.coerceStringToType(value, type);
    }

    @Override
    protected Object coerceToType(Object value, Class<?> type) {
        return super.coerceToType(value, type);
    }
}

