/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractFilter
implements Filter {
    private static final Map<Class, Map<String, JinjavaParam>> NAMED_ARGUMENTS_CACHE = new ConcurrentHashMap<Class, Map<String, JinjavaParam>>();
    private static final Map<Class, Map<String, Object>> DEFAULT_VALUES_CACHE = new ConcurrentHashMap<Class, Map<String, Object>>();
    private final Map<String, JinjavaParam> namedArguments = NAMED_ARGUMENTS_CACHE.computeIfAbsent(this.getClass(), cls -> this.initNamedArguments());
    private final Map<String, Object> defaultValues = DEFAULT_VALUES_CACHE.computeIfAbsent(this.getClass(), cls -> this.initDefaultValues());

    abstract Object filter(Object var1, JinjavaInterpreter var2, Map<String, Object> var3);

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        return this.filter(var, interpreter, (Object[])args, Collections.emptyMap());
    }

    @Override
    @SuppressFBWarnings(value={"UC_USELESS_OBJECT"}, justification="FB bug prevents forEach() method call counting `namedArgs` as used (fixed in next release)")
    public Object filter(Object var, JinjavaInterpreter interpreter, Object[] args, Map<String, Object> kwargs) {
        String argName;
        HashMap<String, Object> namedArgs = new HashMap<String, Object>(this.defaultValues);
        for (Map.Entry<String, Object> passedNamedArgEntry : kwargs.entrySet()) {
            argName = passedNamedArgEntry.getKey();
            Object argValue = passedNamedArgEntry.getValue();
            int argPosition = this.getNamedArgumentPosition(argName);
            if (argPosition == -1) {
                throw new InvalidInputException(interpreter, "INVALID_ARG_NAME", String.format("Argument named '%s' is invalid for filter %s", argName, this.getName()));
            }
            namedArgs.put(argName, argValue);
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            argName = this.getIndexedArgumentName(i);
            if (argName == null) {
                throw new InvalidInputException(interpreter, "INVALID_ARG_NAME", String.format("Argument at index '%s' is invalid for filter %s", i, this.getName()));
            }
            namedArgs.put(argName, arg);
        }
        HashMap<String, Object> parsedArgs = new HashMap<String, Object>();
        namedArgs.forEach((k, v) -> parsedArgs.put((String)k, this.parseArg(interpreter, this.namedArguments.get(k), v)));
        this.validateArgs(interpreter, parsedArgs);
        return this.filter(var, interpreter, parsedArgs);
    }

    protected Object parseArg(JinjavaInterpreter interpreter, JinjavaParam jinjavaParamMetadata, Object value) {
        if (jinjavaParamMetadata.type() == null || value == null || Arrays.asList("object", "dict", "sequence").contains(jinjavaParamMetadata.type())) {
            return value;
        }
        String valueString = Objects.toString(value, null);
        switch (jinjavaParamMetadata.type().toLowerCase()) {
            case "boolean": {
                return value instanceof Boolean ? (Boolean)value : BooleanUtils.toBooleanObject((String)valueString);
            }
            case "int": {
                return value instanceof Integer ? (Integer)value : NumberUtils.toInt((String)valueString);
            }
            case "long": {
                return value instanceof Long ? (Long)value : NumberUtils.toLong((String)valueString);
            }
            case "float": {
                return Float.valueOf(value instanceof Float ? ((Float)value).floatValue() : NumberUtils.toFloat((String)valueString));
            }
            case "double": {
                return value instanceof Double ? (Double)value : NumberUtils.toDouble((String)valueString);
            }
            case "number": {
                return value instanceof Number ? (Number)value : new BigDecimal(valueString);
            }
            case "string": {
                return valueString;
            }
        }
        throw new InvalidInputException(interpreter, "INVALID_ARG_NAME", String.format("Argument named '%s' with value '%s' cannot be parsed for filter %s", jinjavaParamMetadata.value(), value, this.getName()));
    }

    public void validateArgs(JinjavaInterpreter interpreter, Map<String, Object> parsedArgs) {
        for (JinjavaParam jinjavaParam : this.namedArguments.values()) {
            if (!jinjavaParam.required() || parsedArgs.containsKey(jinjavaParam.value())) continue;
            throw new InvalidInputException(interpreter, "MISSING_REQUIRED_ARG", String.format("Argument named '%s' is required but missing for filter %s", jinjavaParam.value(), this.getName()));
        }
    }

    public int getNamedArgumentPosition(String argName) {
        return Optional.ofNullable(this.namedArguments).map(Map::keySet).map(ArrayList::new).flatMap(argNames -> Optional.of(argNames.indexOf(argName))).orElse(-1);
    }

    public String getIndexedArgumentName(int position) {
        return Optional.ofNullable(this.namedArguments).map(Map::keySet).map(ArrayList::new).flatMap(argNames -> Optional.ofNullable(argNames.size() > position ? (String)argNames.get(position) : null)).orElse(null);
    }

    public Map<String, JinjavaParam> initNamedArguments() {
        JinjavaDoc jinjavaDoc = this.getClass().getAnnotation(JinjavaDoc.class);
        if (jinjavaDoc != null && !Strings.isNullOrEmpty((String)jinjavaDoc.aliasOf())) {
            jinjavaDoc = this.getClass().getSuperclass().getAnnotation(JinjavaDoc.class);
        }
        if (jinjavaDoc != null) {
            ImmutableMap.Builder namedArgsBuilder = ImmutableMap.builder();
            Arrays.stream(jinjavaDoc.params()).forEachOrdered(jinjavaParam -> namedArgsBuilder.put((Object)jinjavaParam.value(), jinjavaParam));
            return namedArgsBuilder.build();
        }
        throw new UnsupportedOperationException(String.format("%s: @JinjavaDoc must be configured for filter %s to function", this.getClass(), this.getName()));
    }

    public Map<String, Object> initDefaultValues() {
        return (Map)this.namedArguments.entrySet().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)((JinjavaParam)e.getValue()).defaultValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((JinjavaParam)e.getValue()).defaultValue()));
    }
}

