/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.io.IOException;

@JinjavaDoc(value="Converts a YAML string to an object", input={@JinjavaParam(value="string", desc="YAML String to convert to an object", required=true)}, snippets={@JinjavaSnippet(code="{{object|fromYaml}}")})
public class FromYamlFilter
implements Filter {
    private static final YAMLMapper OBJECT_MAPPER = new YAMLMapper();

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var == null) {
            return null;
        }
        if (!(var instanceof String)) {
            throw new InvalidInputException(interpreter, this, InvalidReason.STRING, new Object[0]);
        }
        try {
            return OBJECT_MAPPER.readValue((String)var, Object.class);
        }
        catch (IOException e) {
            throw new InvalidInputException(interpreter, this, InvalidReason.JSON_READ, new Object[0]);
        }
    }

    @Override
    public String getName() {
        return "fromyaml";
    }
}

