/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaHasCodeBody;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.doc.annotations.JinjavaTextMateSnippet;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.TagNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Macros allow you to print multiple statements with a dynamic value or values", params={@JinjavaParam(value="macro_name", desc="The name given to a macro"), @JinjavaParam(value="argument_names", desc="Named arguments that are dynamically, when the macro is run")}, snippets={@JinjavaSnippet(desc="Basic macro syntax", code="{% macro name_of_macro(argument_name, argument_name2) %}\n    {{ argument_name }}\n    {{ argument_name2 }}\n{% endmacro %}\n{{ name_of_macro(\"value to pass to argument 1\", \"value to pass to argument 2\") }}"), @JinjavaSnippet(desc="Example of a macro used to print CSS3 properties with the various vendor prefixes", code="{% macro trans(value) %}\n   -webkit-transition: {{value}};\n   -moz-transition: {{value}};\n   -o-transition: {{value}};\n   -ms-transition: {{value}};\n   transition: {{value}};\n{% endmacro %}"), @JinjavaSnippet(desc="The macro can then be called like a function. The macro is printed for anchor tags in CSS.", code="a { {{ trans(\"all .2s ease-in-out\") }} }")})
@JinjavaHasCodeBody
@JinjavaTextMateSnippet(code="{% macro ${1:name}(${2:values) %}\n\t$0\n{% endmacro %}")
public class MacroTag
implements Tag {
    public static final String TAG_NAME = "macro";
    private static final long serialVersionUID = 8397609322126956077L;
    public static final Pattern CHILD_MACRO_PATTERN = Pattern.compile("([a-zA-Z_][\\w_]*)\\.([a-zA-Z_][\\w_]*)[^(]*\\(([^)]*)\\)");
    public static final Pattern MACRO_PATTERN = Pattern.compile("([a-zA-Z_][\\w_]*)[^(]*\\(([^)]*)\\)");
    private static final Splitter ARGS_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        parentName = "";
        childMatcher = MacroTag.CHILD_MACRO_PATTERN.matcher(tagNode.getHelpers());
        if (childMatcher.find()) {
            parentName = childMatcher.group(1);
            name = childMatcher.group(2);
            args = Strings.nullToEmpty((String)childMatcher.group(3));
        } else {
            matcher = MacroTag.MACRO_PATTERN.matcher(tagNode.getHelpers());
            if (!matcher.find()) {
                throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Unable to parse macro definition: " + tagNode.getHelpers(), tagNode.getLineNumber(), tagNode.getStartPosition());
            }
            name = matcher.group(1);
            args = Strings.nullToEmpty((String)matcher.group(2));
        }
        argNamesWithDefaults = new LinkedHashMap<String, Object>();
        deferred = MacroTag.populateArgNames(tagNode.getLineNumber(), interpreter, args, argNamesWithDefaults);
        contextImportResourcePath /* !! */  = interpreter.getContext().get("deferred_import_resource_path");
        if (contextImportResourcePath /* !! */  instanceof DeferredValue) {
            contextImportResourcePath /* !! */  = ((DeferredValue)contextImportResourcePath /* !! */ ).getOriginalValue();
        }
        scopeEntered = false;
        try {
            if (StringUtils.isNotEmpty((CharSequence)((String)contextImportResourcePath /* !! */ ))) {
                scopeEntered = true;
                interpreter.enterScope();
                interpreter.getContext().put("import_resource_path", contextImportResourcePath /* !! */ );
            }
            macro = this.constructMacroFunction(tagNode, interpreter, name, argNamesWithDefaults);
        }
        finally {
            if (scopeEntered) {
                interpreter.leaveScope();
            }
        }
        macro.setDeferred(deferred);
        if (StringUtils.isNotEmpty((CharSequence)parentName)) {
            try {
                if (!(interpreter.getContext().get(parentName) instanceof DeferredValue)) {
                    macroOfParent = interpreter.getContext().getOrDefault(parentName, new HashMap<K, V>());
                    macroOfParent.put(macro.getName(), macro);
                    if (interpreter.getContext().containsKey(parentName)) ** GOTO lbl58
                    interpreter.getContext().put(parentName, macroOfParent);
                }
                originalValue = ((DeferredValue)interpreter.getContext().get(parentName)).getOriginalValue();
                if (originalValue instanceof Map) {
                    ((Map)originalValue).put(macro.getName(), macro);
                }
                macroOfParent = new HashMap<String, MacroFunction>();
                macroOfParent.put(macro.getName(), macro);
                interpreter.getContext().put(parentName, DeferredValue.instance(macroOfParent));
            }
            catch (ClassCastException e) {
                throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Unable to parse macro as a child of: " + parentName, tagNode.getLineNumber(), tagNode.getStartPosition());
            }
        } else {
            interpreter.getContext().addGlobalMacro(macro);
        }
lbl58:
        // 5 sources

        if (deferred) {
            throw new DeferredValueException(name, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        return "";
    }

    protected MacroFunction constructMacroFunction(TagNode tagNode, JinjavaInterpreter interpreter, String name, LinkedHashMap<String, Object> argNamesWithDefaults) {
        return new MacroFunction(tagNode.getChildren(), name, argNamesWithDefaults, false, interpreter.getContext(), interpreter.getLineNumber(), interpreter.getPosition());
    }

    public static boolean populateArgNames(int lineNumber, JinjavaInterpreter interpreter, String args, LinkedHashMap<String, Object> argNamesWithDefaults) {
        ArrayList argList = Lists.newArrayList((Iterable)ARGS_SPLITTER.split((CharSequence)args));
        boolean deferred = false;
        for (int i = 0; i < argList.size(); ++i) {
            String arg = (String)argList.get(i);
            if (arg.contains("=")) {
                String argName = StringUtils.substringBefore((String)arg, (String)"=").trim();
                StringBuilder argValStr = new StringBuilder(StringUtils.substringAfter((String)arg, (String)"=").trim());
                if (StringUtils.startsWith((CharSequence)argValStr, (CharSequence)"[") && !StringUtils.endsWith((CharSequence)argValStr, (CharSequence)"]")) {
                    while (i + 1 < argList.size() && !StringUtils.endsWith((CharSequence)argValStr, (CharSequence)"]")) {
                        argValStr.append(", ").append((String)argList.get(i + 1));
                        ++i;
                    }
                }
                try {
                    Object argVal = interpreter.resolveELExpression(argValStr.toString(), lineNumber);
                    argNamesWithDefaults.put(argName, argVal);
                }
                catch (DeferredValueException e) {
                    deferred = true;
                }
                continue;
            }
            argNamesWithDefaults.put(arg, null);
        }
        return deferred;
    }
}

