/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.mode;

import com.google.common.collect.ImmutableSet;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.lib.expression.EagerExpressionStrategy;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.lib.tag.eager.EagerTagDecorator;
import com.hubspot.jinjava.lib.tag.eager.EagerTagFactory;
import com.hubspot.jinjava.mode.ExecutionMode;
import java.util.Collection;
import java.util.Optional;

public class EagerExecutionMode
implements ExecutionMode {
    private static final ExecutionMode INSTANCE = new EagerExecutionMode();
    public static final ImmutableSet<String> STATIC_META_CONTEXT_VARIABLES = ImmutableSet.of((Object)"__macros__", (Object)"import_resource_path", (Object)"deferred_import_resource_path", (Object)"import_resource_alias", (Object)"current_path");

    protected EagerExecutionMode() {
    }

    public static ExecutionMode instance() {
        return INSTANCE;
    }

    @Override
    public boolean isPreserveRawTags() {
        return true;
    }

    @Override
    public boolean useEagerParser() {
        return true;
    }

    @Override
    public boolean useEagerContextReverting() {
        return true;
    }

    @Override
    public void prepareContext(Context context) {
        context.getAllTags().stream().filter(tag -> !(tag instanceof EagerTagDecorator)).map(EagerTagFactory::getEagerTagDecorator).filter(Optional::isPresent).forEach(maybeEagerTag -> context.registerTag((Tag)maybeEagerTag.get()));
        context.setExpressionStrategy(new EagerExpressionStrategy());
        context.getMetaContextVariables().addAll((Collection<String>)STATIC_META_CONTEXT_VARIABLES);
    }
}

