/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.date;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.objects.date.InvalidDateFormatException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class StrftimeFormatter {
    public static final String DEFAULT_DATE_FORMAT = "%H:%M / %d-%m-%Y";
    private static final Map<Character, ConversionComponent> COMPONENTS = ImmutableMap.builder().put((Object)Character.valueOf('a'), (Object)ConversionComponent.pattern("EEE")).put((Object)Character.valueOf('A'), (Object)ConversionComponent.pattern("EEEE")).put((Object)Character.valueOf('b'), (Object)ConversionComponent.pattern("MMM")).put((Object)Character.valueOf('B'), (Object)ConversionComponent.pattern("MMMM")).put((Object)Character.valueOf('c'), (Object)ConversionComponent.localized(FormatStyle.MEDIUM, FormatStyle.MEDIUM)).put((Object)Character.valueOf('d'), (Object)ConversionComponent.pattern("dd")).put((Object)Character.valueOf('e'), (Object)ConversionComponent.pattern("d")).put((Object)Character.valueOf('f'), (Object)ConversionComponent.pattern("SSSSSS")).put((Object)Character.valueOf('H'), (Object)ConversionComponent.pattern("HH")).put((Object)Character.valueOf('h'), (Object)ConversionComponent.pattern("hh")).put((Object)Character.valueOf('I'), (Object)ConversionComponent.pattern("hh")).put((Object)Character.valueOf('j'), (Object)ConversionComponent.pattern("DDD")).put((Object)Character.valueOf('k'), (Object)ConversionComponent.pattern("H")).put((Object)Character.valueOf('l'), (Object)ConversionComponent.pattern("h")).put((Object)Character.valueOf('m'), (Object)ConversionComponent.pattern("MM")).put((Object)Character.valueOf('M'), (Object)ConversionComponent.pattern("mm")).put((Object)Character.valueOf('p'), (Object)ConversionComponent.pattern("a")).put((Object)Character.valueOf('S'), (Object)ConversionComponent.pattern("ss")).put((Object)Character.valueOf('U'), (Object)ConversionComponent.pattern("ww")).put((Object)Character.valueOf('w'), (Object)ConversionComponent.pattern("e")).put((Object)Character.valueOf('W'), (Object)ConversionComponent.pattern("ww")).put((Object)Character.valueOf('x'), (Object)ConversionComponent.localized(FormatStyle.SHORT, null)).put((Object)Character.valueOf('X'), (Object)ConversionComponent.localized(null, FormatStyle.MEDIUM)).put((Object)Character.valueOf('y'), (Object)ConversionComponent.pattern("yy")).put((Object)Character.valueOf('Y'), (Object)ConversionComponent.pattern("yyyy")).put((Object)Character.valueOf('z'), (Object)ConversionComponent.pattern("Z")).put((Object)Character.valueOf('Z'), (Object)ConversionComponent.pattern("z")).put((Object)Character.valueOf('%'), (builder, stripLeadingZero) -> builder.appendLiteral("%")).build();
    private static final Map<Character, ConversionComponent> NOMINATIVE_COMPONENTS = ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)ConversionComponent.pattern("LLLL")).build();

    public static DateTimeFormatter toDateTimeFormatter(String strftime) {
        if (!StringUtils.contains((CharSequence)strftime, (int)37)) {
            return DateTimeFormatter.ofPattern(strftime);
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        for (int i = 0; i < strftime.length(); ++i) {
            char c = strftime.charAt(i);
            if (c != '%' || strftime.length() <= i + 1) {
                builder.appendLiteral(c);
                continue;
            }
            c = strftime.charAt(++i);
            boolean stripLeadingZero = false;
            Map<Character, ConversionComponent> components = COMPONENTS;
            if (c == '-') {
                stripLeadingZero = true;
                c = strftime.charAt(++i);
            }
            if (c == 'O') {
                c = strftime.charAt(++i);
                components = NOMINATIVE_COMPONENTS;
            }
            char finalChar = c;
            Optional.ofNullable(components.get(Character.valueOf(finalChar))).orElseThrow(() -> new InvalidDateFormatException(strftime, String.format("unknown format code '%s'", Character.valueOf(finalChar)))).append(builder, stripLeadingZero);
        }
        return builder.toFormatter();
    }

    private static DateTimeFormatter formatter(String strftime, Locale locale) {
        DateTimeFormatter fmt;
        if (strftime == null) {
            strftime = "";
        }
        switch (strftime.toLowerCase()) {
            case "short": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
                break;
            }
            case "medium": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
                break;
            }
            case "long": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);
                break;
            }
            case "full": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
                break;
            }
            default: {
                try {
                    fmt = StrftimeFormatter.toDateTimeFormatter(strftime);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidDateFormatException(strftime, e);
                }
            }
        }
        return fmt.withLocale(locale);
    }

    public static String format(ZonedDateTime d) {
        return StrftimeFormatter.format(d, DEFAULT_DATE_FORMAT);
    }

    public static String format(ZonedDateTime d, Locale locale) {
        return StrftimeFormatter.format(d, DEFAULT_DATE_FORMAT, locale);
    }

    public static String format(ZonedDateTime d, String strftime) {
        return StrftimeFormatter.format(d, strftime, JinjavaInterpreter.getCurrentMaybe().map(JinjavaInterpreter::getConfig).map(JinjavaConfig::getLocale).orElse(Locale.ENGLISH));
    }

    public static String format(ZonedDateTime d, String strftime, Locale locale) {
        return StrftimeFormatter.formatter(strftime, locale).format(d);
    }

    static interface ConversionComponent {
        public DateTimeFormatterBuilder append(DateTimeFormatterBuilder var1, boolean var2);

        public static ConversionComponent pattern(String targetPattern) {
            return (builder, stripLeadingZero) -> builder.appendPattern(stripLeadingZero ? targetPattern.substring(1) : targetPattern);
        }

        public static ConversionComponent localized(FormatStyle dateStyle, FormatStyle timeStyle) {
            return (builder, stripLeadingZero) -> builder.appendLocalized(dateStyle, timeStyle);
        }
    }
}

