/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.UnknownTokenException;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import com.hubspot.jinjava.tree.ExpressionNode;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.parse.ExpressionToken;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import com.hubspot.jinjava.util.WhitespaceUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jinjava.javax.el.ELException;
import org.apache.commons.lang3.StringUtils;

@Beta
public class EagerExpressionResolver {
    public static final String JINJAVA_NULL = "null";
    public static final String JINJAVA_EMPTY_STRING = "''";
    private static final Set<String> RESERVED_KEYWORDS = ImmutableSet.of((Object)"and", (Object)"filter", (Object)"in", (Object)"is", (Object)"not", (Object)"or", (Object[])new String[]{"pluralize", "recursive", "trans", "null", "true", "false", "__macros__", "____int3rpr3t3r____", "exptest"});
    private static final Pattern NAMED_PARAMETER_KEY_PATTERN = Pattern.compile("[\\w.]+=([^=]|$)");
    private static final Pattern DICTIONARY_KEY_PATTERN = Pattern.compile("\\w+: ");

    public static EagerExpressionResult resolveExpression(String expression, JinjavaInterpreter interpreter) {
        Object result;
        boolean fullyResolved = false;
        HashSet<String> deferredWords = new HashSet<String>();
        try {
            result = interpreter.resolveELExpression(expression, interpreter.getLineNumber());
            fullyResolved = true;
        }
        catch (DeferredParsingException e) {
            deferredWords.addAll(EagerExpressionResolver.findDeferredWords(e.getDeferredEvalResult(), interpreter));
            result = e.getDeferredEvalResult().trim();
        }
        catch (DeferredValueException e) {
            deferredWords.addAll(EagerExpressionResolver.findDeferredWords(expression, interpreter));
            result = expression;
        }
        catch (TemplateSyntaxException e) {
            result = Collections.singletonList(null);
            fullyResolved = true;
        }
        return new EagerExpressionResult(result, deferredWords, fullyResolved ? EagerExpressionResult.ResolutionState.FULL : EagerExpressionResult.ResolutionState.PARTIAL);
    }

    public static String getValueAsJinjavaStringSafe(Object val) {
        try {
            String pyishString;
            if (val == null) {
                return JINJAVA_NULL;
            }
            if (EagerExpressionResolver.isResolvableObject(val) && (pyishString = PyishObjectMapper.getAsPyishStringOrThrow(val)).length() < 0x100000) {
                return pyishString;
            }
        }
        catch (OutputTooBigException | IOException exception) {
            // empty catch block
        }
        throw new DeferredValueException("Can not convert deferred result to string");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> findDeferredWords(String partiallyResolved, JinjavaInterpreter interpreter) {
        TokenScannerSymbols scannerSymbols = interpreter.getConfig().getTokenScannerSymbols();
        boolean nestedInterpretationEnabled = interpreter.getConfig().isNestedInterpretationEnabled();
        boolean throwInterpreterErrorsStart = interpreter.getContext().getThrowInterpreterErrors();
        FoundQuotedExpressionTags foundQuotedExpressionTags = new FoundQuotedExpressionTags();
        try {
            int curPos;
            interpreter.getContext().setThrowInterpreterErrors(true);
            HashSet<String> words = new HashSet<String>();
            char[] value = partiallyResolved.toCharArray();
            int prevQuotePos = -1;
            char prevChar = '\u0000';
            boolean inQuote = false;
            char quoteChar = '\u0000';
            for (curPos = 0; curPos < partiallyResolved.length(); ++curPos) {
                char c = value[curPos];
                if (inQuote) {
                    if (c == quoteChar && prevChar != '\\') {
                        if (nestedInterpretationEnabled) {
                            EagerExpressionResolver.getDeferredWordsInsideNestedExpression(interpreter, scannerSymbols, words, partiallyResolved.substring(prevQuotePos, curPos + 1), prevQuotePos, foundQuotedExpressionTags);
                        }
                        inQuote = false;
                        prevQuotePos = curPos;
                    }
                } else if ((c == '\'' || c == '\"') && prevChar != '\\') {
                    inQuote = true;
                    quoteChar = c;
                    words.addAll(EagerExpressionResolver.findDeferredWordsInSubstring(partiallyResolved, prevQuotePos + 1, curPos, interpreter));
                    prevQuotePos = curPos;
                }
                prevChar = c;
            }
            words.addAll(EagerExpressionResolver.findDeferredWordsInSubstring(partiallyResolved, prevQuotePos + 1, curPos, interpreter));
            if (foundQuotedExpressionTags.fullTagMayExist()) {
                throw new DeferredValueException("Cannot get words inside nested interpretation tags");
            }
            HashSet<String> hashSet = words;
            return hashSet;
        }
        finally {
            interpreter.getContext().setThrowInterpreterErrors(throwInterpreterErrorsStart);
        }
    }

    private static void getDeferredWordsInsideNestedExpression(JinjavaInterpreter interpreter, TokenScannerSymbols scannerSymbols, Set<String> words, String quoted, int offset, FoundQuotedExpressionTags foundQuotedExpressionTags) {
        int endWithIndex;
        int startWithIndex;
        if (foundQuotedExpressionTags.firstStartTagFoundLocation == null && (startWithIndex = quoted.indexOf(scannerSymbols.getExpressionStartWithTag())) >= 0) {
            foundQuotedExpressionTags.firstStartTagFoundLocation = startWithIndex + offset;
        }
        if (foundQuotedExpressionTags.firstStartTagFoundLocation != null && (endWithIndex = quoted.indexOf(scannerSymbols.getExpressionEndWithTag())) >= 0) {
            foundQuotedExpressionTags.lastEndTagFoundLocation = endWithIndex + offset;
        }
        if (quoted.contains(scannerSymbols.getExpressionStart()) && quoted.contains(scannerSymbols.getExpressionEnd())) {
            List<ExpressionNode> expressionNodes = EagerExpressionResolver.getExpressionNodes(WhitespaceUtils.unquoteAndUnescape(quoted), interpreter);
            words.addAll(expressionNodes.stream().map(expressionNode -> ((ExpressionToken)expressionNode.getMaster()).getExpr()).map(expr -> EagerExpressionResolver.findDeferredWords(expr, interpreter)).flatMap(Collection::stream).collect(Collectors.toSet()));
        }
    }

    private static List<ExpressionNode> getExpressionNodes(String input, JinjavaInterpreter interpreter) {
        Node root = interpreter.parse(input);
        return EagerExpressionResolver.getExpressionNodes(root).collect(Collectors.toList());
    }

    private static Stream<ExpressionNode> getExpressionNodes(Node parent) {
        if (parent instanceof ExpressionNode) {
            return Stream.of((ExpressionNode)parent);
        }
        return parent.getChildren().stream().flatMap(EagerExpressionResolver::getExpressionNodes);
    }

    private static Set<String> findDeferredWordsInSubstring(String partiallyResolved, int start, int end, JinjavaInterpreter interpreter) {
        partiallyResolved = partiallyResolved.substring(start, end);
        if (!interpreter.getConfig().getLegacyOverrides().isEvaluateMapKeys()) {
            partiallyResolved = DICTIONARY_KEY_PATTERN.matcher(partiallyResolved).replaceAll(" ");
        }
        return Arrays.stream(NAMED_PARAMETER_KEY_PATTERN.matcher(partiallyResolved).replaceAll("$1").split("[^\\w.]")).filter(StringUtils::isNotBlank).filter(w -> EagerExpressionResolver.shouldBeEvaluated(w, interpreter)).collect(Collectors.toSet());
    }

    public static boolean shouldBeEvaluated(String w, JinjavaInterpreter interpreter) {
        try {
            if (RESERVED_KEYWORDS.contains(w)) {
                return false;
            }
            try {
                Object val = interpreter.retraceVariable(w, interpreter.getLineNumber());
                if (val != null) {
                    return true;
                }
            }
            catch (UnknownTokenException val) {
                // empty catch block
            }
            return interpreter.resolveELExpressionSilently(w) == null;
        }
        catch (DeferredValueException | TemplateSyntaxException | ELException e) {
            return true;
        }
    }

    public static boolean isResolvableObject(Object val, int maxDepth, int maxSize) {
        return EagerExpressionResolver.isResolvableObjectRec(val, 0, maxDepth, maxSize);
    }

    public static boolean isResolvableObject(Object val) {
        return EagerExpressionResolver.isResolvableObjectRec(val, 0, 10, Integer.MAX_VALUE);
    }

    private static boolean isResolvableObjectRec(Object val, int depth, int maxDepth, int maxSize) {
        if (depth > maxDepth) {
            return false;
        }
        if (EagerExpressionResolver.isPrimitive(val)) {
            return true;
        }
        if (val instanceof Collection || val instanceof Map) {
            int size;
            int n = size = val instanceof Collection ? ((Collection)val).size() : ((Map)val).size();
            if (size == 0) {
                return true;
            }
            if (size > maxSize) {
                return false;
            }
            return (val instanceof Collection ? (Collection)val : ((Map)val).values()).stream().filter(Objects::nonNull).allMatch(item -> EagerExpressionResolver.isResolvableObjectRec(item, depth + 1, maxDepth, maxSize));
        }
        if (val.getClass().isArray()) {
            if (((Object[])val).length == 0) {
                return true;
            }
            if (((Object[])val).length > maxSize) {
                return false;
            }
            return Arrays.stream((Object[])val).filter(Objects::nonNull).allMatch(item -> EagerExpressionResolver.isResolvableObjectRec(item, depth + 1, maxDepth, maxSize));
        }
        return PyishSerializable.class.isAssignableFrom(val.getClass());
    }

    public static boolean isPrimitive(Object val) {
        return val == null || Primitives.isWrapperType(val.getClass()) || val instanceof String || val instanceof Number;
    }

    private static class FoundQuotedExpressionTags {
        Integer firstStartTagFoundLocation;
        Integer lastEndTagFoundLocation;

        private FoundQuotedExpressionTags() {
        }

        boolean fullTagMayExist() {
            return this.firstStartTagFoundLocation != null && this.lastEndTagFoundLocation != null && this.firstStartTagFoundLocation < this.lastEndTagFoundLocation;
        }
    }

    public static class EagerExpressionResult {
        private final Object resolvedObject;
        private final Set<String> deferredWords;
        private final ResolutionState resolutionState;

        private EagerExpressionResult(Object resolvedObject, Set<String> deferredWords, ResolutionState resolutionState) {
            this.resolvedObject = resolvedObject;
            this.deferredWords = deferredWords;
            this.resolutionState = resolutionState;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean forOutput) {
            Set<String> dependentWords;
            if (!this.resolutionState.fullyResolved) {
                return (String)this.resolvedObject;
            }
            if (this.resolvedObject == null) {
                return forOutput ? "" : EagerExpressionResolver.JINJAVA_EMPTY_STRING;
            }
            JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
            String asString = forOutput && interpreter != null ? interpreter.getAsString(this.resolvedObject) : PyishObjectMapper.getAsPyishString(this.resolvedObject);
            if (!forOutput && interpreter != null && interpreter.getConfig().isNestedInterpretationEnabled() && asString.contains(interpreter.getConfig().getTokenScannerSymbols().getExpressionStart()) && !(dependentWords = EagerExpressionResolver.findDeferredWords(asString, interpreter)).isEmpty()) {
                this.deferredWords.addAll(dependentWords);
                return asString;
            }
            return asString;
        }

        public List<?> toList() {
            if (this.resolutionState.fullyResolved) {
                if (this.resolvedObject instanceof List) {
                    return (List)this.resolvedObject;
                }
                return Collections.singletonList(this.resolvedObject);
            }
            throw new DeferredValueException("Object is not resolved");
        }

        public ResolutionState getResolutionState() {
            return this.resolutionState;
        }

        public boolean isFullyResolved() {
            return this.resolutionState.fullyResolved;
        }

        public Set<String> getDeferredWords() {
            return this.deferredWords;
        }

        public static EagerExpressionResult fromString(String resolvedString) {
            return new EagerExpressionResult(resolvedString, Collections.emptySet(), ResolutionState.PARTIAL);
        }

        public static EagerExpressionResult fromString(String resolvedString, ResolutionState resolutionState) {
            return new EagerExpressionResult(resolvedString, Collections.emptySet(), resolutionState);
        }

        public static EagerExpressionResult fromSupplier(Supplier<String> stringSupplier, JinjavaInterpreter interpreter) {
            try {
                return EagerExpressionResult.fromString(stringSupplier.get(), interpreter.getContext().getDeferredTokens().isEmpty() ? ResolutionState.FULL : ResolutionState.PARTIAL);
            }
            catch (DeferredValueException e) {
                return EagerExpressionResult.fromString(e.getMessage(), ResolutionState.NONE);
            }
        }

        public static enum ResolutionState {
            FULL(true),
            PARTIAL(false),
            NONE(false);

            final boolean fullyResolved;

            private ResolutionState(boolean fullyResolved) {
                this.fullyResolved = fullyResolved;
            }
        }
    }
}

