/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.hubspot.jinjava.interpret.OutputTooBigException;
import java.io.Serializable;
import java.util.stream.IntStream;

public class LengthLimitingStringBuilder
implements Serializable,
CharSequence,
Appendable {
    private static final long serialVersionUID = -1891922886257965755L;
    private final StringBuilder builder = new StringBuilder();
    private long length = 0L;
    private final long maxLength;

    public LengthLimitingStringBuilder(long maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }

    @Override
    public IntStream chars() {
        return this.builder.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.builder.codePoints();
    }

    public void append(Object obj) {
        this.append(String.valueOf(obj));
    }

    @Override
    public LengthLimitingStringBuilder append(CharSequence csq) {
        int csqLength = 4;
        if (csq != null) {
            csqLength = csq.length();
        }
        this.length += (long)csqLength;
        this.checkLength();
        this.builder.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        int csqLength = 4;
        if (csq != null) {
            csqLength = end - start;
        }
        this.length += (long)csqLength;
        this.checkLength();
        this.builder.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) {
        ++this.length;
        this.checkLength();
        this.builder.append(c);
        return this;
    }

    private void checkLength() {
        if (this.maxLength > 0L && this.length > this.maxLength) {
            throw new OutputTooBigException(this.maxLength, this.length);
        }
    }
}

