/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.FrameLocator;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.FrameLocatorImpl;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.LocatorUtils;
import com.microsoft.playwright.impl.Logger;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.RequestImpl;
import com.microsoft.playwright.impl.ResponseImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.impl.TimeoutSettings;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.Waitable;
import com.microsoft.playwright.impl.WaitableRace;
import com.microsoft.playwright.options.AriaRole;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.LoadState;
import com.microsoft.playwright.options.SelectOption;
import com.microsoft.playwright.options.WaitUntilState;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class FrameImpl
extends ChannelOwner
implements Frame {
    private String name;
    private String url;
    FrameImpl parentFrame;
    Set<FrameImpl> childFrames = new LinkedHashSet<FrameImpl>();
    private final Set<WaitUntilState> loadStates = new HashSet<WaitUntilState>();
    private final ListenerCollection<InternalEventType> internalListeners = new ListenerCollection();
    PageImpl page;
    boolean isDetached;

    FrameImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.name = initializer.get("name").getAsString();
        this.url = initializer.get("url").getAsString();
        if (initializer.has("parentFrame")) {
            this.parentFrame = (FrameImpl)this.connection.getExistingObject(initializer.getAsJsonObject("parentFrame").get("guid").getAsString());
            this.parentFrame.childFrames.add(this);
        }
        for (JsonElement item : initializer.get("loadStates").getAsJsonArray()) {
            this.loadStates.add(FrameImpl.loadStateFromProtocol(item.getAsString()));
        }
    }

    private static WaitUntilState loadStateFromProtocol(String value) {
        switch (value) {
            case "load": {
                return WaitUntilState.LOAD;
            }
            case "domcontentloaded": {
                return WaitUntilState.DOMCONTENTLOADED;
            }
            case "networkidle": {
                return WaitUntilState.NETWORKIDLE;
            }
            case "commit": {
                return WaitUntilState.COMMIT;
            }
        }
        throw new PlaywrightException("Unexpected value: " + value);
    }

    @Override
    public ElementHandle querySelector(String selector, Frame.QuerySelectorOptions options) {
        if (options == null) {
            options = new Frame.QuerySelectorOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonElement json = this.sendMessage("querySelector", params, NO_TIMEOUT);
        JsonObject element = json.getAsJsonObject().getAsJsonObject("element");
        if (element == null) {
            return null;
        }
        return (ElementHandle)this.connection.getExistingObject(element.get("guid").getAsString());
    }

    @Override
    public List<ElementHandle> querySelectorAll(String selector) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        JsonElement json = this.sendMessage("querySelectorAll", params, NO_TIMEOUT);
        JsonArray elements = json.getAsJsonObject().getAsJsonArray("elements");
        if (elements == null) {
            return null;
        }
        ArrayList<ElementHandle> handles = new ArrayList<ElementHandle>();
        for (JsonElement item : elements) {
            handles.add((ElementHandle)this.connection.getExistingObject(item.getAsJsonObject().get("guid").getAsString()));
        }
        return handles;
    }

    @Override
    public List<String> selectOption(String selector, String value, Frame.SelectOptionOptions options) {
        String[] stringArray;
        if (value == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        String[] values = stringArray;
        return this.selectOption(selector, values, options);
    }

    @Override
    public List<String> selectOption(String selector, ElementHandle value, Frame.SelectOptionOptions options) {
        ElementHandle[] elementHandleArray;
        if (value == null) {
            elementHandleArray = null;
        } else {
            ElementHandle[] elementHandleArray2 = new ElementHandle[1];
            elementHandleArray = elementHandleArray2;
            elementHandleArray2[0] = value;
        }
        ElementHandle[] values = elementHandleArray;
        return this.selectOption(selector, values, options);
    }

    @Override
    public List<String> selectOption(String selector, String[] values, Frame.SelectOptionOptions options) {
        return this.selectOptionImpl(selector, values, options);
    }

    @Override
    public List<String> selectOption(String selector, SelectOption value, Frame.SelectOptionOptions options) {
        SelectOption[] selectOptionArray;
        if (value == null) {
            selectOptionArray = null;
        } else {
            SelectOption[] selectOptionArray2 = new SelectOption[1];
            selectOptionArray = selectOptionArray2;
            selectOptionArray2[0] = value;
        }
        SelectOption[] values = selectOptionArray;
        return this.selectOption(selector, values, options);
    }

    @Override
    public Object evalOnSelector(String selector, String pageFunction, Object arg, Frame.EvalOnSelectorOptions options) {
        return this.evalOnSelectorImpl(selector, pageFunction, arg, options);
    }

    Object evalOnSelectorImpl(String selector, String pageFunction, Object arg, Frame.EvalOnSelectorOptions options) {
        if (options == null) {
            options = new Frame.EvalOnSelectorOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.addProperty("expression", pageFunction);
        params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
        JsonElement json = this.sendMessage("evalOnSelector", params, NO_TIMEOUT);
        SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
        return Serialization.deserialize(value);
    }

    @Override
    public Object evalOnSelectorAll(String selector, String pageFunction, Object arg) {
        return this.evalOnSelectorAllImpl(selector, pageFunction, arg);
    }

    Object evalOnSelectorAllImpl(String selector, String pageFunction, Object arg) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        params.addProperty("expression", pageFunction);
        params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
        JsonElement json = this.sendMessage("evalOnSelectorAll", params, NO_TIMEOUT);
        SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
        return Serialization.deserialize(value);
    }

    @Override
    public ElementHandle addScriptTag(Frame.AddScriptTagOptions options) {
        return this.addScriptTagImpl(options);
    }

    ElementHandle addScriptTagImpl(Frame.AddScriptTagOptions options) {
        if (options == null) {
            options = new Frame.AddScriptTagOptions();
        }
        JsonObject jsonOptions = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (options.path != null) {
            byte[] encoded;
            jsonOptions.remove("path");
            try {
                encoded = Files.readAllBytes(options.path);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read from file", e);
            }
            String content = new String(encoded, StandardCharsets.UTF_8);
            content = Utils.addSourceUrlToScript(content, options.path);
            jsonOptions.addProperty("content", content);
        }
        JsonElement json = this.sendMessage("addScriptTag", jsonOptions, NO_TIMEOUT);
        return (ElementHandle)this.connection.getExistingObject(json.getAsJsonObject().getAsJsonObject("element").get("guid").getAsString());
    }

    @Override
    public ElementHandle addStyleTag(Frame.AddStyleTagOptions options) {
        return this.addStyleTagImpl(options);
    }

    ElementHandle addStyleTagImpl(Frame.AddStyleTagOptions options) {
        if (options == null) {
            options = new Frame.AddStyleTagOptions();
        }
        JsonObject jsonOptions = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (options.path != null) {
            byte[] encoded;
            jsonOptions.remove("path");
            try {
                encoded = Files.readAllBytes(options.path);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read from file", e);
            }
            String content = new String(encoded, StandardCharsets.UTF_8);
            content = content + "/*# sourceURL=" + options.path.toString().replace("\n", "") + "*/";
            jsonOptions.addProperty("content", content);
        }
        JsonElement json = this.sendMessage("addStyleTag", jsonOptions, NO_TIMEOUT);
        return (ElementHandle)this.connection.getExistingObject(json.getAsJsonObject().getAsJsonObject("element").get("guid").getAsString());
    }

    @Override
    public void check(String selector, Frame.CheckOptions options) {
        if (options == null) {
            options = new Frame.CheckOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("check", params, this.timeout(options.timeout));
    }

    @Override
    public List<Frame> childFrames() {
        return new ArrayList<Frame>(this.childFrames);
    }

    @Override
    public void click(String selector, Frame.ClickOptions options) {
        this.clickImpl(selector, options);
    }

    void clickImpl(String selector, Frame.ClickOptions options) {
        if (options == null) {
            options = new Frame.ClickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("click", params, this.timeout(options.timeout));
    }

    @Override
    public String content() {
        return this.sendMessage("content").getAsJsonObject().get("value").getAsString();
    }

    @Override
    public void dblclick(String selector, Frame.DblclickOptions options) {
        if (options == null) {
            options = new Frame.DblclickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("dblclick", params, this.timeout(options.timeout));
    }

    @Override
    public void dispatchEvent(String selector, String type, Object eventInit, Frame.DispatchEventOptions options) {
        if (options == null) {
            options = new Frame.DispatchEventOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.addProperty("type", type);
        params.add("eventInit", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(eventInit)));
        this.sendMessage("dispatchEvent", params, this.timeout(options.timeout));
    }

    @Override
    public Object evaluate(String expression, Object arg) {
        JsonObject params = new JsonObject();
        params.addProperty("expression", expression);
        params.addProperty("world", "main");
        params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
        JsonElement json = this.sendMessage("evaluateExpression", params, NO_TIMEOUT);
        SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
        return Serialization.deserialize(value);
    }

    @Override
    public JSHandle evaluateHandle(String pageFunction, Object arg) {
        JsonObject params = new JsonObject();
        params.addProperty("expression", pageFunction);
        params.addProperty("world", "main");
        params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
        JsonElement json = this.sendMessage("evaluateExpressionHandle", params, NO_TIMEOUT);
        return (JSHandle)this.connection.getExistingObject(json.getAsJsonObject().getAsJsonObject("handle").get("guid").getAsString());
    }

    @Override
    public void fill(String selector, String value, Frame.FillOptions options) {
        if (options == null) {
            options = new Frame.FillOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.addProperty("value", value);
        this.sendMessage("fill", params, this.timeout(options.timeout));
    }

    @Override
    public void focus(String selector, Frame.FocusOptions options) {
        if (options == null) {
            options = new Frame.FocusOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("focus", params, this.timeout(options.timeout));
    }

    @Override
    public ElementHandle frameElement() {
        JsonObject json = this.sendMessage("frameElement").getAsJsonObject();
        return (ElementHandle)this.connection.getExistingObject(json.getAsJsonObject("element").get("guid").getAsString());
    }

    @Override
    public FrameLocator frameLocator(String selector) {
        return new FrameLocatorImpl(this, selector);
    }

    @Override
    public String getAttribute(String selector, String name, Frame.GetAttributeOptions options) {
        return this.getAttributeImpl(selector, name, options);
    }

    @Override
    public Locator getByAltText(String text, Frame.GetByAltTextOptions options) {
        return this.locator(LocatorUtils.getByAltTextSelector(text, Utils.convertType(options, Locator.GetByAltTextOptions.class)));
    }

    @Override
    public Locator getByAltText(Pattern text, Frame.GetByAltTextOptions options) {
        return this.locator(LocatorUtils.getByAltTextSelector(text, Utils.convertType(options, Locator.GetByAltTextOptions.class)));
    }

    @Override
    public Locator getByLabel(String text, Frame.GetByLabelOptions options) {
        return this.locator(LocatorUtils.getByLabelSelector(text, Utils.convertType(options, Locator.GetByLabelOptions.class)));
    }

    @Override
    public Locator getByLabel(Pattern text, Frame.GetByLabelOptions options) {
        return this.locator(LocatorUtils.getByLabelSelector(text, Utils.convertType(options, Locator.GetByLabelOptions.class)));
    }

    @Override
    public Locator getByPlaceholder(String text, Frame.GetByPlaceholderOptions options) {
        return this.locator(LocatorUtils.getByPlaceholderSelector(text, Utils.convertType(options, Locator.GetByPlaceholderOptions.class)));
    }

    @Override
    public Locator getByPlaceholder(Pattern text, Frame.GetByPlaceholderOptions options) {
        return this.locator(LocatorUtils.getByPlaceholderSelector(text, Utils.convertType(options, Locator.GetByPlaceholderOptions.class)));
    }

    @Override
    public Locator getByRole(AriaRole role, Frame.GetByRoleOptions options) {
        return this.locator(LocatorUtils.getByRoleSelector(role, Utils.convertType(options, Locator.GetByRoleOptions.class)));
    }

    @Override
    public Locator getByTestId(String testId) {
        return this.locator(LocatorUtils.getByTestIdSelector(testId, this.connection.playwright));
    }

    @Override
    public Locator getByTestId(Pattern testId) {
        return this.locator(LocatorUtils.getByTestIdSelector(testId, this.connection.playwright));
    }

    @Override
    public Locator getByText(String text, Frame.GetByTextOptions options) {
        return this.locator(LocatorUtils.getByTextSelector(text, Utils.convertType(options, Locator.GetByTextOptions.class)));
    }

    @Override
    public Locator getByText(Pattern text, Frame.GetByTextOptions options) {
        return this.locator(LocatorUtils.getByTextSelector(text, Utils.convertType(options, Locator.GetByTextOptions.class)));
    }

    @Override
    public Locator getByTitle(String text, Frame.GetByTitleOptions options) {
        return this.locator(LocatorUtils.getByTitleSelector(text, Utils.convertType(options, Locator.GetByTitleOptions.class)));
    }

    @Override
    public Locator getByTitle(Pattern text, Frame.GetByTitleOptions options) {
        return this.locator(LocatorUtils.getByTitleSelector(text, Utils.convertType(options, Locator.GetByTitleOptions.class)));
    }

    String getAttributeImpl(String selector, String name, Frame.GetAttributeOptions options) {
        if (options == null) {
            options = new Frame.GetAttributeOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.addProperty("name", name);
        JsonObject json = this.sendMessage("getAttribute", params, this.timeout(options.timeout)).getAsJsonObject();
        if (json.has("value")) {
            return json.get("value").getAsString();
        }
        return null;
    }

    @Override
    public ResponseImpl navigate(String url, Frame.NavigateOptions options) {
        return this.navigateImpl(url, options);
    }

    ResponseImpl navigateImpl(String url, Frame.NavigateOptions options) {
        if (options == null) {
            options = new Frame.NavigateOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("url", url);
        JsonElement result = this.sendMessage("goto", params, this.navigationTimeout(options.timeout));
        JsonObject jsonResponse = result.getAsJsonObject().getAsJsonObject("response");
        if (jsonResponse == null) {
            return null;
        }
        return (ResponseImpl)this.connection.getExistingObject(jsonResponse.get("guid").getAsString());
    }

    @Override
    public void hover(String selector, Frame.HoverOptions options) {
        this.hoverImpl(selector, options);
    }

    void hoverImpl(String selector, Frame.HoverOptions options) {
        if (options == null) {
            options = new Frame.HoverOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("hover", params, this.timeout(options.timeout));
    }

    @Override
    public void dragAndDrop(String source, String target, Frame.DragAndDropOptions options) {
        this.dragAndDropImpl(source, target, options);
    }

    void dragAndDropImpl(String source, String target, Frame.DragAndDropOptions options) {
        if (options == null) {
            options = new Frame.DragAndDropOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("source", source);
        params.addProperty("target", target);
        this.sendMessage("dragAndDrop", params, this.timeout(options.timeout));
    }

    @Override
    public String innerHTML(String selector, Frame.InnerHTMLOptions options) {
        return this.innerHTMLImpl(selector, options);
    }

    String innerHTMLImpl(String selector, Frame.InnerHTMLOptions options) {
        if (options == null) {
            options = new Frame.InnerHTMLOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("innerHTML", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsString();
    }

    @Override
    public String innerText(String selector, Frame.InnerTextOptions options) {
        return this.innerTextImpl(selector, options);
    }

    String innerTextImpl(String selector, Frame.InnerTextOptions options) {
        if (options == null) {
            options = new Frame.InnerTextOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("innerText", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsString();
    }

    @Override
    public String inputValue(String selector, Frame.InputValueOptions options) {
        return this.inputValueImpl(selector, options);
    }

    String inputValueImpl(String selector, Frame.InputValueOptions options) {
        if (options == null) {
            options = new Frame.InputValueOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("inputValue", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsString();
    }

    @Override
    public boolean isChecked(String selector, Frame.IsCheckedOptions options) {
        return this.isCheckedImpl(selector, options);
    }

    boolean isCheckedImpl(String selector, Frame.IsCheckedOptions options) {
        if (options == null) {
            options = new Frame.IsCheckedOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("isChecked", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isDetached() {
        return this.isDetached;
    }

    @Override
    public boolean isDisabled(String selector, Frame.IsDisabledOptions options) {
        return this.isDisabledImpl(selector, options);
    }

    boolean isDisabledImpl(String selector, Frame.IsDisabledOptions options) {
        if (options == null) {
            options = new Frame.IsDisabledOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("isDisabled", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isEditable(String selector, Frame.IsEditableOptions options) {
        return this.isEditableImpl(selector, options);
    }

    boolean isEditableImpl(String selector, Frame.IsEditableOptions options) {
        if (options == null) {
            options = new Frame.IsEditableOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("isEditable", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isEnabled(String selector, Frame.IsEnabledOptions options) {
        return this.isEnabledImpl(selector, options);
    }

    boolean isEnabledImpl(String selector, Frame.IsEnabledOptions options) {
        if (options == null) {
            options = new Frame.IsEnabledOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("isEnabled", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isHidden(String selector, Frame.IsHiddenOptions options) {
        return this.isHiddenImpl(selector, options);
    }

    boolean isHiddenImpl(String selector, Frame.IsHiddenOptions options) {
        if (options == null) {
            options = new Frame.IsHiddenOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("isHidden", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isVisible(String selector, Frame.IsVisibleOptions options) {
        return this.isVisibleImpl(selector, options);
    }

    @Override
    public Locator locator(String selector, Frame.LocatorOptions options) {
        return new LocatorImpl(this, selector, Utils.convertType(options, Locator.LocatorOptions.class));
    }

    boolean isVisibleImpl(String selector, Frame.IsVisibleOptions options) {
        if (options == null) {
            options = new Frame.IsVisibleOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("isVisible", params, this.timeout(options.timeout)).getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public PageImpl page() {
        return this.page;
    }

    @Override
    public Frame parentFrame() {
        return this.parentFrame;
    }

    @Override
    public void press(String selector, String key, Frame.PressOptions options) {
        this.pressImpl(selector, key, options);
    }

    void pressImpl(String selector, String key, Frame.PressOptions options) {
        if (options == null) {
            options = new Frame.PressOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.addProperty("key", key);
        this.sendMessage("press", params, this.timeout(options.timeout));
    }

    @Override
    public List<String> selectOption(String selector, SelectOption[] values, Frame.SelectOptionOptions options) {
        return this.selectOptionImpl(selector, values, options);
    }

    List<String> selectOptionImpl(String selector, SelectOption[] values, Frame.SelectOptionOptions options) {
        if (options == null) {
            options = new Frame.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        if (values != null) {
            params.add("options", Serialization.gson().toJsonTree((Object)values));
        }
        return this.selectOption(params, options.timeout);
    }

    List<String> selectOptionImpl(String selector, String[] values, Frame.SelectOptionOptions options) {
        if (options == null) {
            options = new Frame.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        if (values != null) {
            params.add("options", (JsonElement)Serialization.toSelectValueOrLabel(values));
        }
        return this.selectOption(params, options.timeout);
    }

    @Override
    public List<String> selectOption(String selector, ElementHandle[] values, Frame.SelectOptionOptions options) {
        return this.selectOptionImpl(selector, values, options);
    }

    List<String> selectOptionImpl(String selector, ElementHandle[] values, Frame.SelectOptionOptions options) {
        if (options == null) {
            options = new Frame.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        if (values != null) {
            params.add("elements", (JsonElement)Serialization.toProtocol(values));
        }
        return this.selectOption(params, options.timeout);
    }

    private List<String> selectOption(JsonObject params, Double timeout) {
        JsonObject json = this.sendMessage("selectOption", params, this.timeout(timeout)).getAsJsonObject();
        return Serialization.parseStringList(json.getAsJsonArray("values"));
    }

    @Override
    public void setChecked(String selector, boolean checked, Frame.SetCheckedOptions options) {
        this.setCheckedImpl(selector, checked, options);
    }

    void setCheckedImpl(String selector, boolean checked, Frame.SetCheckedOptions options) {
        if (checked) {
            this.check(selector, Utils.convertType(options, Frame.CheckOptions.class));
        } else {
            this.uncheck(selector, Utils.convertType(options, Frame.UncheckOptions.class));
        }
    }

    @Override
    public void setContent(String html, Frame.SetContentOptions options) {
        if (options == null) {
            options = new Frame.SetContentOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("html", html);
        this.sendMessage("setContent", params, this.navigationTimeout(options.timeout));
    }

    @Override
    public void setInputFiles(String selector, Path files, Frame.SetInputFilesOptions options) {
        this.setInputFiles(selector, new Path[]{files}, options);
    }

    @Override
    public void setInputFiles(String selector, Path[] files, Frame.SetInputFilesOptions options) {
        this.setInputFilesImpl(selector, files, options);
    }

    void setInputFilesImpl(String selector, Path[] files, Frame.SetInputFilesOptions options) {
        if (options == null) {
            options = new Frame.SetInputFilesOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        Utils.addFilePathUploadParams(files, params, this.page.context());
        params.addProperty("selector", selector);
        this.sendMessage("setInputFiles", params, this.timeout(options.timeout));
    }

    @Override
    public void setInputFiles(String selector, FilePayload files, Frame.SetInputFilesOptions options) {
        this.setInputFiles(selector, new FilePayload[]{files}, options);
    }

    @Override
    public void setInputFiles(String selector, FilePayload[] files, Frame.SetInputFilesOptions options) {
        this.setInputFilesImpl(selector, files, options);
    }

    void setInputFilesImpl(String selector, FilePayload[] files, Frame.SetInputFilesOptions options) {
        Utils.checkFilePayloadSize(files);
        if (options == null) {
            options = new Frame.SetInputFilesOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.add("payloads", (JsonElement)Serialization.toJsonArray(files));
        this.sendMessage("setInputFiles", params, this.timeout(options.timeout));
    }

    @Override
    public void tap(String selector, Frame.TapOptions options) {
        if (options == null) {
            options = new Frame.TapOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("tap", params, this.timeout(options.timeout));
    }

    @Override
    public String textContent(String selector, Frame.TextContentOptions options) {
        if (options == null) {
            options = new Frame.TextContentOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        return this.sendMessage("textContent", params, this.timeout(options.timeout)).getAsJsonObject().get("value").getAsString();
    }

    @Override
    public String title() {
        JsonElement json = this.sendMessage("title");
        return json.getAsJsonObject().get("value").getAsString();
    }

    @Override
    public void type(String selector, String text, Frame.TypeOptions options) {
        if (options == null) {
            options = new Frame.TypeOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.addProperty("text", text);
        this.sendMessage("type", params, this.timeout(options.timeout));
    }

    @Override
    public void uncheck(String selector, Frame.UncheckOptions options) {
        if (options == null) {
            options = new Frame.UncheckOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("uncheck", params, this.timeout(options.timeout));
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public JSHandle waitForFunction(String pageFunction, Object arg, Frame.WaitForFunctionOptions options) {
        if (options == null) {
            options = new Frame.WaitForFunctionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("expression", pageFunction);
        params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
        JsonElement json = this.sendMessage("waitForFunction", params, this.timeout(options.timeout));
        JsonObject element = json.getAsJsonObject().getAsJsonObject("handle");
        return (JSHandle)this.connection.getExistingObject(element.get("guid").getAsString());
    }

    @Override
    public void waitForLoadState(LoadState state, Frame.WaitForLoadStateOptions options) {
        this.withWaitLogging("Frame.waitForLoadState", logger -> {
            this.waitForLoadStateImpl(state, options, (Logger)logger);
            return null;
        });
    }

    void waitForLoadStateImpl(LoadState state, Frame.WaitForLoadStateOptions options, Logger logger) {
        this.waitForLoadStateImpl(Utils.convertType(state, WaitUntilState.class), options, logger);
    }

    private void waitForLoadStateImpl(WaitUntilState state, Frame.WaitForLoadStateOptions options, Logger logger) {
        if (options == null) {
            options = new Frame.WaitForLoadStateOptions();
        }
        if (state == null) {
            state = WaitUntilState.LOAD;
        }
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitForLoadStateHelper(state, logger));
        waitables.add(this.page.createWaitForCloseHelper());
        waitables.add(this.page.createWaitableTimeout(options.timeout));
        this.runUntil(() -> {}, new WaitableRace(waitables));
    }

    @Override
    public Response waitForNavigation(Frame.WaitForNavigationOptions options, Runnable code) {
        return this.withWaitLogging("Frame.waitForNavigation", logger -> this.waitForNavigationImpl((Logger)logger, code, options, null));
    }

    Response waitForNavigationImpl(Logger logger, Runnable code, Frame.WaitForNavigationOptions options) {
        return this.waitForNavigationImpl(logger, code, options, null);
    }

    private Response waitForNavigationImpl(Logger logger, Runnable code, Frame.WaitForNavigationOptions options, UrlMatcher matcher) {
        if (options == null) {
            options = new Frame.WaitForNavigationOptions();
        }
        if (options.waitUntil == null) {
            options.waitUntil = WaitUntilState.LOAD;
        }
        ArrayList waitables = new ArrayList();
        if (matcher == null) {
            matcher = UrlMatcher.forOneOf(this.page.context().baseUrl(), options.url, this.connection.localUtils, false);
        }
        logger.log("waiting for navigation " + matcher);
        waitables.add(new WaitForNavigationHelper(matcher, options.waitUntil, logger));
        waitables.add(this.page.createWaitForCloseHelper());
        waitables.add(this.page.createWaitableFrameDetach(this));
        waitables.add(this.page.createWaitableNavigationTimeout(options.timeout));
        return (Response)this.runUntil(code, new WaitableRace(waitables));
    }

    @Override
    public ElementHandle waitForSelector(String selector, Frame.WaitForSelectorOptions options) {
        return this.waitForSelectorImpl(selector, options, false);
    }

    ElementHandle waitForSelectorImpl(String selector, Frame.WaitForSelectorOptions options, boolean omitReturnValue) {
        if (options == null) {
            options = new Frame.WaitForSelectorOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        params.addProperty("omitReturnValue", Boolean.valueOf(omitReturnValue));
        JsonElement json = this.sendMessage("waitForSelector", params, this.timeout(options.timeout));
        JsonObject element = json.getAsJsonObject().getAsJsonObject("element");
        if (element == null) {
            return null;
        }
        return (ElementHandle)this.connection.getExistingObject(element.get("guid").getAsString());
    }

    @Override
    public void waitForTimeout(double timeout) {
        JsonObject params = new JsonObject();
        this.sendMessage("waitForTimeout", params, timeout);
    }

    @Override
    public void waitForURL(String url, Frame.WaitForURLOptions options) {
        this.waitForURL(UrlMatcher.forGlob(this.page.context().baseUrl(), url, this.connection.localUtils, false), options);
    }

    @Override
    public void waitForURL(Pattern url, Frame.WaitForURLOptions options) {
        this.waitForURL(new UrlMatcher(url), options);
    }

    @Override
    public void waitForURL(Predicate<String> url, Frame.WaitForURLOptions options) {
        this.waitForURL(new UrlMatcher(url), options);
    }

    private void waitForURL(UrlMatcher matcher, Frame.WaitForURLOptions options) {
        this.withWaitLogging("Frame.waitForURL", logger -> {
            this.waitForURLImpl((Logger)logger, matcher, options);
            return null;
        });
    }

    void waitForURLImpl(Logger logger, UrlMatcher matcher, Frame.WaitForURLOptions options) {
        logger.log("waiting for url " + matcher);
        if (options == null) {
            options = new Frame.WaitForURLOptions();
        }
        if (matcher.test(this.url())) {
            this.waitForLoadStateImpl(options.waitUntil, Utils.convertType(options, Frame.WaitForLoadStateOptions.class), logger);
            return;
        }
        this.waitForNavigationImpl(logger, () -> {}, Utils.convertType(options, Frame.WaitForNavigationOptions.class), matcher);
    }

    int queryCount(String selector) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        JsonObject result = this.sendMessage("queryCount", params, NO_TIMEOUT).getAsJsonObject();
        return result.get("value").getAsInt();
    }

    void highlightImpl(String selector) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        this.sendMessage("highlight", params, NO_TIMEOUT);
    }

    @Override
    protected void handleEvent(String event, JsonObject params) {
        if ("loadstate".equals(event)) {
            JsonElement remove;
            JsonElement add = params.get("add");
            if (add != null) {
                WaitUntilState state = FrameImpl.loadStateFromProtocol(add.getAsString());
                this.loadStates.add(state);
                if (this.parentFrame == null && this.page != null) {
                    if (state == WaitUntilState.LOAD) {
                        this.page.listeners.notify(PageImpl.EventType.LOAD, this.page);
                    } else if (state == WaitUntilState.DOMCONTENTLOADED) {
                        this.page.listeners.notify(PageImpl.EventType.DOMCONTENTLOADED, this.page);
                    }
                }
                this.internalListeners.notify(InternalEventType.LOADSTATE, state);
            }
            if ((remove = params.get("remove")) != null) {
                this.loadStates.remove((Object)FrameImpl.loadStateFromProtocol(remove.getAsString()));
            }
        } else if ("navigated".equals(event)) {
            this.url = params.get("url").getAsString();
            this.name = params.get("name").getAsString();
            if (!params.has("error") && this.page != null) {
                this.page.frameNavigated(this);
            }
            this.internalListeners.notify(InternalEventType.NAVIGATED, params);
        }
    }

    protected double timeout(Double timeout) {
        if (this.page != null) {
            return this.page.timeoutSettings.timeout(timeout);
        }
        return new TimeoutSettings().timeout(timeout);
    }

    protected double navigationTimeout(Double timeout) {
        if (this.page != null) {
            return this.page.timeoutSettings.navigationTimeout(timeout);
        }
        return new TimeoutSettings().navigationTimeout(timeout);
    }

    private class WaitForNavigationHelper
    implements Waitable<Response>,
    Consumer<JsonObject> {
        private final UrlMatcher matcher;
        private final WaitUntilState expectedLoadState;
        private final Logger logger;
        private WaitForLoadStateHelper loadStateHelper;
        private RequestImpl request;
        private RuntimeException exception;

        WaitForNavigationHelper(UrlMatcher matcher, WaitUntilState expectedLoadState, Logger logger) {
            this.matcher = matcher;
            this.expectedLoadState = expectedLoadState;
            this.logger = logger;
            FrameImpl.this.internalListeners.add(InternalEventType.NAVIGATED, this);
        }

        @Override
        public void accept(JsonObject params) {
            String url = params.get("url").getAsString();
            this.logger.log("  navigated to " + url);
            if (!this.matcher.test(url)) {
                return;
            }
            if (params.has("error")) {
                this.exception = new PlaywrightException(params.get("error").getAsString());
            } else {
                JsonObject jsonReq;
                if (params.has("newDocument") && (jsonReq = params.getAsJsonObject("newDocument").getAsJsonObject("request")) != null) {
                    this.request = (RequestImpl)FrameImpl.this.connection.getExistingObject(jsonReq.get("guid").getAsString());
                }
                this.loadStateHelper = new WaitForLoadStateHelper(this.expectedLoadState, this.logger);
            }
            FrameImpl.this.internalListeners.remove(InternalEventType.NAVIGATED, this);
        }

        @Override
        public void dispose() {
            FrameImpl.this.internalListeners.remove(InternalEventType.NAVIGATED, this);
            if (this.loadStateHelper != null) {
                this.loadStateHelper.dispose();
            }
        }

        @Override
        public boolean isDone() {
            if (this.exception != null) {
                return true;
            }
            if (this.loadStateHelper != null) {
                return this.loadStateHelper.isDone();
            }
            return false;
        }

        @Override
        public Response get() {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.request == null) {
                return null;
            }
            return this.request.finalRequest().response();
        }
    }

    private class WaitForLoadStateHelper
    implements Waitable<Void>,
    Consumer<WaitUntilState> {
        private final WaitUntilState expectedState;
        private final Logger logger;
        private boolean isDone;

        WaitForLoadStateHelper(WaitUntilState state, Logger logger) {
            this.expectedState = state;
            this.logger = logger;
            this.isDone = FrameImpl.this.loadStates.contains((Object)state);
            if (!this.isDone) {
                FrameImpl.this.internalListeners.add(InternalEventType.LOADSTATE, this);
            }
        }

        @Override
        public void accept(WaitUntilState state) {
            this.logger.log("  load state changed to " + (Object)((Object)state));
            if (this.expectedState.equals((Object)state)) {
                this.isDone = true;
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            FrameImpl.this.internalListeners.remove(InternalEventType.LOADSTATE, this);
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public Void get() {
            return null;
        }
    }

    static enum InternalEventType {
        NAVIGATED,
        LOADSTATE;

    }
}

