/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.Locator;
import com.microsoft.playwright.assertions.LocatorAssertions;
import com.microsoft.playwright.impl.AssertionsBase;
import com.microsoft.playwright.impl.ExpectedTextValue;
import com.microsoft.playwright.impl.FrameExpectOptions;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.AriaRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class LocatorAssertionsImpl
extends AssertionsBase
implements LocatorAssertions {
    public LocatorAssertionsImpl(Locator locator) {
        this(locator, false);
    }

    private LocatorAssertionsImpl(Locator locator, boolean isNot) {
        super((LocatorImpl)locator, isNot);
    }

    @Override
    public void containsClass(String classname, LocatorAssertions.ContainsClassOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = classname;
        this.expectImpl("to.contain.class", expected, (Object)classname, "Locator expected to contain class", Utils.convertType(options, FrameExpectOptions.class), "Assert \"containsClass\"");
    }

    @Override
    public void containsClass(List<String> classnames, LocatorAssertions.ContainsClassOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : classnames) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            list.add(expected);
        }
        this.expectImpl("to.contain.class.array", list, classnames, "Locator expected to contain classes", Utils.convertType(options, FrameExpectOptions.class), "Assert \"containsClass\"");
    }

    @Override
    public void containsText(String text, LocatorAssertions.ContainsTextOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = true;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)text, "Locator expected to contain text", Utils.convertType(options, FrameExpectOptions.class), "Assert \"containsText\"");
    }

    @Override
    public void containsText(Pattern pattern, LocatorAssertions.ContainsTextOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = true;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)pattern, "Locator expected to contain regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"containsText\"");
    }

    @Override
    public void containsText(String[] strings, LocatorAssertions.ContainsTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : strings) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = true;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.contain.text.array", list, (Object)strings, "Locator expected to contain text", Utils.convertType(options, FrameExpectOptions.class), "Assert \"containsText\"");
    }

    @Override
    public void containsText(Pattern[] patterns, LocatorAssertions.ContainsTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = true;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.contain.text.array", list, (Object)patterns, "Locator expected to contain text", Utils.convertType(options, FrameExpectOptions.class), "Assert \"containsText\"");
    }

    @Override
    public void hasAccessibleDescription(String description, LocatorAssertions.HasAccessibleDescriptionOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = description;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.accessible.description", expected, (Object)description, "Locator expected to have accessible description", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasAccessibleDescription\"");
    }

    @Override
    public void hasAccessibleDescription(Pattern pattern, LocatorAssertions.HasAccessibleDescriptionOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.accessible.description", expected, (Object)pattern, "Locator expected to have accessible description", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasAccessibleDescription\"");
    }

    @Override
    public void hasAccessibleErrorMessage(String errorMessage, LocatorAssertions.HasAccessibleErrorMessageOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = errorMessage;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.accessible.error.message", expected, (Object)errorMessage, "Locator expected to have accessible error message", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasAccessibleErrorMessage\"");
    }

    @Override
    public void hasAccessibleErrorMessage(Pattern pattern, LocatorAssertions.HasAccessibleErrorMessageOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.accessible.error.message", expected, (Object)pattern, "Locator expected to have accessible error message", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasAccessibleErrorMessage\"");
    }

    @Override
    public void hasAccessibleName(String name, LocatorAssertions.HasAccessibleNameOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = name;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.accessible.name", expected, (Object)name, "Locator expected to have accessible name", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasAccessibleName\"");
    }

    @Override
    public void hasAccessibleName(Pattern pattern, LocatorAssertions.HasAccessibleNameOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.accessible.name", expected, (Object)pattern, "Locator expected to have accessible name", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasAccessibleName\"");
    }

    @Override
    public void hasAttribute(String name, String text, LocatorAssertions.HasAttributeOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        this.hasAttribute(name, expected, text, options);
    }

    @Override
    public void hasAttribute(String name, Pattern pattern, LocatorAssertions.HasAttributeOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        this.hasAttribute(name, expected, pattern, options);
    }

    private void hasAttribute(String name, ExpectedTextValue expectedText, Object expectedValue, LocatorAssertions.HasAttributeOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasAttributeOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expressionArg = name;
        String message = "Locator expected to have attribute '" + name + "'";
        if (expectedValue instanceof Pattern) {
            message = message + " matching regex";
        }
        this.expectImpl("to.have.attribute.value", expectedText, expectedValue, message, commonOptions, "Assert \"hasAttribute\"");
    }

    @Override
    public void hasClass(String text, LocatorAssertions.HasClassOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        this.expectImpl("to.have.class", expected, (Object)text, "Locator expected to have class", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasClass\"");
    }

    @Override
    public void hasClass(Pattern pattern, LocatorAssertions.HasClassOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.class", expected, (Object)pattern, "Locator expected to have class matching regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasClass\"");
    }

    @Override
    public void hasClass(String[] strings, LocatorAssertions.HasClassOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : strings) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            list.add(expected);
        }
        this.expectImpl("to.have.class.array", list, (Object)strings, "Locator expected to have class", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasClass\"");
    }

    @Override
    public void hasClass(Pattern[] patterns, LocatorAssertions.HasClassOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            list.add(expected);
        }
        this.expectImpl("to.have.class.array", list, (Object)patterns, "Locator expected to have class matching regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasClass\"");
    }

    @Override
    public void hasCount(int count, LocatorAssertions.HasCountOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasCountOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expectedNumber = count;
        List<ExpectedTextValue> expectedText = null;
        this.expectImpl("to.have.count", expectedText, (Object)count, "Locator expected to have count", commonOptions, "Assert \"hasCount\"");
    }

    @Override
    public void hasCSS(String name, String value, LocatorAssertions.HasCSSOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = value;
        this.hasCSS(name, expected, value, options);
    }

    @Override
    public void hasCSS(String name, Pattern pattern, LocatorAssertions.HasCSSOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.hasCSS(name, expected, pattern, options);
    }

    private void hasCSS(String name, ExpectedTextValue expectedText, Object expectedValue, LocatorAssertions.HasCSSOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasCSSOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expressionArg = name;
        String message = "Locator expected to have CSS property '" + name + "'";
        if (expectedValue instanceof Pattern) {
            message = message + " matching regex";
        }
        this.expectImpl("to.have.css", expectedText, expectedValue, message, commonOptions, "Assert \"hasCSS\"");
    }

    @Override
    public void hasId(String id, LocatorAssertions.HasIdOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = id;
        this.expectImpl("to.have.id", expected, (Object)id, "Locator expected to have ID", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasId\"");
    }

    @Override
    public void hasId(Pattern pattern, LocatorAssertions.HasIdOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.id", expected, (Object)pattern, "Locator expected to have ID matching regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasId\"");
    }

    @Override
    public void hasJSProperty(String name, Object value, LocatorAssertions.HasJSPropertyOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasJSPropertyOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expressionArg = name;
        commonOptions.expectedValue = Serialization.serializeArgument(value);
        List<ExpectedTextValue> list = null;
        this.expectImpl("to.have.property", list, value, "Locator expected to have JavaScript property '" + name + "'", commonOptions, "Assert \"hasJSProperty\"");
    }

    @Override
    public void hasRole(AriaRole role, LocatorAssertions.HasRoleOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = role.toString().toLowerCase();
        this.expectImpl("to.have.role", expected, (Object)expected.string, "Locator expected to have role", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasRole\"");
    }

    @Override
    public void hasText(String text, LocatorAssertions.HasTextOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = false;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)text, "Locator expected to have text", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasText\"");
    }

    @Override
    public void hasText(Pattern pattern, LocatorAssertions.HasTextOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = true;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)pattern, "Locator expected to have text matching regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasText\"");
    }

    @Override
    public void hasText(String[] strings, LocatorAssertions.HasTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : strings) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = false;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.have.text.array", list, (Object)strings, "Locator expected to have text", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasText\"");
    }

    @Override
    public void hasText(Pattern[] patterns, LocatorAssertions.HasTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = true;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.have.text.array", list, (Object)patterns, "Locator expected to have text matching regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasText\"");
    }

    @Override
    public void hasValue(String value, LocatorAssertions.HasValueOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = value;
        this.expectImpl("to.have.value", expected, (Object)value, "Locator expected to have value", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasValue\"");
    }

    @Override
    public void hasValue(Pattern pattern, LocatorAssertions.HasValueOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.value", expected, (Object)pattern, "Locator expected to have value matching regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasValue\"");
    }

    @Override
    public void hasValues(String[] values, LocatorAssertions.HasValuesOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : values) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            list.add(expected);
        }
        this.expectImpl("to.have.values", list, (Object)values, "Locator expected to have values", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasValues\"");
    }

    @Override
    public void hasValues(Pattern[] patterns, LocatorAssertions.HasValuesOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            expected.matchSubstring = true;
            list.add(expected);
        }
        this.expectImpl("to.have.values", list, (Object)patterns, "Locator expected to have values matching regex", Utils.convertType(options, FrameExpectOptions.class), "Assert \"hasValues\"");
    }

    @Override
    public void matchesAriaSnapshot(String expected, LocatorAssertions.MatchesAriaSnapshotOptions snapshotOptions) {
        if (snapshotOptions == null) {
            snapshotOptions = new LocatorAssertions.MatchesAriaSnapshotOptions();
        }
        FrameExpectOptions options = Utils.convertType(snapshotOptions, FrameExpectOptions.class);
        options.expectedValue = Serialization.serializeArgument(expected);
        this.expectImpl("to.match.aria", options, expected, "Locator expected to match Aria snapshot", "Assert \"matchesAriaSnapshot\"");
    }

    @Override
    public void isChecked(LocatorAssertions.IsCheckedOptions options) {
        String expected;
        if (options == null) {
            options = new LocatorAssertions.IsCheckedOptions();
        }
        HashMap<String, Boolean> expectedValue = new HashMap<String, Boolean>();
        if (options.indeterminate != null) {
            expectedValue.put("indeterminate", options.indeterminate);
        }
        if (options.checked != null) {
            expectedValue.put("checked", options.checked);
        }
        if (options.indeterminate != null && options.indeterminate.booleanValue()) {
            expected = "indeterminate";
        } else {
            boolean unchecked = options.checked != null && options.checked == false;
            expected = unchecked ? "unchecked" : "checked";
        }
        String message = "Locator expected to be";
        FrameExpectOptions expectOptions = Utils.convertType(options, FrameExpectOptions.class);
        expectOptions.expectedValue = Serialization.serializeArgument(expectedValue);
        this.expectImpl("to.be.checked", expectOptions, expected, message, "Assert \"isChecked\"");
    }

    @Override
    public void isDisabled(LocatorAssertions.IsDisabledOptions options) {
        this.expectTrue("to.be.disabled", "Locator expected to be disabled", Utils.convertType(options, FrameExpectOptions.class), "Assert \"isDisabled\"");
    }

    @Override
    public void isEditable(LocatorAssertions.IsEditableOptions options) {
        FrameExpectOptions frameOptions = Utils.convertType(options, FrameExpectOptions.class);
        boolean editable = options == null || options.editable == null || options.editable == true;
        String message = "Locator expected to be " + (editable ? "editable" : "readonly");
        this.expectTrue(editable ? "to.be.editable" : "to.be.readonly", message, frameOptions, "Assert \"isEditable\"");
    }

    @Override
    public void isEmpty(LocatorAssertions.IsEmptyOptions options) {
        this.expectTrue("to.be.empty", "Locator expected to be empty", Utils.convertType(options, FrameExpectOptions.class), "Assert \"isEmpty\"");
    }

    @Override
    public void isEnabled(LocatorAssertions.IsEnabledOptions options) {
        FrameExpectOptions frameOptions = Utils.convertType(options, FrameExpectOptions.class);
        boolean enabled = options == null || options.enabled == null || options.enabled == true;
        String message = "Locator expected to be " + (enabled ? "enabled" : "disabled");
        this.expectTrue(enabled ? "to.be.enabled" : "to.be.disabled", message, frameOptions, "Assert \"isEnabled\"");
    }

    @Override
    public void isFocused(LocatorAssertions.IsFocusedOptions options) {
        this.expectTrue("to.be.focused", "Locator expected to be focused", Utils.convertType(options, FrameExpectOptions.class), "Assert \"isFocused\"");
    }

    @Override
    public void isHidden(LocatorAssertions.IsHiddenOptions options) {
        this.expectTrue("to.be.hidden", "Locator expected to be hidden", Utils.convertType(options, FrameExpectOptions.class), "Assert \"isHidden\"");
    }

    @Override
    public void isInViewport(LocatorAssertions.IsInViewportOptions options) {
        FrameExpectOptions expectOptions = Utils.convertType(options, FrameExpectOptions.class);
        if (options != null && options.ratio != null) {
            expectOptions.expectedNumber = options.ratio;
        }
        this.expectTrue("to.be.in.viewport", "Locator expected to be in viewport", expectOptions, "Assert \"isInViewport\"");
    }

    @Override
    public void isVisible(LocatorAssertions.IsVisibleOptions options) {
        FrameExpectOptions frameOptions = Utils.convertType(options, FrameExpectOptions.class);
        boolean visible = options == null || options.visible == null || options.visible == true;
        String message = "Locator expected to be " + (visible ? "visible" : "hidden");
        this.expectTrue(visible ? "to.be.visible" : "to.be.hidden", message, frameOptions, "Assert \"isVisible\"");
    }

    private void expectTrue(String expression, String message, FrameExpectOptions options, String title) {
        List<ExpectedTextValue> expectedText = null;
        this.expectImpl(expression, expectedText, null, message, options, title);
    }

    @Override
    public LocatorAssertions not() {
        return new LocatorAssertionsImpl((Locator)this.actualLocator, !this.isNot);
    }

    @Override
    public void isAttached(LocatorAssertions.IsAttachedOptions options) {
        FrameExpectOptions frameOptions = Utils.convertType(options, FrameExpectOptions.class);
        boolean attached = options == null || options.attached == null || options.attached == true;
        String message = "Locator expected to be " + (attached ? "attached" : "detached");
        this.expectTrue(attached ? "to.be.attached" : "to.be.detached", message, frameOptions, "Assert \"isAttached\"");
    }
}

