/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.example;

import com.yunzhanghu.example.config.Config;
import com.yunzhanghu.example.utils.BaseUtil;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.payment.PaymentClient;
import com.yunzhanghu.sdk.payment.domain.AccountInfo;
import com.yunzhanghu.sdk.payment.domain.BatchOrderInfo;
import com.yunzhanghu.sdk.payment.domain.BatchOrderResult;
import com.yunzhanghu.sdk.payment.domain.CancelBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CancelBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CancelOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CancelOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CheckUserAmountRequest;
import com.yunzhanghu.sdk.payment.domain.CheckUserAmountResponse;
import com.yunzhanghu.sdk.payment.domain.ConfirmBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.ConfirmBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateAlipayOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateAlipayOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateBankpayOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateBankpayOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateWxpayOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateWxpayOrderResponse;
import com.yunzhanghu.sdk.payment.domain.GetDealerVARechargeAccountRequest;
import com.yunzhanghu.sdk.payment.domain.GetDealerVARechargeAccountResponse;
import com.yunzhanghu.sdk.payment.domain.GetEleReceiptFileRequest;
import com.yunzhanghu.sdk.payment.domain.GetEleReceiptFileResponse;
import com.yunzhanghu.sdk.payment.domain.GetOrderLxlwRequest;
import com.yunzhanghu.sdk.payment.domain.GetOrderLxlwResponse;
import com.yunzhanghu.sdk.payment.domain.GetOrderRequest;
import com.yunzhanghu.sdk.payment.domain.GetOrderResponse;
import com.yunzhanghu.sdk.payment.domain.ListAccountRequest;
import com.yunzhanghu.sdk.payment.domain.ListAccountResponse;
import com.yunzhanghu.sdk.payment.domain.QueryBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.QueryBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.RetryOrderRequest;
import com.yunzhanghu.sdk.payment.domain.RetryOrderResponse;
import com.yunzhanghu.sdk.utils.JsonUtil;

public class Payment {
    private static YzhConfig config = Config.getYzhConfig();
    private static PaymentClient client = new PaymentClient(config);

    public static void main(String[] args) {
        Payment.createBankpayOrder();
        Payment.createAlipayOrder();
        Payment.createWxpayOrder();
        Payment.createBatchOrder();
        Payment.confirmBatchOrder();
        Payment.queryBatchOrder();
        Payment.cancelBatchOrder();
        Payment.getOrder();
        Payment.listAccount();
        Payment.getEleReceiptFile();
        Payment.cancelOrder();
        Payment.getDealerVARechargeAccount();
        Payment.retryOrder();
        Payment.checkUserAmount();
        Payment.getOrderLxlw();
    }

    private static void createBankpayOrder() {
        CreateBankpayOrderRequest request = new CreateBankpayOrderRequest();
        request.setOrderId("202009010016562012987");
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setRealName("\u5f20\u4e09");
        request.setCardNo("6228888888888888888");
        request.setPhoneNo("15688888888");
        request.setIdCard("11010519491231002X");
        request.setPay("100.00");
        request.setPayRemark("");
        request.setNotifyUrl("https://www.example.com");
        request.setProjectId("");
        request.setDealerPlatformName("\u4e92\u8054\u7f51\u5e73\u53f0\u540d\u79f0test");
        request.setDealerUserId("userId1234567890");
        request.setDealerUserNickname("usernickname");
        YzhResponse<CreateBankpayOrderResponse> response = null;
        try {
            response = client.createBankpayOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CreateBankpayOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createAlipayOrder() {
        CreateAlipayOrderRequest request = new CreateAlipayOrderRequest();
        request.setOrderId("20200901001656212987");
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setRealName("\u5f20\u4e09");
        request.setCardNo("188****8888");
        request.setIdCard("11010519491231002X");
        request.setPhoneNo("188****8888");
        request.setPay("1.00");
        request.setPayRemark("");
        request.setCheckName("Check");
        request.setNotifyUrl("https://www.example.com");
        request.setProjectId("");
        request.setDealerPlatformName("\u4e92\u8054\u7f51\u5e73\u53f0\u540d\u79f0test");
        request.setDealerUserId("userId1234567890");
        request.setDealerUserNickname("usernickname");
        YzhResponse<CreateAlipayOrderResponse> response = null;
        try {
            response = client.createAlipayOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CreateAlipayOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createWxpayOrder() {
        CreateWxpayOrderRequest request = new CreateWxpayOrderRequest();
        request.setOrderId("202009010016562012987");
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setRealName("\u5f20\u4e09");
        request.setIdCard("11010519491231002X");
        request.setOpenid("o4GgauInH_RCEdvrrNGrntXDuXXX");
        request.setPhoneNo("188****8888");
        request.setPay("1.00");
        request.setPayRemark("");
        request.setNotifyUrl("https://www.example.com");
        request.setWxAppId("");
        request.setWxpayMode("transfer");
        request.setProjectId("");
        request.setDealerPlatformName("\u4e92\u8054\u7f51\u5e73\u53f0\u540d\u79f0test");
        request.setDealerUserId("userId1234567890");
        request.setDealerUserNickname("usernickname");
        YzhResponse<CreateWxpayOrderResponse> response = null;
        try {
            response = client.createWxpayOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CreateWxpayOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createBatchOrder() {
        CreateBatchOrderRequest request = new CreateBatchOrderRequest();
        request.setBatchId("batch2032934858483");
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setChannel("\u5fae\u4fe1");
        request.setWxAppId("");
        request.setTotalPay("3.30");
        request.setTotalCount("2");
        request.setOrderList(Payment.getBatchOrderInfoList());
        YzhResponse<CreateBatchOrderResponse> response = null;
        try {
            response = client.createBatchOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CreateBatchOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\u8fd4\u56de\u6279\u6b21\u53f7\uff1a" + data.getBatchId());
                for (BatchOrderResult res : data.getResultList()) {
                    System.out.println("\u8ba2\u5355\u8be6\u60c5");
                    System.out.println(res);
                    System.out.println("-------------------");
                }
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage() + "-" + JsonUtil.toJson(response.getData()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void confirmBatchOrder() {
        ConfirmBatchOrderRequest request = new ConfirmBatchOrderRequest();
        request.setBatchId("batch2032934858483");
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setChannel("\u5fae\u4fe1");
        YzhResponse<ConfirmBatchOrderResponse> response = null;
        try {
            response = client.confirmBatchOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ConfirmBatchOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void queryBatchOrder() {
        QueryBatchOrderRequest request = new QueryBatchOrderRequest();
        request.setBatchId("batch2032934858483");
        request.setDealerId(config.getDealerId());
        YzhResponse<QueryBatchOrderResponse> response = null;
        try {
            response = client.queryBatchOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                QueryBatchOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cancelBatchOrder() {
        CancelBatchOrderRequest request = new CancelBatchOrderRequest();
        request.setBatchId("batch2032934858483");
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        YzhResponse<CancelBatchOrderResponse> response = null;
        try {
            response = client.cancelBatchOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CancelBatchOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getOrder() {
        GetOrderRequest request = new GetOrderRequest();
        request.setOrderId("202009010016562012987");
        request.setChannel("\u652f\u4ed8\u5b9d");
        request.setDataType("encryption");
        YzhResponse<GetOrderResponse> response = null;
        try {
            response = client.getOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listAccount() {
        ListAccountRequest request = new ListAccountRequest();
        request.setDealerId(config.getDealerId());
        YzhResponse<ListAccountResponse> response = null;
        try {
            response = client.listAccount(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ListAccountResponse data = response.getData();
                for (AccountInfo info : data.getDealerInfos()) {
                    System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + info);
                }
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getEleReceiptFile() {
        GetEleReceiptFileRequest request = new GetEleReceiptFileRequest();
        request.setOrderId("123412323123");
        request.setRef("ref123412323123");
        YzhResponse<GetEleReceiptFileResponse> response = null;
        try {
            response = client.getEleReceiptFile(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetEleReceiptFileResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void cancelOrder() {
        CancelOrderRequest request = new CancelOrderRequest();
        request.setDealerId(config.getDealerId());
        request.setOrderId("202009010016562012987");
        request.setRef("176826728298982");
        request.setChannel("\u94f6\u884c\u5361");
        YzhResponse<CancelOrderResponse> response = null;
        try {
            response = client.cancelOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CancelOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void retryOrder() {
        RetryOrderRequest request = new RetryOrderRequest();
        request.setDealerId(config.getDealerId());
        request.setOrderId("202009010016562012987");
        request.setRef("176826728298982");
        request.setChannel("bankpay");
        YzhResponse<RetryOrderResponse> response = null;
        try {
            response = client.retryOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            System.out.println(response);
            if (response.isSuccess()) {
                RetryOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getDealerVARechargeAccount() {
        GetDealerVARechargeAccountRequest request = new GetDealerVARechargeAccountRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        YzhResponse<GetDealerVARechargeAccountResponse> response = null;
        try {
            response = client.getDealerVARechargeAccount(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetDealerVARechargeAccountResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkUserAmount() {
        CheckUserAmountRequest request = new CheckUserAmountRequest();
        request.setBrokerId(config.getBrokerId());
        request.setRealName("\u5f20\u4e09");
        request.setIdCard("11010519491231002X");
        request.setAmount("10000.00");
        YzhResponse<CheckUserAmountResponse> response = null;
        try {
            response = client.CheckUserAmount(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CheckUserAmountResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BatchOrderInfo[] getBatchOrderInfoList() {
        BatchOrderInfo info1 = new BatchOrderInfo();
        info1.setOrderId("202009010016562012987");
        info1.setRealName("\u5f20\u4e09");
        info1.setIdCard("440524188001010014");
        info1.setOpenid("o4GgauInH_RCEdvrrNGrntXDuXXX1");
        info1.setPhoneNo("188****8888");
        info1.setProjectId("");
        info1.setPay("1.00");
        info1.setPayRemark("");
        info1.setNotifyUrl("https://www.example.com");
        info1.setDealerPlatformName("\u4e92\u8054\u7f51\u5e73\u53f0\u540d\u79f0test");
        info1.setDealerUserId("userId1234567890");
        info1.setDealerUserNickname("usernickname");
        BatchOrderInfo info2 = new BatchOrderInfo();
        info2.setOrderId("202009010016562012988");
        info2.setRealName("\u674e\u56db");
        info2.setIdCard("11010519491231002X");
        info2.setOpenid("o4GgauInH_RCEdvrrNGrntXDuXXX2");
        info2.setPhoneNo("188****8888");
        info2.setProjectId("");
        info2.setPay("2.30");
        info2.setPayRemark("");
        info2.setNotifyUrl("https://www.example.com");
        info2.setDealerPlatformName("\u4e92\u8054\u7f51\u5e73\u53f0\u540d\u79f0test");
        info2.setDealerUserId("userId1234567890");
        info2.setDealerUserNickname("usernickname");
        BatchOrderInfo[] infoArry = new BatchOrderInfo[]{info1, info2};
        return infoArry;
    }

    private static void getOrderLxlw() {
        GetOrderLxlwRequest request = new GetOrderLxlwRequest();
        request.setOrderId("180490818101749");
        request.setChannel("\u94f6\u884c\u5361");
        request.setDataType("");
        YzhResponse<GetOrderLxlwResponse> response = null;
        try {
            response = client.getOrderLxlw(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetOrderLxlwResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

