/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.calculatelabor;

import com.google.gson.reflect.TypeToken;
import com.yunzhanghu.sdk.YzhException;
import com.yunzhanghu.sdk.base.YzhClient;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.CalcTaxRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.CalcTaxResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationH5UrlRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationH5UrlResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationYearH5UrlRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationYearH5UrlResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.LaborCaculatorRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.LaborCaculatorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateLaborServiceClient
extends YzhClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculateLaborServiceClient.class);

    public CalculateLaborServiceClient(YzhConfig yzhConfig) {
        super(yzhConfig);
    }

    public YzhResponse<LaborCaculatorResponse> laborCaculator(YzhRequest<LaborCaculatorRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/tax/v1/labor-caculator", new TypeToken<YzhResponse<LaborCaculatorResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CalcTaxResponse> calcTax(YzhRequest<CalcTaxRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/calc-tax", new TypeToken<YzhResponse<CalcTaxResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CalculationYearH5UrlResponse> calculationYearH5Url(YzhRequest<CalculationYearH5UrlRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/labor/service/calculation/year/h5url", false, new TypeToken<YzhResponse<CalculationYearH5UrlResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CalculationH5UrlResponse> calculationH5Url(YzhRequest<CalculationH5UrlRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/labor/service/calculation/h5url", false, new TypeToken<YzhResponse<CalculationH5UrlResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }
}

