/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.invoice;

import com.google.gson.reflect.TypeToken;
import com.yunzhanghu.sdk.YzhException;
import com.yunzhanghu.sdk.base.YzhClient;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.invoice.domain.ApplyInvoiceRequest;
import com.yunzhanghu.sdk.invoice.domain.ApplyInvoiceResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceAmountRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceAmountResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceFileRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceFileResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceInformationRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceInformationResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatusRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatusResponse;
import com.yunzhanghu.sdk.invoice.domain.SendReminderEmailRequest;
import com.yunzhanghu.sdk.invoice.domain.SendReminderEmailResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceClient
extends YzhClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvoiceClient.class);

    public InvoiceClient(YzhConfig yzhConfig) {
        super(yzhConfig);
    }

    public YzhResponse<GetInvoiceStatResponse> getInvoiceStat(YzhRequest<GetInvoiceStatRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/payment/v1/invoice-stat", false, new TypeToken<YzhResponse<GetInvoiceStatResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetInvoiceAmountResponse> getInvoiceAmount(YzhRequest<GetInvoiceAmountRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/invoice/v2/invoice-amount", new TypeToken<YzhResponse<GetInvoiceAmountResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<ApplyInvoiceResponse> applyInvoice(YzhRequest<ApplyInvoiceRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/invoice/v2/apply", new TypeToken<YzhResponse<ApplyInvoiceResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetInvoiceStatusResponse> getInvoiceStatus(YzhRequest<GetInvoiceStatusRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/invoice/v2/invoice/invoice-status", new TypeToken<YzhResponse<GetInvoiceStatusResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetInvoiceInformationResponse> getInvoiceInformation(YzhRequest<GetInvoiceInformationRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/invoice/v2/invoice-face-information", new TypeToken<YzhResponse<GetInvoiceInformationResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetInvoiceFileResponse> getInvoiceFile(YzhRequest<GetInvoiceFileRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/invoice/v2/invoice/invoice-pdf", new TypeToken<YzhResponse<GetInvoiceFileResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<SendReminderEmailResponse> sendReminderEmail(YzhRequest<SendReminderEmailRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/invoice/v2/invoice/reminder/email", new TypeToken<YzhResponse<SendReminderEmailResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }
}

