/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.payment;

import com.google.gson.reflect.TypeToken;
import com.yunzhanghu.sdk.YzhException;
import com.yunzhanghu.sdk.base.YzhClient;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.payment.domain.CancelBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CancelBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CancelOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CancelOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CheckUserAmountRequest;
import com.yunzhanghu.sdk.payment.domain.CheckUserAmountResponse;
import com.yunzhanghu.sdk.payment.domain.ConfirmBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.ConfirmBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateAlipayOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateAlipayOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateBankpayOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateBankpayOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.CreateWxpayOrderRequest;
import com.yunzhanghu.sdk.payment.domain.CreateWxpayOrderResponse;
import com.yunzhanghu.sdk.payment.domain.GetDealerVARechargeAccountRequest;
import com.yunzhanghu.sdk.payment.domain.GetDealerVARechargeAccountResponse;
import com.yunzhanghu.sdk.payment.domain.GetEleReceiptFileRequest;
import com.yunzhanghu.sdk.payment.domain.GetEleReceiptFileResponse;
import com.yunzhanghu.sdk.payment.domain.GetOrderLxlwRequest;
import com.yunzhanghu.sdk.payment.domain.GetOrderLxlwResponse;
import com.yunzhanghu.sdk.payment.domain.GetOrderRequest;
import com.yunzhanghu.sdk.payment.domain.GetOrderResponse;
import com.yunzhanghu.sdk.payment.domain.ListAccountRequest;
import com.yunzhanghu.sdk.payment.domain.ListAccountResponse;
import com.yunzhanghu.sdk.payment.domain.QueryBatchOrderRequest;
import com.yunzhanghu.sdk.payment.domain.QueryBatchOrderResponse;
import com.yunzhanghu.sdk.payment.domain.RetryOrderRequest;
import com.yunzhanghu.sdk.payment.domain.RetryOrderResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentClient
extends YzhClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentClient.class);

    public PaymentClient(YzhConfig yzhConfig) {
        super(yzhConfig);
    }

    public YzhResponse<CreateBankpayOrderResponse> createBankpayOrder(YzhRequest<CreateBankpayOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/order-bankpay", new TypeToken<YzhResponse<CreateBankpayOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CreateAlipayOrderResponse> createAlipayOrder(YzhRequest<CreateAlipayOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/order-alipay", new TypeToken<YzhResponse<CreateAlipayOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CreateWxpayOrderResponse> createWxpayOrder(YzhRequest<CreateWxpayOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/order-wxpay", new TypeToken<YzhResponse<CreateWxpayOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetOrderResponse> getOrder(YzhRequest<GetOrderRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/payment/v1/query-order", "encryption".equals(req.getRequest().getDataType()), new TypeToken<YzhResponse<GetOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetDealerVARechargeAccountResponse> getDealerVARechargeAccount(YzhRequest<GetDealerVARechargeAccountRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/payment/v1/va-account", false, new TypeToken<YzhResponse<GetDealerVARechargeAccountResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<ListAccountResponse> listAccount(YzhRequest<ListAccountRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/payment/v1/query-accounts", false, new TypeToken<YzhResponse<ListAccountResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetEleReceiptFileResponse> getEleReceiptFile(YzhRequest<GetEleReceiptFileRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/payment/v1/receipt/file", false, new TypeToken<YzhResponse<GetEleReceiptFileResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CancelOrderResponse> cancelOrder(YzhRequest<CancelOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/order/fail", new TypeToken<YzhResponse<CancelOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<RetryOrderResponse> retryOrder(YzhRequest<RetryOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/order/retry", new TypeToken<YzhResponse<RetryOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CreateBatchOrderResponse> createBatchOrder(YzhRequest<CreateBatchOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/order-batch", new TypeToken<YzhResponse<CreateBatchOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<ConfirmBatchOrderResponse> confirmBatchOrder(YzhRequest<ConfirmBatchOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/confirm-batch", new TypeToken<YzhResponse<ConfirmBatchOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<QueryBatchOrderResponse> queryBatchOrder(YzhRequest<QueryBatchOrderRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/payment/v1/query-batch", false, new TypeToken<YzhResponse<QueryBatchOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CancelBatchOrderResponse> cancelBatchOrder(YzhRequest<CancelBatchOrderRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/cancel-batch", new TypeToken<YzhResponse<CancelBatchOrderResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<CheckUserAmountResponse> CheckUserAmount(YzhRequest<CheckUserAmountRequest> req) throws YzhException {
        try {
            return this.post(req, "/api/payment/v1/risk-check/amount", new TypeToken<YzhResponse<CheckUserAmountResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    public YzhResponse<GetOrderLxlwResponse> getOrderLxlw(YzhRequest<GetOrderLxlwRequest> req) throws YzhException {
        try {
            return this.get(req, "/api/payment/v1/query-order", "encryption".equals(req.getRequest().getDataType()), new TypeToken<YzhResponse<GetOrderLxlwResponse>>(){});
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }
}

