/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.utils;

import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Sha256Util {
    public static String sign(String content, String key, Charset charset) {
        return Sha256Util.getSign(content, key, charset);
    }

    public static boolean verify(String content, String sign, String key, Charset charset) {
        String data = Sha256Util.getSign(content, key, charset);
        return sign.equals(data);
    }

    private static String getSign(String content, String key, Charset charset) {
        try {
            Mac sha256Hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(charset), "HmacSHA256");
            sha256Hmac.init(secretKey);
            return Sha256Util.byteArrayToHexString(sha256Hmac.doFinal(content.getBytes()));
        }
        catch (Exception e) {
            String errorMessage = "\u7b7e\u540d\u906d\u9047\u5f02\u5e38\uff0ccontent=" + content + " key=" + key + " reason=" + e.getMessage();
            throw new RuntimeException(errorMessage, e);
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }
}

