/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class OpenUtil {
    private OpenUtil() {
    }

    public static boolean isCodePointPrintable(int codePoint) {
        if (Character.isISOControl(codePoint)) {
            return false;
        }
        int category = Character.getType(codePoint);
        return category != 15 && category != 16 && category != 0 && category != 18 && category != 19;
    }

    public static boolean isSafeFontCodePointToPrint(int codePoint) {
        switch (codePoint) {
            case 173: 
            case 65532: {
                return false;
            }
        }
        return true;
    }

    public static boolean areAllCharactersPrintable(String str) {
        Objects.requireNonNull(str, "str");
        return str.codePoints().allMatch(OpenUtil::isSafeFontCodePointToPrint);
    }

    public static Integer parseIntegerOrNull(String possibleInteger) {
        try {
            return Integer.parseInt(possibleInteger);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int firstNonZero(int ... values) {
        for (int value : values) {
            if (value == 0) continue;
            return value;
        }
        return 0;
    }

    public static void closeQuietly(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void tryQuietly(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] readAll(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream result = new ByteArrayOutputStream(512);
        byte[] buf = new byte[10240];
        while ((i = is.read(buf)) != -1) {
            result.write(buf, 0, i);
        }
        return result.toByteArray();
    }

    public static String readAll(Reader reader) throws IOException {
        int numCharsRead;
        StringBuilder buffer = new StringBuilder(256);
        char[] arr = new char[10240];
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    public static String readString(InputStream is) throws IOException {
        byte[] bytes = OpenUtil.readAll(is);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String readString(Class<?> clazz, String resource) throws IOException {
        try (InputStream is = clazz.getResourceAsStream(resource);){
            String string = OpenUtil.readString(is);
            return string;
        }
    }

    public static <T, R> Function<T, R> rethrowingFunction(ThrowableFunction<T, R> func) {
        return arg -> {
            try {
                return func.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Consumer<T> rethrowingConsumer(ThrowableConsumer<T> consumer) {
        return arg -> {
            try {
                consumer.accept(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowableConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

