/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpauth;

import io.helidon.common.config.Config;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.util.TokenHandler;
import java.util.Objects;

public class HttpBasicOutboundConfig {
    public static final char[] EMPTY_PASSWORD = new char[0];
    public static final TokenHandler DEFAULT_TOKEN_HANDLER = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("Basic ").build();
    private final TokenHandler tokenHandler;
    private final boolean hasExplicitUser;
    private final String explicitUser;
    private final char[] explicitPassword;

    private HttpBasicOutboundConfig(Builder builder) {
        this.tokenHandler = builder.tokenHandler;
        this.hasExplicitUser = builder.hasExplicitUser;
        this.explicitUser = builder.explicitUser;
        this.explicitPassword = builder.explicitPassword == null ? EMPTY_PASSWORD : builder.explicitPassword.toCharArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpBasicOutboundConfig create() {
        return HttpBasicOutboundConfig.builder().build();
    }

    public static HttpBasicOutboundConfig create(Config config) {
        return HttpBasicOutboundConfig.builder().config(config).build();
    }

    public static HttpBasicOutboundConfig create(String user, String password) {
        return HttpBasicOutboundConfig.builder().explicitUser(user).explicitPassword(password).build();
    }

    public static HttpBasicOutboundConfig create(OutboundTarget outboundTarget) {
        return outboundTarget.customObject(HttpBasicOutboundConfig.class).map(HttpBasicOutboundConfig.class::cast).or(() -> outboundTarget.getConfig().map(HttpBasicOutboundConfig::create)).orElseGet(HttpBasicOutboundConfig::create);
    }

    TokenHandler tokenHandler() {
        return this.tokenHandler;
    }

    boolean hasExplicitUser() {
        return this.hasExplicitUser;
    }

    String explicitUser() {
        return this.explicitUser;
    }

    char[] explicitPassword() {
        return this.explicitPassword;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, HttpBasicOutboundConfig> {
        private TokenHandler tokenHandler = DEFAULT_TOKEN_HANDLER;
        private boolean hasExplicitUser = false;
        private String explicitUser;
        private String explicitPassword;

        private Builder() {
        }

        public HttpBasicOutboundConfig build() {
            if (this.explicitPassword != null && this.explicitUser == null) {
                throw new SecurityException("User must be configured if password is configured for HTTP Basic Authentication outbound");
            }
            return new HttpBasicOutboundConfig(this);
        }

        public Builder config(Config config) {
            config.get("outbound-token").map(TokenHandler::create).ifPresent(this::tokenHandler);
            config.get("username").asString().ifPresent(this::explicitUser);
            config.get("password").asString().ifPresent(this::explicitPassword);
            return this;
        }

        public Builder tokenHandler(TokenHandler tokenHandler) {
            this.tokenHandler = Objects.requireNonNull(tokenHandler);
            return this;
        }

        public Builder explicitUser(String explicitUser) {
            this.explicitUser = Objects.requireNonNull(explicitUser);
            this.hasExplicitUser = true;
            return this;
        }

        public Builder explicitPassword(String explicitPassword) {
            this.explicitPassword = explicitPassword;
            return this;
        }
    }
}

