/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.baggage.processor;

import io.opentelemetry.contrib.baggage.processor.BaggageSpanProcessor;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.List;

public class BaggageSpanProcessorCustomizer
implements AutoConfigurationCustomizerProvider {
    public void customize(AutoConfigurationCustomizer autoConfigurationCustomizer) {
        autoConfigurationCustomizer.addTracerProviderCustomizer((sdkTracerProviderBuilder, config) -> {
            BaggageSpanProcessorCustomizer.addSpanProcessor(sdkTracerProviderBuilder, config);
            return sdkTracerProviderBuilder;
        });
    }

    private static void addSpanProcessor(SdkTracerProviderBuilder sdkTracerProviderBuilder, ConfigProperties config) {
        List keys = config.getList("otel.java.experimental.span-attributes.copy-from-baggage.include");
        if (keys.isEmpty()) {
            return;
        }
        sdkTracerProviderBuilder.addSpanProcessor((SpanProcessor)BaggageSpanProcessorCustomizer.createProcessor(keys));
    }

    static BaggageSpanProcessor createProcessor(List<String> keys) {
        if (keys.size() == 1 && keys.get(0).equals("*")) {
            return BaggageSpanProcessor.allowAllBaggageKeys();
        }
        return new BaggageSpanProcessor(keys::contains);
    }
}

