/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Scannable;
import reactor.core.observability.micrometer.MicrometerMeterListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

final class MicrometerMeterListenerConfiguration {
    private static final Logger LOGGER = Loggers.getLogger(MicrometerMeterListenerConfiguration.class);
    final Tags commonTags;
    final boolean isMono;
    final String sequenceName;
    final MeterRegistry registry;

    static MicrometerMeterListenerConfiguration fromFlux(Flux<?> source, MeterRegistry meterRegistry) {
        Tags defaultTags = MicrometerMeterListener.DEFAULT_TAGS_FLUX;
        String name = MicrometerMeterListenerConfiguration.resolveName(source, LOGGER, "reactor");
        Tags tags = MicrometerMeterListenerConfiguration.resolveTags(source, defaultTags);
        return new MicrometerMeterListenerConfiguration(name, tags, meterRegistry, false);
    }

    static MicrometerMeterListenerConfiguration fromMono(Mono<?> source, MeterRegistry meterRegistry) {
        Tags defaultTags = MicrometerMeterListener.DEFAULT_TAGS_MONO;
        String name = MicrometerMeterListenerConfiguration.resolveName(source, LOGGER, "reactor");
        Tags tags = MicrometerMeterListenerConfiguration.resolveTags(source, defaultTags);
        return new MicrometerMeterListenerConfiguration(name, tags, meterRegistry, true);
    }

    static String resolveName(Publisher<?> source, Logger logger, String defaultName) {
        Scannable scannable = Scannable.from(source);
        if (!scannable.isScanAvailable()) {
            logger.warn("Attempting to activate metrics but the upstream is not Scannable. You might want to use `name()` (and optionally `tags()`) right before this listener");
            return defaultName;
        }
        String nameOrDefault = scannable.name();
        if (scannable.stepName().equals(nameOrDefault)) {
            return defaultName;
        }
        return nameOrDefault;
    }

    static Tags resolveTags(Publisher<?> source, Tags tags) {
        Scannable scannable = Scannable.from(source);
        if (scannable.isScanAvailable()) {
            List discoveredTags = scannable.tags().map(t -> Tag.of((String)((String)t.getT1()), (String)((String)t.getT2()))).collect(Collectors.toList());
            return tags.and(discoveredTags);
        }
        return tags;
    }

    MicrometerMeterListenerConfiguration(String sequenceName, Tags tags, MeterRegistry registryCandidate, boolean isMono) {
        this.commonTags = tags;
        this.isMono = isMono;
        this.sequenceName = sequenceName;
        this.registry = registryCandidate;
    }
}

