/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import org.reactivestreams.Publisher;
import reactor.core.observability.SignalListener;
import reactor.core.observability.SignalListenerFactory;
import reactor.core.observability.micrometer.MicrometerMeterListener;
import reactor.core.observability.micrometer.MicrometerMeterListenerConfiguration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

class MicrometerMeterListenerFactory<T>
implements SignalListenerFactory<T, MicrometerMeterListenerConfiguration> {
    final MeterRegistry registry;

    MicrometerMeterListenerFactory(MeterRegistry registry) {
        this.registry = registry;
    }

    public MicrometerMeterListenerConfiguration initializePublisherState(Publisher<? extends T> source) {
        if (source instanceof Mono) {
            return MicrometerMeterListenerConfiguration.fromMono((Mono)source, this.registry);
        }
        if (source instanceof Flux) {
            return MicrometerMeterListenerConfiguration.fromFlux((Flux)source, this.registry);
        }
        throw new IllegalArgumentException("MicrometerMeterListenerFactory must only be used via the tap operator / with a Flux or Mono");
    }

    public SignalListener<T> createListener(Publisher<? extends T> source, ContextView listenerContext, MicrometerMeterListenerConfiguration publisherContext) {
        return new MicrometerMeterListener(publisherContext);
    }
}

