/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Scannable;
import reactor.core.observability.micrometer.MicrometerMeterListenerConfiguration;
import reactor.core.observability.micrometer.MicrometerObservationListenerDocumentation;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

final class MicrometerObservationListenerConfiguration {
    static final KeyValues DEFAULT_KV_FLUX = KeyValues.of((String)MicrometerObservationListenerDocumentation.ObservationTags.TYPE.asString(), (String)"Flux");
    static final KeyValues DEFAULT_KV_MONO = KeyValues.of((String)MicrometerObservationListenerDocumentation.ObservationTags.TYPE.asString(), (String)"Mono");
    private static final Logger LOGGER = Loggers.getLogger(MicrometerObservationListenerConfiguration.class);
    final KeyValues commonKeyValues;
    final boolean isMono;
    final String sequenceName;
    final ObservationRegistry registry;

    static MicrometerObservationListenerConfiguration fromFlux(Flux<?> source, ObservationRegistry observationRegistry) {
        KeyValues defaultKeyValues = DEFAULT_KV_FLUX;
        String name = MicrometerMeterListenerConfiguration.resolveName(source, LOGGER, MicrometerObservationListenerDocumentation.ANONYMOUS.getName());
        KeyValues keyValues = MicrometerObservationListenerConfiguration.resolveKeyValues(source, defaultKeyValues);
        return new MicrometerObservationListenerConfiguration(name, keyValues, observationRegistry, false);
    }

    static MicrometerObservationListenerConfiguration fromMono(Mono<?> source, ObservationRegistry observationRegistry) {
        KeyValues defaultKeyValues = DEFAULT_KV_MONO;
        String name = MicrometerMeterListenerConfiguration.resolveName(source, LOGGER, MicrometerObservationListenerDocumentation.ANONYMOUS.getName());
        KeyValues keyValues = MicrometerObservationListenerConfiguration.resolveKeyValues(source, defaultKeyValues);
        return new MicrometerObservationListenerConfiguration(name, keyValues, observationRegistry, true);
    }

    static KeyValues resolveKeyValues(Publisher<?> source, KeyValues tags) {
        Scannable scannable = Scannable.from(source);
        if (scannable.isScanAvailable()) {
            List discoveredTags = scannable.tags().map(e -> KeyValue.of((String)((String)e.getT1()), (String)((String)e.getT2()))).collect(Collectors.toList());
            return tags.and(discoveredTags);
        }
        return tags;
    }

    MicrometerObservationListenerConfiguration(String sequenceName, KeyValues commonKeyValues, ObservationRegistry registryCandidate, boolean isMono) {
        this.commonKeyValues = commonKeyValues;
        this.isMono = isMono;
        this.sequenceName = sequenceName;
        this.registry = registryCandidate;
    }
}

