/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.observability.SignalListener;
import reactor.core.observability.SignalListenerFactory;
import reactor.core.observability.micrometer.MicrometerObservationListener;
import reactor.core.observability.micrometer.MicrometerObservationListenerConfiguration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

class MicrometerObservationListenerFactory<T>
implements SignalListenerFactory<T, MicrometerObservationListenerConfiguration> {
    final ObservationRegistry registry;
    @Nullable
    final Function<ObservationRegistry, Observation> observationSupplier;

    public MicrometerObservationListenerFactory(ObservationRegistry registry) {
        this(registry, null);
    }

    public MicrometerObservationListenerFactory(ObservationRegistry registry, @Nullable Function<ObservationRegistry, Observation> observationSupplier) {
        this.registry = registry;
        this.observationSupplier = observationSupplier;
    }

    public MicrometerObservationListenerConfiguration initializePublisherState(Publisher<? extends T> source) {
        if (source instanceof Mono) {
            return MicrometerObservationListenerConfiguration.fromMono((Mono)source, this.registry);
        }
        if (source instanceof Flux) {
            return MicrometerObservationListenerConfiguration.fromFlux((Flux)source, this.registry);
        }
        throw new IllegalArgumentException("MicrometerObservationListenerFactory must only be used via the tap operator / with a Flux or Mono");
    }

    public SignalListener<T> createListener(Publisher<? extends T> source, ContextView listenerContext, MicrometerObservationListenerConfiguration publisherContext) {
        return new MicrometerObservationListener(listenerContext, publisherContext, this.observationSupplier);
    }
}

