/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.observability.micrometer.TimedSchedulerMeterDocumentation;
import reactor.core.scheduler.Scheduler;
import reactor.util.annotation.Nullable;

final class TimedScheduler
implements Scheduler {
    final Scheduler delegate;
    final MeterRegistry registry;
    final Counter submittedDirect;
    final Counter submittedDelayed;
    final Counter submittedPeriodicInitial;
    final Counter submittedPeriodicIteration;
    final LongTaskTimer pendingTasks;
    final LongTaskTimer activeTasks;
    final Timer completedTasks;

    TimedScheduler(Scheduler delegate, MeterRegistry registry, String metricPrefix, Iterable<Tag> tagsList) {
        this.delegate = delegate;
        this.registry = registry;
        if (metricPrefix.endsWith(".")) {
            metricPrefix = metricPrefix.substring(0, metricPrefix.length() - 1);
        }
        Tags tags = Tags.of(tagsList);
        String submittedName = TimedSchedulerMeterDocumentation.TASKS_SUBMITTED.getName(new String[]{metricPrefix});
        this.submittedDirect = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "direct"));
        this.submittedDelayed = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "delayed"));
        this.submittedPeriodicInitial = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "periodic_initial"));
        this.submittedPeriodicIteration = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "periodic_iteration"));
        this.pendingTasks = LongTaskTimer.builder((String)TimedSchedulerMeterDocumentation.TASKS_PENDING.getName(new String[]{metricPrefix})).tags((Iterable)tags).register(registry);
        this.activeTasks = LongTaskTimer.builder((String)TimedSchedulerMeterDocumentation.TASKS_ACTIVE.getName(new String[]{metricPrefix})).tags((Iterable)tags).register(registry);
        this.completedTasks = registry.timer(TimedSchedulerMeterDocumentation.TASKS_COMPLETED.getName(new String[]{metricPrefix}), (Iterable)tags);
    }

    TimedRunnable wrap(Runnable task) {
        return new SchedulerBackedTimedRunnable(this.registry, this, this.delegate, task);
    }

    TimedRunnable wrapPeriodic(Runnable task) {
        return new SchedulerBackedTimedRunnable(this.registry, this, this.delegate, task, true);
    }

    public Disposable schedule(Runnable task) {
        TimedRunnable timedTask = this.wrap(task);
        return timedTask.schedule();
    }

    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        TimedRunnable timedTask = this.wrap(task);
        return timedTask.schedule(delay, unit);
    }

    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        TimedRunnable timedTask = this.wrapPeriodic(task);
        return timedTask.schedulePeriodically(initialDelay, period, unit);
    }

    public Scheduler.Worker createWorker() {
        return new TimedWorker(this, this.delegate.createWorker());
    }

    public boolean isDisposed() {
        return this.delegate.isDisposed();
    }

    public long now(TimeUnit unit) {
        return this.delegate.now(unit);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void start() {
        this.delegate.start();
    }

    public void init() {
        this.delegate.init();
    }

    static final class SchedulerBackedTimedRunnable
    extends TimedRunnable {
        final Scheduler scheduler;

        SchedulerBackedTimedRunnable(MeterRegistry registry, TimedScheduler timedScheduler, Scheduler scheduler, Runnable task) {
            super(registry, timedScheduler, task, null);
            this.scheduler = scheduler;
        }

        SchedulerBackedTimedRunnable(MeterRegistry registry, TimedScheduler timedScheduler, Scheduler scheduler, Runnable task, boolean periodic) {
            super(registry, timedScheduler, task, null, periodic);
            this.scheduler = scheduler;
        }

        @Override
        Disposable internalSchedule() {
            return this.scheduler.schedule((Runnable)this);
        }

        @Override
        Disposable internalSchedule(long delay, TimeUnit unit) {
            return this.scheduler.schedule((Runnable)this, delay, unit);
        }

        @Override
        Disposable internalSchedulePeriodically(long initialDelay, long period, TimeUnit unit) {
            return this.scheduler.schedulePeriodically((Runnable)this, initialDelay, period, unit);
        }
    }

    private static abstract class TimedRunnable
    implements Runnable,
    Disposable {
        static final Disposable.Composite DISPOSED = new EmptyCompositeDisposable();
        static final Disposable.Composite DONE = new EmptyCompositeDisposable();
        final MeterRegistry registry;
        final TimedScheduler timedScheduler;
        final Runnable task;
        final LongTaskTimer.Sample pendingSample;
        boolean isRerun;
        Disposable disposable;
        volatile Disposable.Composite parent;
        static final AtomicReferenceFieldUpdater<TimedRunnable, Disposable.Composite> PARENT = AtomicReferenceFieldUpdater.newUpdater(TimedRunnable.class, Disposable.Composite.class, "parent");

        TimedRunnable(MeterRegistry registry, TimedScheduler timedScheduler, Runnable task, @Nullable Disposable.Composite parent) {
            this(registry, timedScheduler, task, parent, false);
        }

        TimedRunnable(MeterRegistry registry, TimedScheduler timedScheduler, Runnable task, @Nullable Disposable.Composite parent, boolean periodic) {
            this.registry = registry;
            this.timedScheduler = timedScheduler;
            this.task = task;
            this.pendingSample = periodic ? null : timedScheduler.pendingTasks.start();
            this.isRerun = false;
            PARENT.lazySet(this, parent);
        }

        @Override
        public void run() {
            if (this.pendingSample != null) {
                this.pendingSample.stop();
            } else if (!this.isRerun) {
                this.isRerun = true;
            } else {
                this.timedScheduler.submittedPeriodicIteration.increment();
            }
            try {
                Runnable completionTrackingTask = this.timedScheduler.completedTasks.wrap(this.task);
                this.timedScheduler.activeTasks.record(completionTrackingTask);
            }
            finally {
                Disposable.Composite o = this.parent;
                if (o != DISPOSED && PARENT.compareAndSet(this, o, DONE) && o != null) {
                    o.remove((Disposable)this);
                }
            }
        }

        public Disposable schedule() {
            this.timedScheduler.submittedDirect.increment();
            try {
                this.disposable = this.internalSchedule();
                return this;
            }
            catch (RejectedExecutionException exception) {
                this.dispose();
                throw exception;
            }
        }

        public Disposable schedule(long delay, TimeUnit unit) {
            this.timedScheduler.submittedDelayed.increment();
            try {
                this.disposable = this.internalSchedule(delay, unit);
                return this;
            }
            catch (RejectedExecutionException exception) {
                this.dispose();
                throw exception;
            }
        }

        public Disposable schedulePeriodically(long initialDelay, long period, TimeUnit unit) {
            this.timedScheduler.submittedPeriodicInitial.increment();
            return this.internalSchedulePeriodically(initialDelay, period, unit);
        }

        public void dispose() {
            Disposable.Composite o;
            if (this.disposable != null) {
                this.disposable.dispose();
            }
            if (this.pendingSample != null) {
                this.pendingSample.stop();
            }
            do {
                if ((o = this.parent) != DONE && o != DISPOSED && o != null) continue;
                return;
            } while (!PARENT.compareAndSet(this, o, DISPOSED));
            o.remove((Disposable)this);
        }

        public boolean isDisposed() {
            Disposable.Composite o = PARENT.get(this);
            return o == DISPOSED || o == DONE;
        }

        abstract Disposable internalSchedule();

        abstract Disposable internalSchedule(long var1, TimeUnit var3);

        abstract Disposable internalSchedulePeriodically(long var1, long var3, TimeUnit var5);
    }

    static final class TimedWorker
    implements Scheduler.Worker {
        final TimedScheduler parent;
        final Scheduler.Worker delegate;
        final Disposable.Composite disposables;

        TimedWorker(TimedScheduler parent, Scheduler.Worker delegate) {
            this.parent = parent;
            this.delegate = delegate;
            this.disposables = Disposables.composite();
        }

        TimedRunnable wrap(Runnable task) {
            return new WorkerBackedTimedRunnable(this.parent.registry, this.parent, this.delegate, task, this.disposables);
        }

        TimedRunnable wrapPeriodic(Runnable task) {
            return new WorkerBackedTimedRunnable(this.parent.registry, this.parent, this.delegate, task, this.disposables, true);
        }

        public void dispose() {
            this.disposables.dispose();
            this.delegate.dispose();
        }

        public boolean isDisposed() {
            return this.delegate.isDisposed();
        }

        public Disposable schedule(Runnable task) {
            TimedRunnable timedTask = this.wrap(task);
            this.disposables.add((Disposable)timedTask);
            return timedTask.schedule();
        }

        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            TimedRunnable timedTask = this.wrap(task);
            this.disposables.add((Disposable)timedTask);
            return timedTask.schedule(delay, unit);
        }

        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            TimedRunnable timedTask = this.wrapPeriodic(task);
            this.disposables.add((Disposable)timedTask);
            return timedTask.schedulePeriodically(initialDelay, period, unit);
        }
    }

    static final class EmptyCompositeDisposable
    implements Disposable.Composite {
        EmptyCompositeDisposable() {
        }

        public boolean add(Disposable d) {
            return false;
        }

        public boolean addAll(Collection<? extends Disposable> ds) {
            return false;
        }

        public boolean remove(Disposable d) {
            return false;
        }

        public int size() {
            return 0;
        }

        public void dispose() {
        }

        public boolean isDisposed() {
            return false;
        }
    }

    static final class WorkerBackedTimedRunnable
    extends TimedRunnable {
        final Scheduler.Worker worker;

        WorkerBackedTimedRunnable(MeterRegistry registry, TimedScheduler timedScheduler, Scheduler.Worker worker, Runnable task, Disposable.Composite parent) {
            super(registry, timedScheduler, task, parent);
            this.worker = worker;
        }

        WorkerBackedTimedRunnable(MeterRegistry registry, TimedScheduler timedScheduler, Scheduler.Worker worker, Runnable task, Disposable.Composite parent, boolean periodic) {
            super(registry, timedScheduler, task, parent, periodic);
            this.worker = worker;
        }

        @Override
        Disposable internalSchedule() {
            return this.worker.schedule((Runnable)this);
        }

        @Override
        Disposable internalSchedule(long delay, TimeUnit unit) {
            return this.worker.schedule((Runnable)this, delay, unit);
        }

        @Override
        Disposable internalSchedulePeriodically(long initialDelay, long period, TimeUnit unit) {
            return this.worker.schedulePeriodically((Runnable)this, initialDelay, period, unit);
        }
    }
}

