/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.events.EventListener;
import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.server.HttpConnectionHandler;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerToConnectionBridge;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventPublisher;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventsListener;
import io.reactivex.netty.protocol.http.ws.server.Ws7To13UpgradeHandler;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import io.reactivex.netty.ssl.SslCodec;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subscriptions.CompositeSubscription;

public final class HttpServerImpl<I, O>
extends HttpServer<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerImpl.class);
    private final TcpServer<HttpServerRequest<I>, Object> server;
    private final HttpServerEventPublisher eventPublisher;
    private boolean sendHttp10ResponseFor10Request;

    private HttpServerImpl(TcpServer<HttpServerRequest<I>, Object> server, HttpServerEventPublisher eventPublisher) {
        this.server = server;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public <T> HttpServer<I, O> channelOption(ChannelOption<T> option, T value) {
        return HttpServerImpl._copy(this.server.channelOption(option, value), this.eventPublisher);
    }

    @Override
    public <T> HttpServer<I, O> clientChannelOption(ChannelOption<T> option, T value) {
        return HttpServerImpl._copy(this.server.clientChannelOption(option, value), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerFirst(String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerFirst(name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerFirst(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerFirst(group, name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerLast(String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerLast(name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerLast(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerLast(group, name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerBefore(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerBefore(baseName, name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerBefore(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerBefore(group, baseName, name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerAfter(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerAfter(baseName, name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> addChannelHandlerAfter(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.addChannelHandlerAfter(group, baseName, name, handlerFactory)), this.eventPublisher);
    }

    @Override
    public <II, OO> HttpServer<II, OO> pipelineConfigurator(Action1<ChannelPipeline> pipelineConfigurator) {
        return HttpServerImpl._copy(HttpServerImpl.castServer(this.server.pipelineConfigurator(pipelineConfigurator)), this.eventPublisher);
    }

    @Override
    public HttpServer<I, O> secure(Func1<ByteBufAllocator, SSLEngine> sslEngineFactory) {
        return HttpServerImpl._copy(this.server.secure(sslEngineFactory), this.eventPublisher);
    }

    @Override
    public HttpServer<I, O> secure(SSLEngine sslEngine) {
        return HttpServerImpl._copy(this.server.secure(sslEngine), this.eventPublisher);
    }

    @Override
    public HttpServer<I, O> secure(SslCodec sslCodec) {
        return HttpServerImpl._copy(this.server.secure(sslCodec), this.eventPublisher);
    }

    @Override
    public HttpServer<I, O> unsafeSecure() {
        return HttpServerImpl._copy(this.server.unsafeSecure(), this.eventPublisher);
    }

    @Override
    @Deprecated
    public HttpServer<I, O> enableWireLogging(LogLevel wireLoggingLevel) {
        return HttpServerImpl._copy(this.server.enableWireLogging(wireLoggingLevel), this.eventPublisher);
    }

    @Override
    public HttpServer<I, O> enableWireLogging(String name, LogLevel wireLoggingLevel) {
        return HttpServerImpl._copy(this.server.enableWireLogging(name, wireLoggingLevel), this.eventPublisher);
    }

    @Override
    public HttpServer<I, O> sendHttp10ResponseFor10Request(boolean sendHttp10ResponseFor10Request) {
        HttpServerImpl toReturn = HttpServerImpl._copy(this.server, this.eventPublisher);
        toReturn.sendHttp10ResponseFor10Request = sendHttp10ResponseFor10Request;
        return toReturn;
    }

    @Override
    public int getServerPort() {
        return this.server.getServerPort();
    }

    @Override
    public SocketAddress getServerAddress() {
        return this.server.getServerAddress();
    }

    @Override
    public HttpServer<I, O> start(RequestHandler<I, O> requestHandler) {
        this.server.start(new HttpConnectionHandler<I, O>(requestHandler, this.eventPublisher, this.sendHttp10ResponseFor10Request));
        return this;
    }

    @Override
    public void shutdown() {
        this.server.shutdown();
    }

    @Override
    public void awaitShutdown() {
        this.server.awaitShutdown();
    }

    @Override
    public void awaitShutdown(long duration, TimeUnit timeUnit) {
        this.server.awaitShutdown(duration, timeUnit);
    }

    static HttpServer<ByteBuf, ByteBuf> create(TcpServer<ByteBuf, ByteBuf> tcpServer) {
        final HttpServerEventPublisher eventPublisher = new HttpServerEventPublisher(tcpServer.getEventPublisher());
        return new HttpServerImpl<ByteBuf, ByteBuf>(tcpServer.pipelineConfigurator((Action1)new Action1<ChannelPipeline>(){

            public void call(ChannelPipeline pipeline) {
                pipeline.addLast(HttpHandlerNames.HttpServerEncoder.getName(), (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast(HttpHandlerNames.HttpServerDecoder.getName(), (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast(HttpHandlerNames.WsServerUpgradeHandler.getName(), (ChannelHandler)new Ws7To13UpgradeHandler());
                pipeline.addLast(new ChannelHandler[]{new HttpServerToConnectionBridge(eventPublisher)});
            }
        }), eventPublisher);
    }

    private static <II> TcpServer<HttpServerRequest<II>, Object> castServer(TcpServer<?, ?> rawTypes) {
        return rawTypes;
    }

    private static <II, OO> HttpServerImpl<II, OO> _copy(TcpServer<HttpServerRequest<II>, Object> newServer, HttpServerEventPublisher oldEventPublisher) {
        return new HttpServerImpl(newServer, oldEventPublisher.copy(newServer.getEventPublisher()));
    }

    public Subscription subscribe(HttpServerEventsListener listener) {
        CompositeSubscription cs = new CompositeSubscription();
        cs.add(this.server.subscribe((EventListener)listener));
        cs.add(this.eventPublisher.subscribe(listener));
        return cs;
    }
}

