/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws.server;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.MarkAwarePipeline;
import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.internal.AbstractHttpConnectionBridge;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.ws.WebSocketConnection;
import io.reactivex.netty.protocol.http.ws.internal.WsUtils;
import io.reactivex.netty.protocol.http.ws.server.V7to13Handshaker;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandler;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandshaker;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func0;

public final class Ws7To13UpgradeHandler
extends ChannelDuplexHandler {
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocket7To13UpgradeAcceptedEvent) {
            final WebSocket7To13UpgradeAcceptedEvent wsUpEvt = (WebSocket7To13UpgradeAcceptedEvent)evt;
            V7to13Handshaker.State state = wsUpEvt.state;
            Subscriber subscriber = wsUpEvt.acceptUpgradeSubscriber;
            String errorIfAny = Ws7To13UpgradeHandler.configureResponseForWs(state);
            if (null != errorIfAny) {
                subscriber.onError((Throwable)new IllegalStateException(errorIfAny));
                return;
            }
            final MarkAwarePipeline pipeline = state.getUpgradeResponse().unsafeConnection().getResettableChannelPipeline();
            final Connection<?, ?> wsConn = wsUpEvt.state.getUpgradeResponse().unsafeConnection();
            wsUpEvt.request.discardContent().onErrorResumeNext(Observable.empty()).concatWith(state.getUpgradeResponse().setTransferEncodingChunked().sendHeaders()).doOnCompleted(new Action0(){

                public void call() {
                    pipeline.remove(HttpHandlerNames.HttpServerEncoder.getName());
                    pipeline.remove(HttpHandlerNames.HttpServerDecoder.getName());
                    pipeline.channel().attr(AbstractHttpConnectionBridge.CONNECTION_UPGRADED).set((Object)true);
                }
            }).concatWith(Observable.defer((Func0)new Func0<Observable<Void>>(){

                public Observable<Void> call() {
                    return wsUpEvt.handler.handle(new WebSocketConnection((Connection<WebSocketFrame, WebSocketFrame>)wsConn));
                }
            })).concatWith(Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

                public void call(Subscriber<? super Void> sub) {
                    if (wsConn.unsafeNettyChannel().isOpen()) {
                        wsConn.write(Observable.just((Object)new CloseWebSocketFrame())).concatWith(wsConn.close()).unsafeSubscribe(sub);
                    }
                }
            })).unsafeSubscribe(subscriber);
        }
        ctx.fireUserEventTriggered(evt);
    }

    private static String configureResponseForWs(V7to13Handshaker.State state) {
        String acceptGuid;
        switch (state.getVersion()) {
            case V07: {
                acceptGuid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
                break;
            }
            case V08: {
                acceptGuid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
                break;
            }
            case V13: {
                acceptGuid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
                break;
            }
            default: {
                return "Unsupported web socket version: " + state.getVersion();
            }
        }
        WebSocket13FrameEncoder wsEncoder = new WebSocket13FrameEncoder(false);
        WebSocket13FrameDecoder wsDecoder = new WebSocket13FrameDecoder(true, state.isAllowExtensions(), state.getMaxFramePayloadLength(), true);
        HttpServerResponse<?> upgradeResponse = state.getUpgradeResponse();
        MarkAwarePipeline pipeline = upgradeResponse.unsafeConnection().getResettableChannelPipeline();
        ChannelHandlerContext httpDecoderCtx = pipeline.context(HttpHandlerNames.HttpServerDecoder.getName());
        if (null == httpDecoderCtx) {
            return "No HTTP decoder found, can not upgrade to WebSocket.";
        }
        ChannelHandlerContext httpEncoderCtx = pipeline.context(HttpHandlerNames.HttpServerEncoder.getName());
        if (null == httpEncoderCtx) {
            return "No HTTP encoder found, can not upgrade to WebSocket.";
        }
        pipeline.addAfter(httpDecoderCtx.name(), HttpHandlerNames.WsServerDecoder.getName(), (ChannelHandler)wsDecoder);
        pipeline.addBefore(httpEncoderCtx.name(), HttpHandlerNames.WsServerEncoder.getName(), (ChannelHandler)wsEncoder);
        Ws7To13UpgradeHandler.updateHandshakeHeaders(state, acceptGuid, upgradeResponse);
        return null;
    }

    private static void updateHandshakeHeaders(V7to13Handshaker.State state, String acceptGuid, HttpServerResponse<?> upgradeResponse) {
        String selectedSubprotocol;
        String acceptSeed = state.getSecWSkey() + acceptGuid;
        byte[] sha1 = WsUtils.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        String accept = WsUtils.base64(sha1);
        upgradeResponse.addHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, accept);
        upgradeResponse.setStatus(HttpResponseStatus.SWITCHING_PROTOCOLS);
        upgradeResponse.addHeader((CharSequence)HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET);
        upgradeResponse.addHeader((CharSequence)HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE);
        if (state.getRequestSubProtocols() != null && (selectedSubprotocol = WebSocketHandshaker.selectSubprotocol(state.getRequestSubProtocols(), state.getSupportedSubProtocols())) != null) {
            state.getUpgradeResponse().addHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, selectedSubprotocol);
        }
    }

    public static class WebSocket7To13UpgradeAcceptedEvent {
        private final Subscriber<? super Void> acceptUpgradeSubscriber;
        private final WebSocketHandler handler;
        private final V7to13Handshaker.State state;
        private final HttpServerRequest<?> request;

        WebSocket7To13UpgradeAcceptedEvent(Subscriber<? super Void> acceptUpgradeSubscriber, WebSocketHandler handler, V7to13Handshaker.State state, HttpServerRequest<?> request) {
            this.acceptUpgradeSubscriber = acceptUpgradeSubscriber;
            this.handler = handler;
            this.state = state;
            this.request = request;
        }
    }
}

