/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import io.reactivex.netty.spectator.http.internal.ResponseCodesHolder;
import io.reactivex.netty.spectator.internal.EventMetric;
import io.reactivex.netty.spectator.tcp.TcpClientListener;
import java.util.concurrent.TimeUnit;

public class HttpClientListener
extends HttpClientEventsListener {
    private final EventMetric requestWrite;
    private final EventMetric requestProcessing;
    private final EventMetric response;
    private final ResponseCodesHolder responseCodesHolder;
    private final TcpClientListener tcpDelegate;

    public HttpClientListener(Registry registry, String monitorId) {
        this.requestWrite = new EventMetric(registry, "request", monitorId, new String[]{"action", "write"});
        this.requestProcessing = new EventMetric(registry, "request", monitorId, new String[]{"action", "processing"});
        this.response = new EventMetric(registry, "response", monitorId, new String[]{"action", "read"});
        this.responseCodesHolder = new ResponseCodesHolder(registry, monitorId);
        this.tcpDelegate = new TcpClientListener(registry, monitorId);
    }

    public HttpClientListener(String monitorId) {
        this((Registry)Spectator.globalRegistry(), monitorId);
    }

    public void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        this.requestProcessing.success(duration, timeUnit);
    }

    public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
        this.responseCodesHolder.update(responseCode);
    }

    public void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
        this.response.success(duration, timeUnit);
    }

    public void onRequestWriteStart() {
        this.requestWrite.start();
    }

    public void onResponseFailed(Throwable throwable) {
        this.response.failure();
    }

    public void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        this.requestWrite.success(duration, timeUnit);
    }

    public void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.requestWrite.failure(duration, timeUnit);
    }

    public void onRequestSubmitted() {
        this.requestProcessing.start();
    }

    public void onByteRead(long bytesRead) {
        this.tcpDelegate.onByteRead(bytesRead);
    }

    public void onByteWritten(long bytesWritten) {
        this.tcpDelegate.onByteWritten(bytesWritten);
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onFlushComplete(duration, timeUnit);
    }

    public void onFlushStart() {
        this.tcpDelegate.onFlushStart();
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onWriteSuccess(duration, timeUnit);
    }

    public void onWriteStart() {
        this.tcpDelegate.onWriteStart();
    }

    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolReleaseFailed(duration, timeUnit, throwable);
    }

    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolReleaseSuccess(duration, timeUnit);
    }

    public void onPoolReleaseStart() {
        this.tcpDelegate.onPoolReleaseStart();
    }

    public void onPooledConnectionEviction() {
        this.tcpDelegate.onPooledConnectionEviction();
    }

    public void onPooledConnectionReuse() {
        this.tcpDelegate.onPooledConnectionReuse();
    }

    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolAcquireFailed(duration, timeUnit, throwable);
    }

    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolAcquireSuccess(duration, timeUnit);
    }

    public void onPoolAcquireStart() {
        this.tcpDelegate.onPoolAcquireStart();
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    public void onConnectionCloseStart() {
        this.tcpDelegate.onConnectionCloseStart();
    }

    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectFailed(duration, timeUnit, throwable);
    }

    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectSuccess(duration, timeUnit);
    }

    public void onConnectStart() {
        this.tcpDelegate.onConnectStart();
    }
}

