/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.operators;

import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;
import mutiny.zero.operators.ProcessorBase;

public class Recover<T>
implements Flow.Publisher<T> {
    private final Flow.Publisher<T> upstream;
    private final Function<Throwable, T> function;

    public Recover(Flow.Publisher<T> upstream, Function<Throwable, T> function) {
        this.upstream = Objects.requireNonNull(upstream, "The upstream cannot be null");
        this.function = Objects.requireNonNull(function, "The function cannot be null");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Processor processor = new Processor();
        processor.subscribe(subscriber);
        this.upstream.subscribe(processor);
    }

    private class Processor
    extends ProcessorBase<T, T> {
        private Processor() {
        }

        @Override
        public void onNext(T item) {
            if (!this.cancelled()) {
                this.downstream().onNext(item);
            }
        }

        @Override
        public void onError(Throwable err) {
            if (!this.cancelled()) {
                this.cancel();
                Flow.Subscriber downstream = this.downstream();
                try {
                    Object finalItem = Recover.this.function.apply(err);
                    if (finalItem == null) {
                        downstream.onComplete();
                    } else {
                        downstream.onNext(finalItem);
                        downstream.onComplete();
                    }
                }
                catch (Throwable functionErr) {
                    downstream.onError(functionErr);
                }
            }
        }
    }
}

