/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.codegen.MutinyGenerator;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeArgExpression;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public class CodeGenHelper {
    private CodeGenHelper() {
    }

    public static boolean hasParentClass(ClassModel model) {
        TypeInfo concreteSuperType = model.getConcreteSuperType();
        if (concreteSuperType == null) {
            return false;
        }
        if (concreteSuperType.isParameterized()) {
            return !MutinyGenerator.IGNORED_TYPES.contains(concreteSuperType.getRaw().getName());
        }
        return !MutinyGenerator.IGNORED_TYPES.contains(concreteSuperType.getName());
    }

    public static MethodKind methodKind(MethodInfo methodInfo) {
        TypeInfo lastParamType;
        List params = methodInfo.getParams();
        int lastParamIndex = params.size() - 1;
        if (lastParamIndex >= 0 && (lastParamType = ((ParamInfo)params.get(lastParamIndex)).getType()).getKind() == ClassKind.HANDLER) {
            TypeInfo typeArg = (TypeInfo)((ParameterizedTypeInfo)lastParamType).getArgs().get(0);
            if (typeArg.getKind() == ClassKind.ASYNC_RESULT) {
                return MethodKind.CALLBACK;
            }
            return MethodKind.HANDLER;
        }
        return MethodKind.OTHER;
    }

    public static String genTypeName(TypeInfo type) {
        return CodeGenHelper.genTypeName(type, false);
    }

    public static String genTranslatedTypeName(TypeInfo type) {
        return CodeGenHelper.genTypeName(type, true);
    }

    protected static boolean isImported(TypeInfo type) {
        switch (type.getKind()) {
            case JSON_OBJECT: 
            case JSON_ARRAY: 
            case ASYNC_RESULT: 
            case HANDLER: 
            case LIST: 
            case SET: 
            case BOXED_PRIMITIVE: 
            case STRING: 
            case VOID: 
            case FUNCTION: {
                return true;
            }
        }
        return false;
    }

    private static String expandInnerTypes(String type) {
        return type.replace('$', '.');
    }

    public static String genTypeName(TypeInfo type, boolean translate) {
        if (!translate && type.isParameterized() && type.getRaw().getName().equals(Uni.class.getName())) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            return CodeGenHelper.expandInnerTypes("io.vertx.core.Future<" + CodeGenHelper.genTypeName(parameterizedType.getArg(0), translate) + ">");
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo pt = (ParameterizedTypeInfo)type;
            if (translate && type.getRaw().getName().equals(Handler.class.getName()) && pt.getArg(0).getName().startsWith(Promise.class.getName())) {
                TypeInfo arg = ((ParameterizedTypeInfo)pt.getArg(0)).getArg(0);
                return CodeGenHelper.expandInnerTypes(Uni.class.getName() + "<" + CodeGenHelper.genTypeName(arg, true) + ">");
            }
            return CodeGenHelper.expandInnerTypes(CodeGenHelper.genTypeName((TypeInfo)pt.getRaw(), translate) + pt.getArgs().stream().map(a -> CodeGenHelper.genTypeName(a, translate)).collect(Collectors.joining(", ", "<", ">")));
        }
        if (type.getKind() == ClassKind.API && translate) {
            if (type.getName().equals(Future.class.getName())) {
                return CodeGenHelper.expandInnerTypes(Uni.class.getName());
            }
            return CodeGenHelper.expandInnerTypes(type.translateName("mutiny"));
        }
        if (translate && type.getName().equals(Future.class.getName())) {
            return CodeGenHelper.expandInnerTypes(Uni.class.getName());
        }
        if (CodeGenHelper.isImported(type)) {
            return CodeGenHelper.expandInnerTypes(type.getSimpleName());
        }
        return CodeGenHelper.expandInnerTypes(type.getName());
    }

    private static boolean isSameType(TypeInfo type, MethodInfo method) {
        ClassKind kind = type.getKind();
        if (type.isDataObjectHolder() || kind.basic || kind.json || kind == ClassKind.ENUM || kind == ClassKind.OTHER || kind == ClassKind.THROWABLE || kind == ClassKind.VOID) {
            return true;
        }
        if (kind == ClassKind.OBJECT) {
            if (type.isVariable()) {
                return !CodeGenHelper.isReified((TypeVariableInfo)type, method);
            }
            return true;
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.LIST || kind == ClassKind.SET || kind == ClassKind.ASYNC_RESULT) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.MAP) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
            if (kind == ClassKind.HANDLER) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.FUNCTION) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(0), method) && CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
        }
        return false;
    }

    public static String genConvParam(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, TypeInfo type, MethodInfo method, String expr) {
        ParameterizedTypeInfo parameterizedType;
        if (type.isParameterized() && type.getRaw().getName().equals(Multi.class.getName())) {
            ParameterizedTypeInfo parameterizedType2 = (ParameterizedTypeInfo)type;
            String adapterFunction = "obj -> " + CodeGenHelper.genConvParam(methodTypeArgMap, parameterizedType2.getArg(0), method, "obj");
            return "io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(" + expr + ", " + adapterFunction + ").resume()";
        }
        if (type.isParameterized() && type.getRaw().getName().equals(Future.class.getName())) {
            ParameterizedTypeInfo parameterizedType3 = (ParameterizedTypeInfo)type;
            TypeInfo arg = parameterizedType3.getArg(0);
            if (arg.getKind() == ClassKind.API) {
                return "io.smallrye.mutiny.vertx.UniHelper.toFuture(" + expr + ".map(r -> r.getDelegate()))";
            }
            return "io.smallrye.mutiny.vertx.UniHelper.toFuture(" + expr + ")";
        }
        if (type.isParameterized() && type.getRaw().getName().equals(Supplier.class.getName()) && (parameterizedType = (ParameterizedTypeInfo)type).getArg(0).getRaw().getName().equals(Future.class.getName())) {
            return "() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(" + expr + ".get())";
        }
        ClassKind kind = type.getKind();
        if (CodeGenHelper.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = CodeGenHelper.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return typeArg + ".<" + type.getName() + ">unwrap(" + expr + ")";
            }
            return expr;
        }
        if (kind == ClassKind.API) {
            return expr + ".getDelegate()";
        }
        if (kind == ClassKind.CLASS_TYPE) {
            return MutinyHelper.class.getName() + ".unwrap(" + expr + ")";
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo eventType = parameterizedTypeInfo.getArg(0);
                ClassKind eventKind = eventType.getKind();
                if (eventKind == ClassKind.ASYNC_RESULT) {
                    TypeInfo resultType = ((ParameterizedTypeInfo)eventType).getArg(0);
                    return "io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(" + expr + ", ar -> ar.map(event -> " + CodeGenHelper.genConvReturn(methodTypeArgMap, resultType, method, "event") + "))";
                }
                if (eventType.isParameterized() && eventType.getRaw().getName().equals(Promise.class.getName())) {
                    return "new Handler<" + CodeGenHelper.genTypeName(eventType) + ">() {\n          public void handle(" + CodeGenHelper.genTypeName(eventType) + " event) {\n            " + expr + ".subscribe().with(it -> event.complete(it), failure -> event.fail(failure));\n          }\n      }";
                }
                return "io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(" + expr + ", event -> " + CodeGenHelper.genConvReturn(methodTypeArgMap, eventType, method, "event") + ")";
            }
            if (kind == ClassKind.FUNCTION) {
                TypeInfo argType = parameterizedTypeInfo.getArg(0);
                TypeInfo retType = parameterizedTypeInfo.getArg(1);
                String translatedReturnedType = CodeGenHelper.genTranslatedTypeName(retType);
                if (translatedReturnedType.startsWith("io.smallrye.mutiny.Uni<")) {
                    return CodeGenHelper.generatingAFunctionReturningAFuture(methodTypeArgMap, method, expr, argType, retType);
                }
                return "new java.util.function.Function<" + CodeGenHelper.genTypeName(argType) + "," + retType.getName() + ">() {\n      public " + CodeGenHelper.genTypeName(retType) + " apply(" + CodeGenHelper.genTypeName(argType) + " arg) {\n        " + translatedReturnedType + " ret = " + expr + ".apply(" + CodeGenHelper.genConvReturn(methodTypeArgMap, argType, method, "arg") + ");\n        return " + CodeGenHelper.genConvParam(methodTypeArgMap, retType, method, "ret") + ";\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + CodeGenHelper.genConvParam(methodTypeArgMap, parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(java.util.stream.Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(java.util.stream.Collectors.toMap(e -> e.getKey(), e -> " + CodeGenHelper.genConvParam(methodTypeArgMap, parameterizedTypeInfo.getArg(1), method, "e.getValue()") + "))";
            }
            if (kind == ClassKind.FUTURE) {
                ParameterizedTypeInfo futureType = (ParameterizedTypeInfo)type;
                return expr + ".map(val -> " + CodeGenHelper.genConvParam(methodTypeArgMap, futureType.getArg(0), method, "val") + ")";
            }
        }
        return expr;
    }

    private static String generatingAFunctionReturningAFuture(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, MethodInfo method, String expr, TypeInfo argType, TypeInfo retType) {
        boolean appendDelegate = false;
        if (retType.getKind() == ClassKind.FUTURE) {
            ParameterizedTypeInfo ret = (ParameterizedTypeInfo)retType;
            boolean bl = appendDelegate = ret.getArg(0).getKind() == ClassKind.API;
        }
        if (appendDelegate) {
            return "new java.util.function.Function<" + CodeGenHelper.genTypeName(argType) + "," + retType.getName() + ">() {\n      public " + CodeGenHelper.genTypeName(retType) + " apply(" + CodeGenHelper.genTypeName(argType) + " arg) {\n            return io.smallrye.mutiny.vertx.UniHelper.toFuture(\n                 " + expr + ".apply(" + CodeGenHelper.genConvReturn(methodTypeArgMap, argType, method, "arg") + ").map(x -> x.getDelegate())\n            );\n         }\n     }";
        }
        return "new java.util.function.Function<" + CodeGenHelper.genTypeName(argType) + "," + retType.getName() + ">() {\n      public " + CodeGenHelper.genTypeName(retType) + " apply(" + CodeGenHelper.genTypeName(argType) + " arg) {\n            return io.smallrye.mutiny.vertx.UniHelper.toFuture(\n                 " + expr + ".apply(" + CodeGenHelper.genConvReturn(methodTypeArgMap, argType, method, "arg") + ")\n            );\n         }\n     }";
    }

    private static boolean isReified(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return true;
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        return typeArg != null && typeArg.isClassType();
    }

    private static String genTypeArg(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return "__typeArg_" + typeVar.getParam().getIndex();
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        if (typeArg != null) {
            if (typeArg.isClassType()) {
                return TypeArg.class.getName() + ".of(" + typeArg.getParam().getName() + ")";
            }
            return typeArg.getParam().getName() + ".__typeArg_" + typeArg.getIndex();
        }
        return null;
    }

    public static void genTypeArg(TypeInfo arg, MethodInfo method, int depth, StringBuilder sb) {
        ClassKind argKind = arg.getKind();
        if (argKind == ClassKind.API) {
            sb.append("new TypeArg<").append(arg.translateName("mutiny")).append(">(o").append(depth).append(" -> ");
            sb.append(arg.getRaw().translateName("mutiny")).append(".newInstance((").append(arg.getRaw()).append(")o").append(depth);
            if (arg instanceof ParameterizedTypeInfo) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)arg;
                List args = parameterizedType.getArgs();
                for (int i = 0; i < args.size(); ++i) {
                    sb.append(", ");
                    CodeGenHelper.genTypeArg((TypeInfo)args.get(i), method, depth + 1, sb);
                }
            }
            sb.append(")");
            sb.append(", o").append(depth).append(" -> o").append(depth).append(".getDelegate())");
        } else {
            String resolved;
            String typeArg = "TypeArg.unknown()";
            if (argKind == ClassKind.OBJECT && arg.isVariable() && (resolved = CodeGenHelper.genTypeArg((TypeVariableInfo)arg, method)) != null) {
                typeArg = resolved;
            }
            sb.append(typeArg);
        }
    }

    private static String genTypeArg(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, TypeInfo arg, MethodInfo method) {
        String typeArgRef;
        Map<TypeInfo, String> typeArgMap = methodTypeArgMap.get(method);
        if (typeArgMap != null && (typeArgRef = typeArgMap.get(arg)) != null) {
            return typeArgRef;
        }
        StringBuilder sb = new StringBuilder();
        CodeGenHelper.genTypeArg(arg, method, 0, sb);
        return sb.toString();
    }

    private static void fail(String m) {
    }

    public static String writeReturnStatementForApi(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, TypeInfo type, MethodInfo method, String expr) {
        StringBuilder tmp = new StringBuilder(type.getRaw().translateName("mutiny"));
        tmp.append(".newInstance((");
        tmp.append(type.getRaw());
        tmp.append(")");
        tmp.append(expr);
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            for (TypeInfo arg : parameterizedTypeInfo.getArgs()) {
                tmp.append(", ");
                tmp.append(CodeGenHelper.genTypeArg(methodTypeArgMap, arg, method));
            }
        }
        tmp.append(")");
        return tmp.toString();
    }

    public static String genConvReturn(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, TypeInfo type, MethodInfo method, String expr) {
        ClassKind kind = type.getKind();
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = CodeGenHelper.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return "(" + type.getName() + ")" + typeArg + ".wrap(" + expr + ")";
            }
            return "(" + type.getSimpleName() + ") " + expr;
        }
        if (CodeGenHelper.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.API) {
            return CodeGenHelper.writeReturnStatementForApi(methodTypeArgMap, type, method, expr);
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo abc = parameterizedTypeInfo.getArg(0);
                if (abc.getKind() == ClassKind.ASYNC_RESULT) {
                    TypeInfo tutu = ((ParameterizedTypeInfo)abc).getArg(0);
                    return "new Handler<AsyncResult<" + CodeGenHelper.genTranslatedTypeName(tutu) + ">>() {\n      public void handle(AsyncResult<" + CodeGenHelper.genTranslatedTypeName(tutu) + "> ar) {\n        if (ar.succeeded()) {\n          " + expr + ".handle(io.vertx.core.Future.succeededFuture(" + CodeGenHelper.genConvParam(methodTypeArgMap, tutu, method, "ar.result()") + "));\n        } else {\n          " + expr + ".handle(io.vertx.core.Future.failedFuture(ar.cause()));\n        }\n      }\n    }";
                }
                return "new Handler<" + CodeGenHelper.genTranslatedTypeName(abc) + ">() {\n      public void handle(" + CodeGenHelper.genTranslatedTypeName(abc) + " event) {\n          " + expr + ".handle(" + CodeGenHelper.genConvParam(methodTypeArgMap, abc, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + CodeGenHelper.genConvReturn(methodTypeArgMap, parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(java.util.stream.Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> " + CodeGenHelper.genConvReturn(methodTypeArgMap, parameterizedTypeInfo.getArg(1), method, "_e.getValue()") + "))";
            }
            if (kind == ClassKind.FUTURE) {
                ParameterizedTypeInfo futureType = (ParameterizedTypeInfo)type;
                return expr + ".map(val -> " + CodeGenHelper.genConvReturn(methodTypeArgMap, futureType.getArg(0), method, "val") + ")";
            }
        }
        return expr;
    }

    static String genOptTypeParamsDecl(ClassTypeInfo type, String deflt) {
        if (type.getParams().size() > 0) {
            return type.getParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">"));
        }
        return deflt;
    }

    public static String renderLinkToHtml(Tag.Link link) {
        ClassTypeInfo rawType = link.getTargetType().getRaw();
        if (rawType.getModule() != null) {
            String label = link.getLabel().trim();
            if (rawType.getKind() == ClassKind.API) {
                Element elt = link.getTargetElement();
                String eltKind = elt.getKind().name();
                String ret = "{@link " + rawType.translateName("mutiny");
                if ("METHOD".equals(eltKind)) {
                    ret = ret + "#" + elt.getSimpleName().toString();
                }
                if (label.length() > 0) {
                    ret = ret + " " + label;
                }
                ret = ret + "}";
                return ret;
            }
        }
        return "{@link " + rawType.getName() + "}";
    }

    public static String renderLinkToHtml(ClassTypeInfo owner, MethodInfo method) {
        if (owner.getKind() == ClassKind.API) {
            String ret = "{@link " + owner.translateName("mutiny");
            ret = ret + "#" + method.getName();
            if (!method.getParams().isEmpty()) {
                ret = ret + "(" + method.getParams().stream().map(p -> {
                    TypeInfo type = p.getType();
                    if (type.getKind() == ClassKind.API) {
                        return type.translateName("mutiny");
                    }
                    return type.getSimpleName();
                }).collect(Collectors.joining(",")) + ")";
            }
            ret = ret + "}";
            return ret;
        }
        return "{@link " + owner.getName() + "}";
    }
}

