/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.formatter.Edit;
import io.spring.javaformat.formatter.FileFormatterException;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.eclipse.text.edits.TextEdit;

public class FileEdit
extends Edit {
    private final File file;
    private final Charset encoding;

    FileEdit(File file, Charset encoding, String originalContent, TextEdit textEdit) {
        super(originalContent, textEdit);
        this.file = file;
        this.encoding = encoding;
    }

    public File getFile() {
        return this.file;
    }

    public void save() {
        try {
            String formattedContent = this.getFormattedContent();
            byte[] bytes = formattedContent.getBytes(this.encoding);
            Files.write(this.file.toPath(), bytes, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception ex) {
            throw FileFormatterException.wrap(this.file, ex);
        }
    }

    @Override
    public String getFormattedContent() throws Exception {
        try {
            return super.getFormattedContent();
        }
        catch (Exception ex) {
            throw FileFormatterException.wrap(this.file, ex);
        }
    }
}

