/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.problem;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CategorizedProblem;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.problem.ProblemReporter;

public class DefaultProblem
extends CategorizedProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    public int column;
    public int severity;
    private String[] arguments;
    private String message;
    public static final Object[] EMPTY_VALUES = new Object[0];

    public DefaultProblem(char[] originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line, int column) {
        this.fileName = originatingFileName;
        this.message = message;
        this.id = id;
        this.arguments = stringArguments;
        this.severity = severity;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.line = line;
        this.column = column;
    }

    @Override
    public String[] getArguments() {
        return this.arguments;
    }

    @Override
    public int getCategoryID() {
        return ProblemReporter.getProblemCategory(this.severity, this.id);
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getMarkerType() {
        return this.id == 536871362 ? "io.spring.javaformat.eclipse.jdt.jdk8.core.task" : "io.spring.javaformat.eclipse.jdt.jdk8.core.problem";
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getSourceEnd() {
        return this.endPosition;
    }

    @Override
    public int getSourceLineNumber() {
        return this.line;
    }

    @Override
    public int getSourceStart() {
        return this.startPosition;
    }

    @Override
    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    @Override
    public boolean isWarning() {
        return (this.severity & 1) == 0 && (this.severity & 0x400) == 0;
    }

    public void setOriginatingFileName(char[] fileName) {
        this.fileName = fileName;
    }

    @Override
    public void setSourceEnd(int sourceEnd) {
        this.endPosition = sourceEnd;
    }

    @Override
    public void setSourceLineNumber(int lineNumber) {
        this.line = lineNumber;
    }

    @Override
    public void setSourceStart(int sourceStart) {
        this.startPosition = sourceStart;
    }

    public String toString() {
        String s = "Pb(" + (this.id & 0x1FFFFF) + ") ";
        if (this.message != null) {
            s = String.valueOf(s) + this.message;
        } else if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + " " + this.arguments[i];
                ++i;
            }
        }
        return s;
    }
}

