/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaModel;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModularClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.WorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.AutomaticModuleNaming;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.AbstractModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CompilationUnitElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModel;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.Openable;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.OpenableElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragmentRootInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.SourceMapper;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.MementoTokenizer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class PackageFragmentRoot
extends Openable
implements IPackageFragmentRoot {
    protected IResource resource;

    protected PackageFragmentRoot(IResource resource, JavaProject project) {
        super(project);
        this.resource = resource;
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        ((PackageFragmentRootInfo)info).setRootKind(this.determineKind(underlyingResource));
        return this.computeChildren(info, underlyingResource);
    }

    SourceMapper createSourceMapper(IPath sourcePath, IPath rootPath) throws JavaModelException {
        IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(this.getPath());
        String encoding = entry == null ? null : ((ClasspathEntry)entry).getSourceAttachmentEncoding();
        SourceMapper mapper = new SourceMapper(sourcePath, rootPath == null ? null : rootPath.toOSString(), this.getJavaProject().getOptions(true), encoding);
        return mapper;
    }

    protected boolean computeChildren(OpenableElementInfo info, IResource underlyingResource) throws JavaModelException {
        try {
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                char[][] exclusionPatterns;
                IContainer rootFolder;
                ArrayList vChildren = new ArrayList(5);
                char[][] inclusionPatterns = this.fullInclusionPatternChars();
                this.computeFolderChildren(rootFolder, !Util.isExcluded((IResource)(rootFolder = (IContainer)underlyingResource), inclusionPatterns, exclusionPatterns = this.fullExclusionPatternChars()), CharOperation.NO_STRINGS, vChildren, inclusionPatterns, exclusionPatterns);
                if (!vChildren.isEmpty()) {
                    IJavaElement[] children = new IJavaElement[vChildren.size()];
                    vChildren.toArray(children);
                    info.setChildren(children);
                } else {
                    info.setChildren(JavaElement.NO_ELEMENTS);
                }
            }
        }
        catch (JavaModelException e) {
            info.setChildren(new IJavaElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, boolean isIncluded, String[] pkgName, ArrayList vChildren, char[][] inclusionPatterns, char[][] exclusionPatterns) throws JavaModelException {
        if (isIncluded) {
            PackageFragment pkg = this.getPackageFragment(pkgName);
            vChildren.add(pkg);
        }
        try {
            IResource[] members = folder.members();
            boolean hasIncluded = isIncluded;
            int length = members.length;
            if (length > 0) {
                IJavaProject otherJavaProject = JavaCore.create(folder.getProject());
                String sourceLevel = otherJavaProject.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.source", true);
                String complianceLevel = otherJavaProject.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.compliance", true);
                JavaProject javaProject = (JavaProject)this.getJavaProject();
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                int i = 0;
                while (i < length) {
                    IResource member = members[i];
                    String memberName = member.getName();
                    switch (member.getType()) {
                        case 2: {
                            if (!Util.isValidFolderNameForPackage(memberName, sourceLevel, complianceLevel) || !javaProject.contains(member)) break;
                            String[] newNames = Util.arrayConcat(pkgName, manager.intern(memberName));
                            boolean isMemberIncluded = !Util.isExcluded(member, inclusionPatterns, exclusionPatterns);
                            this.computeFolderChildren((IContainer)((IFolder)member), isMemberIncluded, newNames, vChildren, inclusionPatterns, exclusionPatterns);
                            break;
                        }
                        case 1: {
                            if (hasIncluded || !Util.isValidCompilationUnitName(memberName, sourceLevel, complianceLevel) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) break;
                            hasIncluded = true;
                            PackageFragment pkg = this.getPackageFragment(pkgName);
                            vChildren.add(pkg);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new JavaModelException(e, 969);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    @Override
    protected Object createElementInfo() {
        return new PackageFragmentRootInfo();
    }

    protected int determineKind(IResource underlyingResource) throws JavaModelException {
        IClasspathEntry entry = ((JavaProject)this.getJavaProject()).getClasspathEntryFor(underlyingResource.getFullPath());
        if (entry != null) {
            return entry.getContentKind();
        }
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragmentRoot)) {
            return false;
        }
        PackageFragmentRoot other = (PackageFragmentRoot)o;
        return this.resource().equals((Object)other.resource()) && this.parent.equals(other.parent);
    }

    private IClasspathEntry findSourceAttachmentRecommendation() {
        try {
            IClasspathEntry entry;
            IPath rootPath = this.getPath();
            JavaProject parentProject = (JavaProject)this.getJavaProject();
            try {
                Object target;
                entry = parentProject.getClasspathEntryFor(rootPath);
                if (entry != null && (target = JavaModel.getTarget(entry.getSourceAttachmentPath(), true)) != null) {
                    return entry;
                }
            }
            catch (JavaModelException javaModelException) {}
            IJavaModel model = this.getJavaModel();
            IJavaProject[] jProjects = model.getJavaProjects();
            int i = 0;
            int max = jProjects.length;
            while (i < max) {
                JavaProject jProject = (JavaProject)jProjects[i];
                if (jProject != parentProject) {
                    try {
                        Object target;
                        entry = jProject.getClasspathEntryFor(rootPath);
                        if (entry != null && (target = JavaModel.getTarget(entry.getSourceAttachmentPath(), true)) != null) {
                            return entry;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public char[][] fullExclusionPatternChars() {
        ClasspathEntry entry;
        block5: {
            block4: {
                try {
                    if (!this.isOpen() || this.getKind() == 1) break block4;
                    return null;
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            entry = (ClasspathEntry)this.getRawClasspathEntry();
            if (entry != null) break block5;
            return null;
        }
        return entry.fullExclusionPatternChars();
    }

    public char[][] fullInclusionPatternChars() {
        ClasspathEntry entry;
        block5: {
            block4: {
                try {
                    if (!this.isOpen() || this.getKind() == 1) break block4;
                    return null;
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            entry = (ClasspathEntry)this.getRawClasspathEntry();
            if (entry != null) break block5;
            return null;
        }
        return entry.fullInclusionPatternChars();
    }

    @Override
    public String getElementName() {
        IResource res = this.resource();
        if (res instanceof IFolder) {
            return ((IFolder)res).getName();
        }
        return "";
    }

    @Override
    public int getElementType() {
        return 3;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String[] pkgName;
                if (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    char firstChar = token.charAt(0);
                    if (firstChar == '(' || firstChar == '\'' || firstChar == '{' || firstChar == '!') {
                        pkgName = CharOperation.NO_STRINGS;
                    } else {
                        pkgName = Util.splitOn('.', token, 0, token.length());
                        token = null;
                    }
                } else {
                    pkgName = CharOperation.NO_STRINGS;
                    token = null;
                }
                PackageFragment pkg = this.getPackageFragment(pkgName);
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return ((JavaElement)pkg).getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        IResource underlyingResource = this.getResource();
        IPath path = underlyingResource != null ? (this.resource().getProject().equals((Object)this.getJavaProject().getProject()) ? underlyingResource.getProjectRelativePath() : underlyingResource.getFullPath()) : this.getPath();
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, path.toString());
        if (io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.Util.isJrt(path.toOSString())) {
            buff.append('`');
            this.escapeMementoName(buff, this.getElementName());
        }
        try {
            IClasspathEntry entry = this.getJavaProject().getClasspathEntryFor(this.getPath());
            if (entry != null) {
                IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
                int n = iClasspathAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathAttribute attribute = iClasspathAttributeArray[n2];
                    this.appendEscapedDelimiter(buff, '/');
                    this.escapeMementoName(buff, attribute.getName());
                    this.appendEscapedDelimiter(buff, '/');
                    this.escapeMementoName(buff, attribute.getValue());
                    this.appendEscapedDelimiter(buff, '/');
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    public int getKind() throws JavaModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getRootKind();
    }

    int internalKind() throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        PackageFragmentRootInfo info = (PackageFragmentRootInfo)manager.peekAtInfo(this);
        if (info == null) {
            info = (PackageFragmentRootInfo)this.openWhenClosed(this.createElementInfo(), false, null);
        }
        return info.getRootKind();
    }

    @Override
    public IPackageFragment getPackageFragment(String packageName) {
        String[] pkgName = Util.getTrimmedSimpleNames(packageName);
        return this.getPackageFragment(pkgName);
    }

    public PackageFragment getPackageFragment(String[] pkgName) {
        return new PackageFragment(this, pkgName);
    }

    public PackageFragment getPackageFragment(String[] pkgName, String mod) {
        return new PackageFragment(this, pkgName);
    }

    @Override
    public IPath getPath() {
        return this.internalPath();
    }

    public IPath internalPath() {
        return this.resource().getFullPath();
    }

    @Override
    public IClasspathEntry getRawClasspathEntry() throws JavaModelException {
        IClasspathEntry rawEntry = null;
        JavaProject project = (JavaProject)this.getJavaProject();
        project.getResolvedClasspath();
        Map<IPath, IClasspathEntry> rootPathToRawEntries = project.getPerProjectInfo().rootPathToRawEntries;
        if (rootPathToRawEntries != null) {
            rawEntry = rootPathToRawEntries.get(this.getPath());
        }
        if (rawEntry == null) {
            throw new JavaModelException(new JavaModelStatus(1006, this));
        }
        return rawEntry;
    }

    @Override
    public IClasspathEntry getResolvedClasspathEntry() throws JavaModelException {
        IClasspathEntry resolvedEntry = null;
        JavaProject project = (JavaProject)this.getJavaProject();
        project.getResolvedClasspath();
        Map<IPath, IClasspathEntry> rootPathToResolvedEntries = project.getPerProjectInfo().rootPathToResolvedEntries;
        if (rootPathToResolvedEntries != null) {
            resolvedEntry = rootPathToResolvedEntries.get(this.getPath());
        }
        if (resolvedEntry == null) {
            throw new JavaModelException(new JavaModelStatus(1006, this));
        }
        return resolvedEntry;
    }

    @Override
    public IResource resource() {
        if (this.resource != null) {
            return this.resource;
        }
        return super.resource();
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        return this.resource;
    }

    public IPath getSourceAttachmentPath() throws JavaModelException {
        IPath sourceAttachmentPath;
        if (this.getKind() != 2) {
            return null;
        }
        IPath path = this.getPath();
        String serverPathString = Util.getSourceAttachmentProperty(path);
        if (serverPathString != null) {
            int index = serverPathString.lastIndexOf(42);
            if (index < 0) {
                return new Path(serverPathString);
            }
            String serverSourcePathString = serverPathString.substring(0, index);
            return new Path(serverSourcePathString);
        }
        IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(path);
        if (entry != null && (sourceAttachmentPath = entry.getSourceAttachmentPath()) != null) {
            return sourceAttachmentPath;
        }
        entry = this.findSourceAttachmentRecommendation();
        if (entry != null && (sourceAttachmentPath = entry.getSourceAttachmentPath()) != null) {
            return sourceAttachmentPath;
        }
        return null;
    }

    public IPath getSourceAttachmentRootPath() throws JavaModelException {
        IPath sourceAttachmentRootPath;
        if (this.getKind() != 2) {
            return null;
        }
        IPath path = this.getPath();
        String serverPathString = Util.getSourceAttachmentProperty(path);
        if (serverPathString != null) {
            int index = serverPathString.lastIndexOf(42);
            if (index == -1) {
                return null;
            }
            String serverRootPathString = "";
            if (index != serverPathString.length() - 1) {
                serverRootPathString = serverPathString.substring(index + 1);
            }
            return new Path(serverRootPathString);
        }
        IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(path);
        if (entry != null && (sourceAttachmentRootPath = entry.getSourceAttachmentRootPath()) != null) {
            return sourceAttachmentRootPath;
        }
        entry = this.findSourceAttachmentRecommendation();
        if (entry != null && (sourceAttachmentRootPath = entry.getSourceAttachmentRootPath()) != null) {
            return sourceAttachmentRootPath;
        }
        return null;
    }

    @Override
    public SourceMapper getSourceMapper() {
        SourceMapper mapper;
        try {
            PackageFragmentRootInfo rootInfo = (PackageFragmentRootInfo)this.getElementInfo();
            mapper = rootInfo.getSourceMapper();
            if (mapper == null) {
                IPath sourcePath = this.getSourceAttachmentPath();
                IPath rootPath = this.getSourceAttachmentRootPath();
                mapper = sourcePath == null ? this.createSourceMapper(this.getPath(), rootPath) : this.createSourceMapper(sourcePath, rootPath);
                rootInfo.setSourceMapper(mapper);
            }
        }
        catch (JavaModelException javaModelException) {
            mapper = null;
        }
        return mapper;
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.resource();
    }

    @Override
    public boolean hasChildren() throws JavaModelException {
        return true;
    }

    @Override
    public int hashCode() {
        return this.resource().hashCode();
    }

    public boolean ignoreOptionalProblems() {
        try {
            return ((PackageFragmentRootInfo)this.getElementInfo()).ignoreOptionalProblems(this);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    protected IStatus validateOnClasspath() {
        IPath path = this.getPath();
        try {
            JavaProject project = (JavaProject)this.getJavaProject();
            IClasspathEntry entry = project.getClasspathEntryFor(path);
            if (entry != null) {
                return Status.OK_STATUS;
            }
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        return new JavaModelStatus(1006, this);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        IPath path = this.getPath();
        if (this.isExternal()) {
            buffer.append(path.toOSString());
        } else if (this.getJavaProject().getElementName().equals(path.segment(0))) {
            if (path.segmentCount() == 1) {
                buffer.append("<project root>");
            } else {
                buffer.append(path.removeFirstSegments(1).makeRelative());
            }
        } else {
            buffer.append(path);
        }
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    protected IStatus validateExistence(IResource underlyingResource) {
        IStatus status = this.validateOnClasspath();
        if (!status.isOK()) {
            return status;
        }
        if (!this.resourceExists(underlyingResource)) {
            return this.newDoesNotExistStatus();
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public String getClassFilePath(String classname) {
        return classname;
    }

    @Override
    public IModuleDescription getModuleDescription() {
        if (this.isComplianceJava9OrHigher()) {
            return this.getSourceModuleDescription();
        }
        return null;
    }

    private IModuleDescription getSourceModuleDescription() {
        try {
            IJavaElement[] pkgs = this.getChildren();
            int j = 0;
            int length = pkgs.length;
            while (j < length) {
                if (pkgs[j].getElementName().length() == 0) {
                    CompilationUnitElementInfo info = null;
                    if (this.getKind() == 1) {
                        ICompilationUnit unit = ((PackageFragment)pkgs[j]).getCompilationUnit("module-info.java");
                        if (unit instanceof CompilationUnit && unit.exists() && (info = (CompilationUnitElementInfo)((CompilationUnit)unit).getElementInfo()) != null) {
                            return info.getModule();
                        }
                    } else {
                        IModularClassFile classFile = ((IPackageFragment)pkgs[j]).getModularClassFile();
                        if (classFile.exists()) {
                            return classFile.getModule();
                        }
                    }
                    break;
                }
                ++j;
            }
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e));
        }
        return null;
    }

    public IModuleDescription getAutomaticModuleDescription() throws JavaModelException {
        return this.getAutomaticModuleDescription(this.getResolvedClasspathEntry());
    }

    IModuleDescription getAutomaticModuleDescription(IClasspathEntry classpathEntry) {
        String elementName = this.getElementName();
        Manifest manifest = null;
        switch (classpathEntry.getEntryKind()) {
            case 3: {
                manifest = ((JavaProject)this.getJavaProject()).getManifest();
                elementName = this.getJavaProject().getElementName();
                break;
            }
            case 1: {
                manifest = this.getManifest();
                break;
            }
            case 2: {
                JavaProject javaProject = (JavaProject)this.getJavaModel().getJavaProject(classpathEntry.getPath().lastSegment());
                manifest = javaProject.getManifest();
                elementName = javaProject.getElementName();
            }
        }
        boolean nameFromManifest = true;
        char[] moduleName = AutomaticModuleNaming.determineAutomaticModuleNameFromManifest(manifest);
        if (moduleName == null) {
            nameFromManifest = false;
            moduleName = AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(elementName, true, this.isArchive());
        }
        return new AbstractModule.AutoModule(this, String.valueOf(moduleName), nameFromManifest);
    }

    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        IPackageFragment fragment = this.getPackageFragment(qualifiedPackageName.replace('/', '.'));
        try {
            if (fragment.exists()) {
                return fragment.containsJavaResources();
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public Manifest getManifest() {
        return null;
    }

    protected boolean isComplianceJava9OrHigher() {
        IJavaProject javaProject = this.getJavaProject();
        return PackageFragmentRoot.isComplianceJava9OrHigher(javaProject);
    }

    private static boolean isComplianceJava9OrHigher(IJavaProject javaProject) {
        if (javaProject == null) {
            return false;
        }
        return CompilerOptions.versionToJdkLevel(javaProject.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.compliance", true)) >= 0x350000L;
    }
}

