/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.IJavaSearchScope;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.TypeNameMatchRequestor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.AccessRestriction;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.HierarchyScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.IRestrictedAccessTypeRequestor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.JavaSearchTypeNameMatch;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.NameMatchRequestorWrapper;

public class TypeNameMatchRequestorWrapper
extends NameMatchRequestorWrapper
implements IRestrictedAccessTypeRequestor {
    TypeNameMatchRequestor requestor;

    public TypeNameMatchRequestorWrapper(TypeNameMatchRequestor requestor, IJavaSearchScope scope) {
        super(scope);
        this.requestor = requestor;
    }

    @Override
    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
        IType type = this.getType(modifiers, packageName, simpleTypeName, enclosingTypeNames, path, access);
        if (type != null && (!(this.scope instanceof HierarchyScope) || ((HierarchyScope)this.scope).enclosesFineGrained(type))) {
            JavaSearchTypeNameMatch match = new JavaSearchTypeNameMatch(type, modifiers);
            if (access != null) {
                switch (access.getProblemId()) {
                    case 0x1000133: {
                        match.setAccessibility(1);
                        break;
                    }
                    case 0x1000118: {
                        match.setAccessibility(2);
                    }
                }
            }
            this.requestor.acceptTypeNameMatch(match);
        }
    }
}

