/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IAnnotationComponent;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IAnnotationComponentValue;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.AnnotationComponentValue;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileStruct;

public class AnnotationComponent
extends ClassFileStruct
implements IAnnotationComponent {
    private int componentNameIndex;
    private char[] componentName;
    private IAnnotationComponentValue componentValue;
    private int readOffset;

    public AnnotationComponent(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int nameIndex;
        this.componentNameIndex = nameIndex = this.u2At(classFileBytes, 0, offset);
        if (nameIndex != 0) {
            IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(nameIndex);
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.componentName = constantPoolEntry.getUtf8Value();
        }
        this.readOffset = 2;
        AnnotationComponentValue value = new AnnotationComponentValue(classFileBytes, constantPool, offset + this.readOffset);
        this.componentValue = value;
        this.readOffset += value.sizeInBytes();
    }

    @Override
    public int getComponentNameIndex() {
        return this.componentNameIndex;
    }

    @Override
    public char[] getComponentName() {
        return this.componentName;
    }

    @Override
    public IAnnotationComponentValue getComponentValue() {
        return this.componentValue;
    }

    int sizeInBytes() {
        return this.readOffset;
    }
}

