/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.javassist;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.common.javassist.FieldConfig;
import org.apache.servicecomb.common.javassist.MethodConfig;

public class ClassConfig {
    private String className;
    private boolean intf;
    private List<String> intfList = new ArrayList<String>();
    private List<FieldConfig> fieldList = new ArrayList<FieldConfig>();
    private List<MethodConfig> methodList = new ArrayList<MethodConfig>();

    public boolean isIntf() {
        return this.intf;
    }

    public void setIntf(boolean intf) {
        this.intf = intf;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addInterface(Class<?> intf) {
        this.addInterface(intf.getName());
    }

    public void addInterface(String intf) {
        this.intfList.add(intf);
    }

    public List<String> getIntfList() {
        return this.intfList;
    }

    public List<FieldConfig> getFieldList() {
        return this.fieldList;
    }

    public FieldConfig addField(String name, Type genericType) {
        return this.addField(name, TypeFactory.defaultInstance().constructType(genericType));
    }

    public FieldConfig addField(String name, JavaType javaType) {
        FieldConfig field = new FieldConfig();
        field.setName(name);
        field.setType(javaType);
        this.fieldList.add(field);
        return field;
    }

    public void addMethod(MethodConfig methodConfig) {
        methodConfig.init();
        this.methodList.add(methodConfig);
    }

    public void addMethod(String source) {
        this.addMethod(source, null);
    }

    public void addMethod(String source, String genericSignature) {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setSource(source);
        methodConfig.setGenericSignature(genericSignature);
        this.addMethod(methodConfig);
    }

    public List<MethodConfig> getMethodList() {
        return this.methodList;
    }
}

