/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.javassist;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.servicecomb.common.javassist.ClassConfig;
import org.apache.servicecomb.common.javassist.FieldConfig;
import org.apache.servicecomb.common.javassist.MethodConfig;
import org.apache.servicecomb.common.javassist.MultiWrapper;
import org.apache.servicecomb.common.javassist.SingleWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public final class JavassistUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavassistUtils.class);
    private static final Map<ClassLoader, ClassPool> CLASSPOOLS = new IdentityHashMap<ClassLoader, ClassPool>();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassPool getOrCreateClassPool(ClassLoader classLoader) {
        ClassPool classPool = CLASSPOOLS.get(classLoader);
        if (classPool == null) {
            Object object = LOCK;
            synchronized (object) {
                classPool = CLASSPOOLS.get(classLoader);
                if (classPool == null) {
                    classPool = new ClassPool(null);
                    classPool.appendSystemPath();
                    classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
                    CLASSPOOLS.put(classLoader, classPool);
                }
            }
        }
        return classPool;
    }

    public static void clearByClassLoader(ClassLoader classLoader) {
        CLASSPOOLS.remove(classLoader);
    }

    private JavassistUtils() {
    }

    public static Class<? extends Enum> createEnum(String clsName, String ... values) {
        return JavassistUtils.createEnum(null, clsName, Arrays.asList(values));
    }

    public static Class<? extends Enum> createEnum(String clsName, List<String> values) {
        return JavassistUtils.createEnum(null, clsName, values);
    }

    public static Class<? extends Enum> getOrCreateEnumWithPackageName(ClassLoader classLoader, String packageName, List<String> enums) {
        String strEnums = enums.toString();
        String enumClsName = packageName + ".Enum_" + Hashing.sha256().hashString((CharSequence)strEnums, StandardCharsets.UTF_8).toString();
        return JavassistUtils.getOrCreateEnumWithClassName(classLoader, enumClsName, enums);
    }

    public static synchronized Class<? extends Enum> getOrCreateEnumWithClassName(ClassLoader classLoader, String clsName, List<String> values) {
        try {
            return classLoader.loadClass(clsName);
        }
        catch (ClassNotFoundException e) {
            return JavassistUtils.createEnum(classLoader, clsName, values);
        }
    }

    public static Class<? extends Enum> createEnum(ClassLoader classLoader, String clsName, List<String> values) {
        if (values == null || values.size() == 0) {
            throw new Error("values is not allowed empty.");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ClassPool classPool = JavassistUtils.getOrCreateClassPool(classLoader);
        CtClass ctClass = classPool.makeClass(clsName);
        ctClass.setModifiers(ctClass.getModifiers() | 0x4000);
        try {
            ctClass.setSuperclass(classPool.get(Enum.class.getName()));
            JavassistUtils.addEnumConstructor(classPool, ctClass);
            JavassistUtils.addEnumValuesMethod(ctClass, values);
            return ctClass.toClass(classLoader, null);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    private static void addEnumConstructor(ClassPool classPool, CtClass ctClass) throws Exception {
        String src = "super($1, $2);";
        CtConstructor ctConstructor = new CtConstructor(classPool.get(new String[]{String.class.getName(), Integer.TYPE.getName()}), ctClass);
        ctConstructor.setBody(src);
        ctClass.addConstructor(ctConstructor);
    }

    private static void addEnumValuesMethod(CtClass ctClass, List<String> values) throws CannotCompileException {
        StringBuilder sb = new StringBuilder();
        sb.append("public static Enum[] values(){return new Enum[]{");
        for (int idx = 0; idx < values.size(); ++idx) {
            String value = values.get(idx);
            String line = String.format("new %s(\"%s\", %d),", ctClass.getName(), value, idx);
            sb.append(line);
        }
        sb.setLength(sb.length() - 1);
        sb.append("};}");
        CtMethod valuesMethod = CtMethod.make((String)sb.toString(), (CtClass)ctClass);
        ctClass.addMethod(valuesMethod);
    }

    public static Class<?> createClass(ClassConfig config) {
        return JavassistUtils.createClass(null, config);
    }

    public static Class<?> createClass(ClassLoader classLoader, ClassConfig config) {
        ClassPool classPool;
        CtClass ctClass;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((ctClass = (classPool = JavassistUtils.getOrCreateClassPool(classLoader)).getOrNull(config.getClassName())) == null) {
            ctClass = config.isIntf() ? classPool.makeInterface(config.getClassName()) : classPool.makeClass(config.getClassName());
        }
        try {
            for (String intfName : config.getIntfList()) {
                ctClass.addInterface(classPool.get(intfName));
            }
            for (FieldConfig fieldConfig : config.getFieldList()) {
                CtField field = JavassistUtils.createCtField(classPool, ctClass, fieldConfig);
                ctClass.addField(field);
                if (fieldConfig.isGenGetter()) {
                    JavassistUtils.addFieldGetter(config, fieldConfig);
                }
                if (!fieldConfig.isGenSetter()) continue;
                JavassistUtils.addFieldSetter(config, fieldConfig);
            }
            for (MethodConfig methodConfig : config.getMethodList()) {
                try {
                    CtMethod ctMethod = CtMethod.make((String)methodConfig.getSource(), (CtClass)ctClass);
                    if (methodConfig.getGenericSignature() != null) {
                        ctMethod.setGenericSignature(methodConfig.getGenericSignature());
                    }
                    ctClass.addMethod(ctMethod);
                }
                catch (CannotCompileException e) {
                    LOGGER.error("Failed to create method, source:\n{}.", (Object)methodConfig.getSource());
                    throw e;
                }
            }
            LOGGER.info("generate {} in classLoader {}.", (Object)config.getClassName(), (Object)classLoader);
            return ctClass.toClass(classLoader, null);
        }
        catch (Throwable e) {
            throw new Error(String.format("Failed to create %s in classLoader %s.", config.getClassName(), classLoader), e);
        }
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private static void addFieldGetter(ClassConfig config, FieldConfig fieldConfig) {
        MethodConfig methodConfig = new MethodConfig();
        Class<?> cls = fieldConfig.getRawType();
        String prefix = "get";
        if (cls.equals(Boolean.class) || cls.equals(Boolean.TYPE)) {
            prefix = "is";
        }
        methodConfig.setName(prefix + JavassistUtils.capitalize(fieldConfig.getName()));
        methodConfig.setResult(fieldConfig.getType());
        methodConfig.setBodySource("return " + fieldConfig.getName() + ";");
        config.addMethod(methodConfig);
    }

    private static void addFieldSetter(ClassConfig config, FieldConfig fieldConfig) {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("set" + JavassistUtils.capitalize(fieldConfig.getName()));
        methodConfig.addParameter(fieldConfig.getName(), fieldConfig.getType());
        methodConfig.setBodySource(" this." + fieldConfig.getName() + " = " + fieldConfig.getName() + ";");
        config.addMethod(methodConfig);
    }

    public static void genMultiWrapperInterface(ClassConfig config) {
        try {
            config.addInterface(MultiWrapper.class);
            config.addMethod(JavassistUtils.genReadFieldsMethodSource(config.getFieldList()));
            config.addMethod(JavassistUtils.genWriteFieldsMethodSource(config.getFieldList()));
        }
        catch (Exception e) {
            String msg = String.format("failed to genMultiWrapperInterface, name=%s", config.getClassName());
            LOGGER.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }

    public static void genSingleWrapperInterface(ClassConfig config) {
        try {
            config.addInterface(SingleWrapper.class);
            config.addMethod(JavassistUtils.genReadFieldMethodSource(config.getFieldList()));
            config.addMethod(JavassistUtils.genWriteFieldMethodSource(config.getFieldList()));
        }
        catch (Exception e) {
            String msg = String.format("failed to genSingleWrapperMethod, name=%s", config.getClassName());
            LOGGER.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }

    private static String genReadFieldsMethodSource(List<FieldConfig> fieldList) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("public Object[] readFields(){");
        sb.append(String.format("Object values[] = new Object[%d];", fieldList.size()));
        for (int idx = 0; idx < fieldList.size(); ++idx) {
            String fieldName = fieldList.get(idx).getName();
            String code = String.format("    values[%d] = %s;", idx, fieldName);
            sb.append(code);
        }
        sb.append("return values;");
        sb.append("}");
        return sb.toString();
    }

    private static String genWriteFieldsMethodSource(List<FieldConfig> fieldList) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("public void writeFields(Object[] values){");
        for (int idx = 0; idx < fieldList.size(); ++idx) {
            FieldConfig fieldConfig = fieldList.get(idx);
            String fieldName = fieldConfig.getName();
            Class<?> type = fieldConfig.getRawType();
            String code = String.format("    %s = (%s)values[%d];", fieldName, type.getTypeName(), idx);
            sb.append(code);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String genReadFieldMethodSource(List<FieldConfig> fieldList) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("public Object readField(){");
        String fieldName = "null";
        if (!fieldList.isEmpty()) {
            fieldName = fieldList.get(0).getName();
        }
        sb.append(String.format("    return %s;", fieldName));
        sb.append("}");
        return sb.toString();
    }

    private static String genWriteFieldMethodSource(List<FieldConfig> fieldList) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("public void writeField(Object value){");
        if (!fieldList.isEmpty()) {
            FieldConfig fieldConfig = fieldList.get(0);
            sb.append(String.format("    %s=(%s)value;", fieldConfig.getName(), fieldConfig.getRawType().getTypeName()));
        }
        sb.append("}");
        return sb.toString();
    }

    private static CtField createCtField(ClassPool pool, CtClass ctClass, FieldConfig field) throws Exception {
        Class<?> fieldType = field.getRawType();
        CtField ctField = new CtField(pool.getCtClass(fieldType.getName()), field.getName(), ctClass);
        if (field.getGenericSignature() != null) {
            ctField.setGenericSignature(field.getGenericSignature());
        }
        ctField.setModifiers(1);
        return ctField;
    }

    public static String getNameForGenerateCode(JavaType javaType) {
        if (byte[].class.equals((Object)javaType.getRawClass())) {
            return "byte[]";
        }
        if (!javaType.isArrayType()) {
            Class rawClass = ClassUtils.resolvePrimitiveIfNecessary((Class)javaType.getRawClass());
            return rawClass.getTypeName();
        }
        return javaType.getContentType().getRawClass().getName() + "[]";
    }

    public static void detach(String clsName) {
        try {
            ClassPool classPool = JavassistUtils.getOrCreateClassPool(Thread.currentThread().getContextClassLoader());
            classPool.getCtClass(clsName).detach();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

